<?php
/**
 * The managepriv view file of perfproject module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Zemei Wang <wangzemei@easycorp.ltd>
 * @package     perfproject
 * @link        https://www.zentao.net
 */
namespace zin;

formPanel
(
    set::title($title),
    set::submitBtnText($lang->save),
    formGroup
    (
        set::label($lang->perfproject->acl),
        radioList
        (
            set::inline(true),
            set::name('acl'),
            set::items($lang->perfproject->aclList),
            set::value($project->acl),
            on::change()->toggleClass('.whitelistBox', 'hidden', "\$element.find('[name=acl]:checked').val() === 'open'"),
        )
    ),
    formGroup
    (
        setClass('whitelistBox' . ($project->acl == 'open' ? ' hidden' : '')),
        set::label($lang->whitelist),
        picker
        (
            set::name('whitelist[]'),
            set::value(explode(',', $project->whitelist)),
            set::items($userPairs),
            set::multiple(true)
        )
    )
);
