<?php
/**
 * The browse view file of perfproject module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Zemei Wang <wangzemei@easycorp.ltd>
 * @package     perfproject
 * @link        https://www.zentao.net
 */
namespace zin;

$cols        = $config->perfproject->dtable->fieldList;
$projectList = initTableData($projectList, $cols, $this->perfproject);

foreach ($projectList as &$project)
{
    if(!empty($project->actions))
    {
        $hasEdit = array_filter($project->actions, function($item) {return $item['name'] == 'edit';});
        foreach($project->actions as $actionKey => $action)
        {
            if(empty($hasEdit) && $action['name'] == 'managepriv') unset($project->actions[$actionKey]);
        }
        $project->actions = array_values($project->actions);
    }
}

dtable
(
    set::key('perfprojects'),
    set::cols($cols),
    set::data(array_values($projectList)),
    set::userMap($userPairs),
    set::orderBy($orderBy),
    set::sortLink(inlink('browse', "projectType=$projectType&browseType=$browseType&queryID=0&orderBy={name}_{sortType}&recTotal={$pager->recTotal}&recPerPage={$pager->recPerPage}&pageID={$pager->pageID}")),
    set::footPager(usePager()),
    set::emptyTip($lang->perfproject->notes->emptyProject),
    set::onRenderCell(jsRaw('window.onRenderCell'))
);
