<?php
/**
 * The browse view file of perfproject module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Zemei Wang <wangzemei@easycorp.ltd>
 * @package     perfproject
 * @link        https://www.zentao.net
 */
namespace zin;

$canCreate = common::hasPriv('perfproject', 'create');
featureBar
(
    set::current($browseType),
    set::linkParams("projectType={$projectType}&browseType={key}&queryID=0&orderBy={$orderBy}&recTotal={$pager->recTotal}&recPerPage={$pager->recPerPage}&pageID={$pager->pageID}"),
    li(searchToggle(set::open($browseType == 'bysearch')), set::module('perfproject'))
);

$products      = $this->loadModel('product')->getPairs('nodeleted', 0, '', 0);
$executions    = $this->loadModel('execution')->getPairs();
$tasks         = $this->loadModel('task')->getAllParisForPerf();
$hasStory      = hasPriv('product', 'browse');
$hasBug        = hasPriv('bug', 'browse');
$hasExecution  = hasPriv('project', 'execution');
$hasTask       = hasPriv('execution', 'task');
$hasExecutions = empty($products) && !empty($executions);
$hasTasks      = empty($products) && empty($executions) && !empty($tasks);
$noData        = empty($products) && empty($executions) && empty($tasks);
$noStoryBug    = !$hasStory && !$hasBug;
$showExecution = !empty($executions) && $noStoryBug && $hasExecution;
$noOthers      = !$hasStory && !$hasBug && !$hasExecution;
$showTask      = !empty($tasks) && $hasTask && $noOthers;
$showCreate    = $noOthers && !$hasTask;

$createLink = '';
if(!empty($products) && $hasStory)             $createLink = createLink('product', 'browse', 'productID=0&branch=all&browseType=&param=0&storyType=story&orderBy=&recTotal=0&recPerPage=20&pageID=1&projectID=0&from=perf&blockID=0');
if(!empty($products) && !$hasStory && $hasBug) $createLink = createLink('bug', 'browse', 'productID=0&branch=&browseType=&param=0&orderBy=&recTotal=0&recPerPage=20&pageID=1&from=perf');
if($hasExecutions || $showExecution)           $createLink = createLink('project', 'execution', 'status=undone&projectID=0&orderBy=order_asc&productID=0&recTotal=1&recPerPage=100&pageID=1&queryID=0&from=perf');
if($hasTasks || $showTask)                     $createLink = createLink('execution', 'task', 'execution=0&status=unclosed&param=0&orderBy=&recTotal=0&recPerPage=100&pageID=1&from=perf');
if($noData || $showCreate)                     $createLink = createLink('perfproject', 'create', 'analysisID=0&type=upload');

toolbar
(
    item(set(array
    (
        'type'  => 'btnGroup',
        'items' => array(array
        (
            'icon'  => 'cards-view',
            'class' => $projectType == 'bycard' ? ' text-primary' : '',
            'hint'  => $lang->perfproject->bycard,
            'url'   => createLink('perfproject', 'browse', 'projectType=bycard'),
        ), array
        (
            'icon'  => 'bars',
            'class' => $projectType == 'bylist' ? ' text-primary' : '',
            'hint'  => $lang->perfproject->bylist,
            'url'   => createLink('perfproject', 'browse', 'projectType=bylist'),
        ))
    ))),
    !$canCreate ? null : item(set(array('class' => 'primary', 'url' => $createLink, 'icon' => 'plus', 'text' => $lang->perfproject->create, 'data-toggle' => 'modal', 'data-size' => 'lg')))
);

if($projectType == 'bycard')
{
    include 'browse.card.html.php';
}
else
{
    include 'browse.list.html.php';
}
