<?php
/**
 * The browse view file of perfproject module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Zemei Wang <wangzemei@easycorp.ltd>
 * @package     perfproject
 * @link        https://www.zentao.net
 */
namespace zin;

$projectList = $this->perfprojectZen->processProjectActions($projectList);

if(empty($projectList))
{
    panel(set::bodyClass('h-48 text-gray flex items-center justify-center'), $lang->perfproject->notes->emptyProject);
}
else
{
    $items       = array();
    foreach($projectList as $project)
    {
        $teamMember = explode(',', ",$project->createdBy,$project->whitelist");
        $teamMember = array_values(array_filter($teamMember));

        $count       = 0;
        $userAvatars = array();
        $teamCount   = count($teamMember);
        foreach($teamMember as $member)
        {
            if($count >= 3) break;
            if(empty($userPairs[$member])) continue;
    
            $userAvatars[] = userAvatar(set::account($userPairs[$member]), set::avatar($usersAvatar[$member]), set::realname($userPairs[$member]), set::size('xs'));
            $count ++;
        }

        $desc     = strip_tags(htmlspecialchars_decode($project->desc));
        $isAuthor = $project->createdBy == $this->app->user->account;

        $items[] = div
        (
            setClass('w-1/4 p-1.5'),
            a
            (
                set::href(inlink('firstanalysis', "projectID={$project->id}")),
                div
                (
                    setClass('project-card border border-hover bg-canvas rounded overflow-hidden shadow px-5 py-2 relative'),
                    setStyle(array('height' => '120px')),
                    div
                    (
                        setClass('h-20'),
                        div
                        (
                            setClass('text-fore text-md text-clip font-bold w-5/6'),
                            set::title($project->name),
                            $project->name
                        ),
                        div
                        (
                            setClass('text-gray text-sm line-clamp-2 mt-2'),
                            set::title($desc),
                            $desc
                        )
                    ),
                    div
                    (
                        setClass('flex items-center'),
                        cell(setClass('flex items-center mr-1'), $userAvatars),
                        cell
                        (
                            setClass('text-gray'),
                            sprintf($this->lang->perfproject->teamDesc, count($teamMember)),
                            icon(setClass('ml-1'), 'lock'),
                        ),
                        cell(setClass('flex-1 text-right text-gray'), substr($project->createdDate, 0, strlen($project->createdDate) - 3))
                    ),
                    $isAuthor && !empty($project->actions) ? div
                    (
                        setClass('project-actions absolute right-1 top-1 z-10'),
                        dropdown
                        (
                            set::key($project->id),
                            btn
                            (
                                set::type('ghost'),
                                set::icon('ellipsis-v'),
                                set::caret(false),
                                on::click('e.preventDefault();'),
                            ),
                            set::menuClass('project-actions-menu'),
                            set::items($project->actions),
                            set::placement('bottom-end'),
                            set::trigger('hover')
                        )
                    ) : null,
                )
            )
        );
    }

    panel
    (
        setClass('pb-3'),
        div
        (
            setClass('flex flex-wrap overflow-y-auto'),
            setStyle(array('max-height' => 'calc(100vh - 10rem)')),
            $items
        ),
        pager(setClass('pull-right'), set(usePager()))
    );
}
