<?php
$directory = dirname(__DIR__) . '/config/analysises';
if(is_dir($directory))
{
    $files = scandir($directory);
    foreach($files as $file)
    {
        if($file !== '.' && $file !== '..' && pathinfo($file, PATHINFO_EXTENSION) === 'php') include "$directory/$file";
    }
}

$config->perfproject->projects = array(
  array(
    'version' => '1.0',
    'id' => 1,
    'name' => '研发过程方案决策分析',
    'acl' => 'open',
    'whitelist' => '',
    'source' => 1,
    'table' => '0',
    'schema' => '',
    'desc' => '构建蒙特卡罗仿真模型量化评估研发过程多方案组合的工时分布与质量特性指标，实现研发资源的多目标动态优化配置。',
  ),
  array(
    'version' => '1.0',
    'id' => 2,
    'name' => '影响因子验证与改进效果分析',
    'acl' => 'open',
    'whitelist' => '',
    'source' => 1,
    'table' => '0',
    'schema' => '',
    'desc' => '运用相关性分析识别潜在影响因子，基于分析结果优化改进策略，采用双样本t检验对改进前后的效果进行显著性检验，为优化方案的落地提供数据支撑。',
  ),
  array(
    'version' => '1.0',
    'id' => 3,
    'name' => '缺陷预测',
    'acl' => 'open',
    'whitelist' => '',
    'source' => 1,
    'table' => '0',
    'schema' => '',
    'desc' => '基于测试的缺陷收敛趋势，应用Gompertz可靠性增长模型进行拟合度分析，预测达到质量出口准则所需的剩余测试轮次及未发现的缺陷数量。',
  ),
  array(
    'version' => '1.0',
    'id' => 4,
    'name' => '质量控制',
    'acl' => 'open',
    'whitelist' => '',
    'source' => 1,
    'table' => '0',
    'schema' => '',
    'desc' => '运用IMR控制图监控迭代缺陷密度，识别过程异常，通过分析缺陷密度与迭代需求用例密度、需求复杂度指标间的相关性，构建多元线性回归预测模型。',
  ),
  array(
    'version' => '1.0',
    'id' => 5,
    'name' => '工时预测',
    'acl' => 'open',
    'whitelist' => '',
    'source' => 1,
    'table' => '0',
    'schema' => '',
    'desc' => '基于历史项目数据，分析单位需求工时分布特征并建立预测模型，估算当前项目需求的工时分布情况。',
  )
);
