<?php
/**
 * The editMethod view file of perfanalysis module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Zemei Wang <wangzemei@easycorp.ltd>
 * @package     perfanalysis
 * @link        https://www.zentao.net
 */
namespace zin;

jsVar('validMsg', $lang->perfanalysis->methodValidMsg);
jsVar('methodSettings', $methodSettings);
jsVar('thWidth', $thWidth);

$fnGenerateMoreBtn = function($props)
{
    $text = array();
    foreach($props as $prop) $text[] = $prop['label'];
    $text = implode(',', $text);

    return formGroup
    (
        setClass('relative'),
        div(setClass('more-label-split')),
        div
        (
            setClass('more-label'),
            icon('expand'),
            set::title($text),
            $text,
            on::click()->do('$(".more-setting").toggleClass("hidden")')
        )
    );
};

$fnGenerateFormGroup = function() use ($methodSettings, $dataframe, $fnGenerateMoreBtn, $analysisMethod)
{
    $formGroups = array();
    list($basicProps, $moreProps) = $this->perfanalysis->getFromGroupProps($methodSettings, $dataframe, $analysisMethod->settings);
    foreach($basicProps as $props) $formGroups[] = formGroup(set($props));
    if(!empty($moreProps))         $formGroups[] = $fnGenerateMoreBtn($moreProps);
    foreach($moreProps as $props)  $formGroups[] = formGroup(setClass('more-setting hidden'), set($props));

    return $formGroups;
};

$isChinese  = strpos($app->getClientLang(), 'zh-') !== false;
$labelWidth = $methodName == 'gompertz' ? '240px' : '180px';
!empty($dataframe->notEmptyCols()) ? formPanel
(
    setID('dataform'),
    set::title($lang->perfanalysis->editMethod . ': ' . $methodTitle),
    set::actions(array(
        array('text' => $lang->save, 'class' => 'btn primary', 'btnType' => 'button', 'onclick' => 'submitForm(this)'),
        array('text' => $lang->perfanalysis->cancel, 'class' => 'btn', 'data-dismiss' => 'modal')
    )),
    setData(array('methodName' => $methodName)),
    set::labelWidth($isChinese ? '140px' : $labelWidth),
    on::inited()->call('checkSettingsConditions', jsRaw('this')),
    on::change()->call('checkSettingsConditions', jsRaw('this')),
    formGroup
    (
        set::name('title'),
        set::label($lang->perfanalysis->methodTitle),
        set::value($analysisMethod->title)
    ),
    $fnGenerateFormGroup()
) : formPanel
(
    set::title($lang->perfanalysis->errorTitle),
    set::actions(array()),
    set::bodyClass('text-center text-gray'),
    $lang->perfanalysis->dataError
);
