<?php
namespace zin;

jsVar('validMsg', $lang->perfanalysis->methodValidMsg);
jsVar('methodSettings', $methodSettings);
jsVar('thWidth', $thWidth);

$fnGenerateMoreBtn = function($props)
{
    $text = array();
    foreach($props as $prop) $text[] = $prop['label'];
    $text = implode(',', $text);

    return formGroup
    (
        setClass('relative'),
        div(setClass('more-label-split')),
        div
        (
            setClass('more-label'),
            icon('expand'),
            set::title($text),
            $text,
            on::click()->do('$(".more-setting").toggleClass("hidden")')
        )
    );
};

$fnGenerateFormGroup = function() use ($methodSettings, $dataframe, $fnGenerateMoreBtn)
{
    $formGroups = array();
    list($basicProps, $moreProps) = $this->perfanalysis->getFromGroupProps($methodSettings, $dataframe);
    foreach($basicProps as $props) $formGroups[] = formGroup(set($props));
    if(!empty($moreProps))         $formGroups[] = $fnGenerateMoreBtn($moreProps);
    foreach($moreProps as $props)  $formGroups[] = formGroup(setClass('more-setting hidden'), set($props));

    return $formGroups;
};

$isChinese  = strpos($app->getClientLang(), 'zh-') !== false;
$labelWidth = $methodName == 'gompertz' ? '240px' : '180px';
!empty($dataframe->data) ? formPanel
(
    setID('dataform'),
    set::title($lang->perfanalysis->addMethod . ': ' . $methodTitle),
    set::actions(array(
        array('text' => $lang->save, 'class' => 'btn primary', 'btnType' => 'button', 'onclick' => 'submitForm(this)'),
        array('text' => $lang->perfanalysis->cancel, 'class' => 'btn', 'data-dismiss' => 'modal')
    )),
    setData(array('methodName' => $methodName)),
    set::labelWidth($isChinese ? '140px' : $labelWidth),
    on::inited()->call('checkSettingsConditions', jsRaw('this')),
    on::change()->call('checkSettingsConditions', jsRaw('this')),
    formGroup
    (
        set::name('title'),
        set::label($lang->perfanalysis->methodTitle),
        set::value($methodTitle)
    ),
    $fnGenerateFormGroup()
) : formPanel
(
    set::title($lang->perfanalysis->errorTitle),
    set::actions(array()),
    set::bodyClass('text-center text-gray'),
    $lang->perfanalysis->dataError
);
