<?php
namespace zin;

formPanel
(
    setID('importForm'),
    set::title($lang->montecarlo->importInfo),
    set::submitBtnText($lang->import),
    formGroup
    (
        setClass('leading-6'),
        div($lang->montecarlo->importTipPrefix),
        btn(
            set::type('link'),
            set::size('sm'),
            $lang->montecarlo->importTipLink,
            on::click()->do('downloadTemplate()')
        ),
        div($lang->montecarlo->importTipSuffix)
    ),
    formGroup
    (
        setStyle(array('align-items' => 'center')),
        set::label($lang->perfproject->selectFile),
        set::required(true),
        fileSelector
        (
            set::maxFileCount(1),
            set::accept('.xlsx'),
            set::mode('button'),
            set::name('file'),
            set::tip(sprintf($lang->perfproject->notes->file, strtoupper(ini_get('upload_max_filesize')))),
            set::onAdd(jsRaw('window.onAddFile')),
            set::onRemove(jsRaw('window.onRemoveFile'))
        )
    )
);
