<?php
namespace zin;

$forecastList = array();
foreach($initValue['forecast'] as $forecast) $forecastList[$forecast['forecastYname']] = $forecast['forecastYname'];

include_once 'common.php';
include_once 'common.hypo.php';
include_once 'common.decision.php';
include_once 'common.forecast.php';
include_once 'common.target.php';
include_once 'common.request.php';

$changeControls = array('varName','distribution', 'decisionName', 'decisionVar', 'forecastName', 'formula', 'target', 'statistic', 'reqVar', 'reqStat', 'reqCondition', 'reqValue');
$changeSelectors = array();
foreach($changeControls as $control) $changeSelectors[] = '[name^="' . $control . '["]';

formPanel
(
    setID('dataform'),
    set('data-initvalue', $initValue),
    set('data-posturl', createLink('montecarlo', 'create', "anaysisID={$analysisID}&operation=update")),
    set::title($lang->perfanalysis->addMethod . ': ' . $methodTitle),
    set::url(createLink('montecarlo', 'create', "anaysisID={$analysisID}")),
    set::actions(array(
        array('text' => $lang->save, 'class' => 'btn primary', 'onclick' => 'submitMontecarlo()'),
        array('text' => $lang->draft, 'class' => 'btn','onclick' => 'submitMontecarlo("draft")'),
        array('text' => $lang->perfanalysis->cancel, 'class' => 'btn', 'data-dismiss' => 'modal'),
        array('text' => $lang->montecarlo->importInfo, 'class' => 'btn ghost', 'data-toggle' => 'modal', 'url' => createLink('montecarlo', 'import'))
    )),
    set::lableWidth(120),
    $fnGenerateHypo($initValue['hypo']),
    $fnGenerateDecisionStus($initValue['decisionStus']),
    $initValue['decisionStus'] === 'true' ? $fnGenerateDecision($initValue['decision']) : null,
    $fnGenerateForecast($initValue['forecast']),
    $initValue['decisionStus'] === 'true' ? $fnGenerateTarget($initValue['target']) : null,
    $initValue['decisionStus'] === 'true' ? $fnGenerateRequest($initValue['request']) : null,
    formGroup
    (
        set::name('runNumber'),
        set::label($lang->montecarlo->runNumber),
        set::control('input'),
        set::required(true),
        set::width('1/2'),
        set::value($initValue['runNumber']),
        set::tipClass('text-error text-danger' . (isset($errors['runNumber']) ? '' : ' hidden')),
        set::tip(isset($errors['runNumber']) ? $errors['runNumber'] : ''),
        on::change('[name=runNumber]')->do('changeRunNumber($this)')
    ),
    formGroup
    (
        setClass('hidden'),
        set::name('draft'),
        set::value($initValue['draft'])
    ),
    formGroup
    (
        set::name('sensitivity'),
        set::label($lang->montecarlo->sensitivity),
        set::control(array('type' => 'radioList', 'inline' => true)),
        set::items($lang->montecarlo->sensitivityList),
        set::value($initValue['sensitivity'])
    ),
    formGroup
    (
        setClass(array('hidden' => $initValue['decisionStus'] === 'false')),
        set::name('displayPlans'),
        set::label($lang->montecarlo->displayPlans),
        set::control(array('type' => 'radioList', 'inline' => true)),
        set::items($lang->montecarlo->displayPlansList),
        set::value($initValue['displayPlans'])
    ),
    on::change('[name^="type["]')->do('changeType($this)'),
    on::change('[name=exportY')->do('changeExportY($this)'),
    on::change(implode(',', $changeSelectors))->do('changeFormControl($this)')
);
