<?php
namespace zin;

$fnGenerateFormHeader = function($data) use ($lang)
{
    $headers = array();
    foreach($data as $header)
    {
        $headers[] = div
        (
            isset($header['required']) ? span(setClass('inline-block text-danger mr-1 mt-0.5'), setStyle(array('transform' => 'scale(1.15, 1.3)')), '*') : null,
            setClass(array('form-header-item font-bold text-left', "basis-{$header['width']}" => $header['width'] != 'auto', 'flex-auto' => $header['width'] == 'auto')),
            $header['title'],
            isset($header['help']) ? btn
            (
                setClass('inline ghost'),
                set::size('sm'),
                setData(array('title' => $header['help'], 'placement' => 'top', 'className' => 'text-gray border border-light', 'type' => 'white', 'hideOthers' => true)),
                set('data-toggle', 'tooltip'),
                icon('help')
            ) : null
        );
    }
    return div
    (
        setClass('flex form-header justify-start gap-6'),
        $headers
    );
};

$fnGenerateControl = function($props, $value)
{
    $control    = $props['control'];
    $name       = $props['name'];
    $valueField = isset($props['valueField']) ? $props['valueField'] : null;
    $width      = isset($props['width']) ? $props['width'] : null;
    $required   = isset($props['required']) ? $props['required'] : false;
    $placeholder = isset($props['placeholder']) ? $props['placeholder'] : null;

    $show = isset($props['show']) ? $props['show'] : array();
    $isShow = true;
    foreach($show as $key => $showValue)
    {
        if($value[$key] != $showValue)
        {
            $isShow = false;
            break;
        }
    }
    if(!$isShow) return null;

    $hidden = isset($props['hidden']) ? $props['hidden'] : array();
    $isHidden = is_bool($hidden) ? $hidden : false;
    if(is_array($hidden))
    {
        foreach($hidden as $key => $hiddenValue)
        {
            if($value[$key] == $hiddenValue)
            {
                $isHidden = true;
                break;
            }
        }
    }

    $hiddenClass = $isHidden ? 'hidden' : '';
    $className   = "$hiddenClass montecarlo-control";

    $index = isset($props['index']) ? $value[$props['index']] : '';
    $type  = isset($props['type']) ? $props['type'] : 'default';

    if($control == 'btn')
    {
        $btnText = isset($props['value']) && !empty($value[$props['value']]) ? $value[$props['value']] : $props['default'];
        if(isset($props['formateDisplay'])) $btnText = $props['formateDisplay']($btnText);
        $url = '';
        if(isset($props['url'])) $url = $props['url'];
        if(isset($props['formateUrl'])) $url = $props['formateUrl']($value);
        return btn
        (
            setClass('flex-auto w-full text-primary leading-8 inline-block text-ellipsis' . $hiddenClass),
            set::type($type),
            set::text($btnText),
            empty($url) ? null : set::url($url),
            set('data-toggle', isset($props['data-toggle']) ? $props['data-toggle'] : null),
            set::dataId($index)
        );
    }
    if($control == 'label')    return div(setClass('leading-8'), $value[$name]);
    if($control == 'input')    return input(set(array('name' => $name . "[$index]", 'value' => $value[$name], 'required' => $required, 'width' => $width, 'class' => $className, 'placeholder' => $placeholder)));
    if($control == 'textarea') return textarea(set(array('name' => $name . "[$index]", 'value' => $value[$name], 'required' => $required, 'width' => $width, 'class' => $className, 'placeholder' => $placeholder, 'rows' => 1)));
    if($control == 'picker')   return picker(set(array('name' => $name . "[$index]", 'value' => $value[$name], 'items' => $props['items'], 'required' => $required, 'width' => $width, 'class' => $className)));
    if($control == 'radio')    return radio(set(array('name' => $name, 'value' => $value[$valueField], 'checked' => $value[$name], 'required' => $required, 'width' => $width, 'class' => $hiddenClass)));
};

$fnGenerateFormRow = function($key, $index, $data, $value, $useAction = true, $removeEvent = '') use ($lang, $fnGenerateControl, $errors)
{
    $errors = isset($errors[$key]) ? $errors[$key] : array();
    $items = array();
    foreach($data as $item)
    {
        $className = isset($item['className']) ? $item['className'] : '';
        $width     = isset($item['width']) ? $item['width'] : 'auto';
        $prefix    = isset($item['prefix']) ? $item['prefix'] : null;
        $children  = array();
        $controls  = array();
        $hasError  = false;
        $errorTip  = '';

        $item['width'] = $width;

        if($prefix) $children[] = label(setClass('w-8 h-8'), $$prefix);
        if(isset($item['name'])) $controls[] = $item;
        elseif(isset($item['items'])) $controls = $item['items'];

        foreach($controls as $control)
        {
            if(isset($control['values'])) $value[$control['name']] = $index == 0 ? $control['values'][0] : $control['values'][1];
            $children[] = $fnGenerateControl($control, $value);
            if(isset($errors[$control['name']]) && isset($errors[$control['name']][$index]))
            {
                $hasError = true;
                $errorTip = $errors[$control['name']][$index];
            }
        }

        $hidden = isset($item['hidden']) ? $item['hidden'] : array();
        $isHidden = is_bool($hidden) ? $hidden : false;
        if(is_array($hidden))
        {
            foreach($hidden as $key => $hiddenValue)
            {
                if($value[$key] == $hiddenValue)
                {
                    $isHidden = true;
                    break;
                }
            }
        }

        $hiddenClass = $isHidden ? ' hidden' : '';

        $items[] = formGroup
        (
            setClass(($width == 'auto' ? 'flex-auto' : "basis-{$width}") . $hiddenClass, $className),
            $width !== 'auto' ? set::width($width) : null,
            count($children) > 1 ? inputGroup($children) : $children[0],
            set::tipClass('text-error text-danger' . ($hasError ? '' : ' hidden')),
            set::tip($errorTip)
        );
    }
    
    return formRow
    (
        setID("$key-$index"),
        setClass("flex form-body justify-start items-end max-h-16 query-filter-row gap-6 {$key}-row"),
        set('data-index', $index),
        $items,
        formGroup
        (
            setClass(array('flex-auto', 'hidden' => !$useAction)),
            set::width(120),
            btn
            (
                set('data-index', $index),
                setClass("${key}-row-remove"),
                set::type('ghost'),
                set::icon('close'),
                !empty($removeEvent) ? on::click(".${key}-row-remove")->do($removeEvent) : null
            )
        )
    );
};
