<?php
namespace zin;

$hypoHeader = array(
    array('title' => $lang->montecarlo->varName,      'width' => '48'),
    array('title' => $lang->montecarlo->distribution, 'width' => 'auto', 'required' => true),
);

$hypoForm = $config->montecarlo->hypoForm->form;

$hypoForm['varName']['index']     = 'variable';
$hypoForm['varName']['width']     = $hypoHeader[0]['width'];
$hypoForm['varName']['className'] = 'group-varName';
$hypoForm['varName']['prefix']    = 'index';


$hypoForm['type']['index']     = 'variable';
$hypoForm['type']['width']     = '120';
$hypoForm['type']['items']     = $lang->montecarlo->typeList;

$hypoForm['distribution']['index']  = 'variable';
$hypoForm['distribution']['hidden'] = array('type' => 'dist');

$hypoForm['addDist']['show']        = array('type' => 'dist');
$hypoForm['addDist']['default']     = $lang->montecarlo->distTip;
$hypoForm['addDist']['value']       = 'distribution';
$hypoForm['addDist']['data-toggle'] = 'modal';
$hypoForm['addDist']['url']         = createLink('montecarlo', 'adddist', "var={letter}&value=[value]");

$hypoForm['addDist']['formateDisplay'] = function($value) use ($lang)
{
    $distKey = ['normal', 'triangular'];
    foreach($distKey as $key)
    {
        if(strpos($value, $key) != -1) $value = str_replace($key, $lang->montecarlo->dists[$key]->title, $value);
    }

    return $value;
};

$hypoForm['addDist']['formateUrl'] = function($value)
{
    $variable     = $value['variable'];
    $distribution = $value['distribution'];
    $distribution = base64_encode($distribution);
    return createLink('montecarlo', 'adddist', "var=$variable&value=$distribution");
};

$hypoRow = array
(
    $hypoForm['varName'],
    array
    (
        'width' => $hypoHeader[1]['width'],
        'errorTip' => sprintf($lang->montecarlo->validMsg['required'], $lang->montecarlo->distribution),
        'items' => array($hypoForm['type'], $hypoForm['distribution'], $hypoForm['addDist'])
    )
);

$fnGenerateHypo = function($data) use ($lang, $hypoHeader, $hypoRow, $fnGenerateFormHeader, $fnGenerateFormRow)
{
    $rows = array();
    $showRemove = count($data) > 1;
    foreach($data as $value) $rows[] = $fnGenerateFormRow('hypo', $value['variable'], $hypoRow, $value, $showRemove, 'removeHypo($this)');

    return array
    (
        $fnGenerateFormHeader($hypoHeader),
        $rows,
        formGroup
        (
            btn
            (
                setID('addHypo'),
                set::type('default'),
                set::icon('plus'),
                $lang->montecarlo->addVar,
            ),
            on::click('#addHypo')->do('addHypo()')
        ),
        divider()
    );
};
