<?php
namespace zin;

$forecastHeader = array(
    array('title' => $lang->montecarlo->export,       'width' => '12'),
    array('title' => $lang->montecarlo->forecastName, 'width' => '48'),
    array('title' => $lang->montecarlo->formula,      'width' => 'auto', 'help' => $lang->montecarlo->supportedFormulas, 'required' => true),
);

$forecastForm = $config->montecarlo->forecastForm->form;

$forecastForm['exportY']['width']      = $forecastHeader[0]['width'];
$forecastForm['exportY']['valueField'] = 'forecastYname';

$forecastForm['forecastName']['width']  = $forecastHeader[1]['width'];
$forecastForm['forecastName']['prefix'] = 'index';

$forecastForm['forecastYname']['hidden'] = true;

$forecastForm['formula']['width']       = $forecastHeader[2]['width'];
$forecastForm['formula']['placeholder'] = $lang->montecarlo->formulaTip;
$forecastForm['formula']['errorTip']    = sprintf($lang->montecarlo->validMsg['required'], $lang->montecarlo->formula);

/* 暂时先隐藏条件公式，后续完善。*/
/*
$forecastForm['condition']['width']     = '18';
$forecastForm['condition']['default']   = $lang->montecarlo->conditionFormula;
$forecastForm['condition']['type']      = 'ghost';
*/

$forecastRow = array($forecastForm['exportY'], $forecastForm['forecastName'], $forecastForm['forecastYname'], $forecastForm['formula']);

$fnGenerateForecast = function($data) use ($lang, $forecastHeader, $forecastRow, $fnGenerateFormHeader, $fnGenerateFormRow)
{
    $rows = array();
    $showRemove = count($data) > 1;
    foreach($data as $value) $rows[] = $fnGenerateFormRow('forecast', $value['forecastYname'], $forecastRow, $value, $showRemove, 'removeForecast($this)');

    return array
    (
        $fnGenerateFormHeader($forecastHeader),
        $rows,
        formGroup
        (
            btn
            (
                set::type('default'),
                set::icon('plus'),
                $lang->montecarlo->addForecast,
                on::click()->do('addForecast()')
            )
        ),
        divider()
    );
};
