<?php
namespace zin;

$decisionHeader = array(
    array('title' => $lang->montecarlo->decisionVar, 'width' => '36'),
    array('title' => $lang->montecarlo->decisionValue, 'width' => 'auto', 'help' => $lang->montecarlo->decisionHelp, 'required' => true),
);

$decisionForm = $config->montecarlo->decisionForm->form;

$decisionForm['decisionName']['width']  = $decisionHeader[0]['width'];
$decisionForm['decisionName']['prefix'] = 'index';

$decisionForm['decisionXname']['hidden'] = true;

$decisionForm['decisionVar']['width']       = $decisionHeader[1]['width'];
$decisionForm['decisionVar']['placeholder'] = $lang->montecarlo->decisionTip;
$decisionForm['decisionVar']['errorTip']    = sprintf($lang->montecarlo->validMsg['required'], $lang->montecarlo->decisionValue);

$decisionRow = array($decisionForm['decisionName'], $decisionForm['decisionXname'], $decisionForm['decisionVar']);

$fnGenerateDecision = function($data) use ($lang, $decisionHeader, $decisionRow, $fnGenerateFormHeader, $fnGenerateFormRow)
{
    $rows = array();
    $showRemove = count($data) > 1;
    foreach($data as $value) $rows[] = $fnGenerateFormRow('decision', $value['decisionXname'], $decisionRow, $value, $showRemove, 'removeDecision($this)');

    return array
    (
        $fnGenerateFormHeader($decisionHeader),
        $rows,
        formGroup
        (
            btn
            (
                set::type('default'),
                set::icon('plus'),
                $lang->montecarlo->addDecision,
                on::click()->do('addDecision()')
            )
        ),
        divider()
    );
};

$fnGenerateDecisionStus = function($data) use ($lang)
{
    return array
    ( 
        formGroup
        (
            set::name('decisionStus'),
            set::label($lang->montecarlo->decision),
            set::control(array('control' => 'radioList', 'inline' => true)),
            set::items($lang->montecarlo->decisionList),
            set::value($data),
            on::change()->do('changeDecisionStus($this)')
        ),
        divider()
    );
};
