<?php
/**
 * The adddist view file of montecarlo module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Zemei Wang <wangzemei@easycorp.ltd>
 * @package     montecarlo
 * @link        https://www.zentao.net
 */
namespace zin;

jsVar('dists', $this->lang->montecarlo->dists);
jsVar('formConfig', $config->montecarlo->dists);
jsVar('validMsg', $lang->montecarlo->validMsg);

$navItems = array();
$panes    = array();
foreach($dists as $index => $dist)
{
    $navItems[] = li
    (
        setClass('nav-item'),
        a
        (
            setData('name', $index),
            toggle::tab(array('target' => "#distTab_$index")),
            setClass('flex-auto min-w-0', $index == $type ? 'active' : ''),
            $dist->title
        )
    );
    $itemFlex  = '0 0 calc(50% - 10px)';
    if($index == 'triangular') $itemFlex = '0 0 calc(33.33% - 10px)';
    $formGroup = array();
    foreach($dist->form as $name => $text)
    {
        $formGroup[] = formGroup
        (
            setStyle('flex', $itemFlex),
            set::label($text),
            set::required($config->montecarlo->dists[$index][$name]['required']),
            set::name($name),
            set::value($index == $type && !empty($params) && isset($params[$name]) ? trim($params[$name]) : ''),
        );
    }
    $panes[] = div
    (
        setID("distTab_$index"),
        setClass('flex-1 tab-pane fade', $index == $type ? 'active in' : ''),
        div
        (
            setClass('flex col items-center gap-2.5'),
            img
            (
                setStyle(array('width' => '240px', 'height' => '150px')),
                set::src($config->webRoot . 'static/zenperf/montecarlo/distribution/' . $dist->image)
            ),
            div
            (
                setClass('w-full flex flex-wrap gap-2.5'),
                $formGroup
            )
        ),
    );
}

formPanel
(
    setID('distForm'),
    set::title($lang->montecarlo->typeList['dist']),
    set::actions(array(array('text' => $lang->save, 'btnType' => 'button', 'class' => 'primary', 'onclick' => 'submitForm()'))),
    div
    (
        setClass('flex'),
        nav
        (
            setClass('nav-secondary'),
            setStyle('width', '180px'),
            set::stacked(true),
            $navItems,
            on::click()->call('changeNav', jsRaw('this')),
        ),
        $panes
    ),
    hr(),
    div(setClass('desc'), html($dists[$type]->describe))
);
