<?php
require_once dirname(dirname(__DIR__)) . '/das/methods/vendor/autoload.php';
require_once dirname(__DIR__) . '/tools.php';

use MathPHP\Probability\Distribution\Continuous;

/**
 * Normal
 */
class normal
{
    public $mu;

    public $sigma;

    public $min;

    public $max;

    public $normal;
    /**
     * Construct function
     *
     * @param float $mu
     * @param float $sigma
     * @param float $min
     * @param float $max
     * @access public
     * @return void
     */
    public function __construct($mu, $sigma, $min = null, $max = null)
    {
        $mu    = formatDigit($mu);
        $sigma = formatDigit($sigma);
        $min   = formatDigit($min);
        $max   = formatDigit($max);

        $this->mu    = $mu;
        $this->sigma = $sigma;
        $this->min   = $min;
        $this->max   = $max;

        $this->normal = new Continuous\Normal($mu, $sigma);
    }

    /**
     * Cumulative distribution function.
     *
     * @param float $x
     * @access public
     * @return float
     */
    public function cdf($x)
    {
        return $this->normal->cdf($x);
    }

    /**
     * Probability distribution function.
     *
     * @param float $x
     * @access public
     * @return float
     */
    public function pdf($x)
    {
        return $this->normal->pdf($x);
    }

    /**
     * Inverse cumulative distribution function.
     *
     * @param float $p
     * @access public
     * @return float
     */
    public function inverse($p)
    {
        return $this->normal->inverse($p);
    }

    /**
     * Get rand number.
     *
     * @access public
     * @return float
     */
    public function rand()
    {
        $rand = $this->normal->rand();

        if($this->min !== null and $this->max !== null)
        {
            while($rand < $this->min or $rand > $this->max)
            {
                $rand = $this->normal->rand();
            }
        }
        else if($this->min !== null)
        {
            while($rand < $this->min)
            {
                $rand = $this->normal->rand();
            }
        }
        else if($this->max !== null)
        {
            while($rand > $this->max)
            {
                $rand = $this->normal->rand();
            }
        }

        return $rand;
    }
}
