<?php

/**
 * ChiSquare
 */
class ChiSquare
{
    /**
     * 自由度
     *
     * @var float
     * @access public
     */
    public $k;

    public $service;

    public $path;

    /**
     * 构造方法。
     *
     * The construct function.
     *
     * @access public
     * @return void
     */
    public function __construct($k)
    {
        global $config;
        $this->service = $config->gonumService;
        $this->path    = dirname(__DIR__);
        $this->k = $k;
    }

    public function pdf($x)
    {
        $path   = $this->path;
        $result = exec("$path/{$this->service} -exec -method=chiSq -k={$this->k} -c=$x -m=pdf");
        return is_numeric($result) ? $result : (float)$result;
    }

    public function cdf($x)
    {
        $path   = $this->path;
        $result = exec("$path/{$this->service} -exec -method=chiSq -k={$this->k} -c=$x -m=cdf");
        return is_numeric($result) ? $result : (float)$result;
    }

    public function inverse($p)
    {
        $path   = $this->path;
        $result = exec("$path/{$this->service} -exec -method=chiSq -k={$this->k} -c=$p -m=inv");
        return is_numeric($result) ? $result : (float)$result;
    }
}
