<?php

/**
 * Binomial
 */
class Binomial
{
    /**
     * 事件发生概率
     *
     * @var float
     * @access public
     */
    public $p;

    /**
     * 样本数
     *
     * @var float
     * @access public
     */
    public $n;

    public $service;

    public $path;

    /**
     * 构造方法。
     *
     * The construct function.
     *
     * @access public
     * @return void
     */
    public function __construct($p, $n)
    {
        global $config;
        $this->service = $config->gonumService;
        $this->path    = dirname(__DIR__);
        $this->p = $p;
        $this->n = $n;
    }

    public function pdf($x)
    {
        $path   = $this->path;
        $result = exec("$path/{$this->service} -exec -method=binomial-pdf $this->n  $this->p $x");
        return is_numeric($result) ? $result : (float)$result;
    }

    public function cdf($x)
    {
        $path   = $this->path;
        $result = exec("$path/{$this->service} -exec -method=binomial-cdf $this->n  $this->p $x");
        return is_numeric($result) ? $result : (float)$result;
    }
}
