<?php

class perfexcel
{
    /**
     * Read excel file.
     *
     * @param string $file
     * @param string $extension
     * @access public
     * @return object
     */
    public static function read($file, $extension = 'Xlsx')
    {
        $paths    = explode('/', $file);
        $fileName = array_pop($paths);
        $path     = implode('/', $paths);

        $config = array('path' => $path);
        $excel  = new \Vtiful\Kernel\Excel($config);

        return $excel->openFile($fileName);
    }

    /**
     * Config excel object.
     *
     * @param string $file
     * @access public
     * @return object
     */
    public static function config($file)
    {
        $paths    = explode('/', $file);
        $fileName = array_pop($paths);
        $path     = implode('/', $paths);

        $config = array('path' => $path);
        $excel  = new \Vtiful\Kernel\Excel($config);
        $excel->openFile($fileName);

        return $excel;
    }
}
