<?php
require_once dirname(__DIR__) . '/base/analysis.php';
require_once dirname(dirname(__DIR__)) . '/zendasmath/basic/describe.php';
require_once dirname(dirname(__DIR__)) . '/zendasmath/distribution/normal.php';

class Graph extends analysisBase
{
    public $points;

    /**
     * 构造方法。
     *
     * The construct function.
     *
     * @access public
     * @return void
     */
    public function __construct($dataframe, $points)
    {
        $this->points = $points;

        parent::__construct($dataframe);
    }

    public function normalFit($min, $max, $unit)
    {
        $mean   = Describe::mean($this->points);
        $std    = Describe::standard($this->points);
        $normal = new normal($mean, $std);
        $n      = count($this->points);

        $xpoints = array();
        $ypoints = array();
        for($point = $min; $point <= $max; $point += $unit/10)
        {
            $xpoints[] = $point;
            $ypoints[] = ($normal->cdf($point + $unit) - $normal->cdf($point)) * $n;
        }

        return array($xpoints, $ypoints);
    }
}
