<?php
require_once dirname(__DIR__) . '/base/spcchart.php';
require_once dirname(dirname(__DIR__)) . '/zendasmath/basic/describe.php';

/**
 * C
 */
class C extends spcChart
{
    public $decimals;

    public $dataframe;

    /**
     * SPC C chart σ method;
     *
     * @param string $col
     * @param string $type
     * @param bool $round
     * @access public
     * @return array
     */
    public function sigma($col, $type, $round = true)
    {
        $mean = $this->cBar($col, $type, false);
        $σ    = sqrt($mean);
        $σ    = $round ? round($σ, $this->decimals) : $σ;

        return $σ;
    }

    /**
     * SPC C chart μ method;
     *
     * @param string $col
     * @param string $type
     * @param bool $round
     * @access public
     * @return array
     */
    public function cBar($col, $type, $round = true)
    {
        $col = $this->dataframe->col($col, $type);
        return Describe::mean($col->trimdata, $round);
    }

    /**
     * C chart center line method.
     *
     * @param float $μ
     * @param float $σ
     * @param float $multiple
     * @access public
     * @return object
     */
    public function CL($μ, $σ, $multiple)
    {
        $result = new stdclass();

        $part  = (float)$multiple * $σ;

        $result->CL  = $μ;
        $result->UCL = $result->CL + $part;
        $result->LCL = $result->CL - $part;
        $result->LCL = max(0, $result->LCL);

        return $result;
    }

    /**
     * C chart limit line method.
     *
     * @param float $μ
     * @param float $σ
     * @param float $multiple
     * @param float $defaultMultiple
     * @access public
     * @return object
     */
    public function limit($μ, $σ, $multiple, $defaultMultiple = 3)
    {
        $type = 'number';

        $multiples = $multiple;
        if(!in_array($defaultMultiple, $multiple)) $multiples[] = $defaultMultiple;

        $SLs = array();
        foreach($multiples as $m)
        {
            $CLResult = $this->CL($μ, $σ, $m);
            $SLs[$m] = array($CLResult->UCL, $CLResult->LCL);
        }

        $result       = new stdclass();
        $result->CL   = $μ;
        $result->ULCL = $SLs[$defaultMultiple];
        $result->SLs  = $SLs;

        return $result;
    }
}

