<?php
/**
 * The file of monte carlo hypothesis of ZenDAS.
 *
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      qixinzhi <qixinzhi@easycorp.ltd>
 * @package     montecarlo
 * @link        http://www.zentao.net
 */
?>

<?php
require_once dirname(dirname(__DIR__)) . '/zendasmath/distribution/triangular.php';
require_once dirname(dirname(__DIR__)) . '/zendasmath/distribution/normal.php';

class hypothesisVariable
{
    /**
     * 假设变量计算类型。
     *
     * @var string
     * @access public
     */
    public $type;
    /**
     * 分布函数对象。
     *
     * @var object
     * @access public
     */
    public $distribution;
    /**
     * 固定值。
     *
     * @var string
     * @access public
     */
    public $value;

    /**
     * 模拟数据。
     *
     * @var array
     * @access public
     */
    public $data;

    /**
     * 分布函数类型常量。
     * @var 'dist'
     * @access public
     */
    public static $distributionType = 'dist';
    /**
     * 固定数值类型常量。
     * @var 'fixed'
     * @access public
     */
    public static $fixedType = 'fixed';

    public function __construct($type, $method, $value)
    {
        $this->type = $type;
        if($type == self::$distributionType)
        {
            $this->distribution = eval("return self::{$method};");
        }
        else
        {
            $this->value = $value;
        }

        $this->data = array();
    }

    /**
     * 返回一个正态分布随机数生成对象。
     * Normal distribution random.
     *
     * @param float $mu
     * @param float $sigma
     * @access public
     * @return object
     */
    public static function normal($mu, $sigma, $min = null, $max = null)
    {
        return new normal($mu, $sigma, $min, $max);
    }

    /**
     * 返回一个三角分布随机数生成对象。
     * Triangular distribution random.
     *
     * @param float $left
     * @param float $mode
     * @param float $right
     * @access public
     * @return object
     */
    public static function triangular($left, $mode, $right)
    {
        return new triangular($left, $mode, $right);
    }
}
