<?php
require_once dirname(__DIR__) . '/base/hypothesis.php';
require_once dirname(dirname(__DIR__)) . '/das/methods/vendor/autoload.php';

class chisquareTest extends hypothesis
{
    private $dataDesc;

    public function setDataDesc($dataDesc)
    {
        $this->dataDesc = $dataDesc;
    }

    public function getOriginResult($col1Data, $col2Data, $maxLength, $params)
    {
        $col1CVKeys = $params->col1CVKeys;
        $col2CVKeys = $params->col2CVKeys;
        $colEmpKey  = $params->colEmpKey;
        $colAllKey  = $params->colAllKey;
        $rowEmpKey  = $params->rowEmpKey;
        $rowAllKey  = $params->rowAllKey;

        $result = array();

        /* Init $result */
        $result = array();
        for($i = 0; $i < count($col1CVKeys) + 2; $i ++)
        {
            for($l = 0; $l < count($col2CVKeys) + 2; $l ++)
            {
                $result[$i][$l] = array(0, 0, 0);
            }
        }

        /* Init $result[0][0] => $result[count($col1CVKeys) - 1][$colAllKey] */
        for($i = 0; $i < count($col1CVKeys); $i ++)
        {
            $key1 = $col1CVKeys[$i];
            //var_dump($key1);
            $sum = 0;
            for($l = 0; $l < $maxLength; $l ++)
            {
                //a($i);a($l);var_dump($col1Data[$l]);
                if($col1Data[$l] == $key1)
                {
                    if(self::checkNotNull($col2Data[$l]))
                    {
                        $j = array_search($col2Data[$l], $col2CVKeys);
                        $result[$i][$j][0] ++;
                        $sum ++;
                    }
                    else
                    {
                        $result[$i][$colEmpKey][0] ++;
                    }
                }
            }
            $result[$i][$colAllKey][0] = $sum;
        }

        /* Init $result[$rowEmpKey][] row */
        for($l = 0; $l < $maxLength; $l ++)
        {
            if(!self::checkNotNull($col1Data[$l]))
            {
                if(self::checkNotNull($col2Data[$l]))
                {
                    $j = array_search($col2Data[$l], $col2CVKeys);
                    $result[$rowEmpKey][$j][0] ++;
                }
                else
                {
                    $result[$rowEmpKey][$colEmpKey][0] ++;
                }
            }
        }

        /* Init $result[$rowAllKey][] row */
        $all = 0;
        for($j = 0; $j < $colEmpKey; $j ++)
        {
            $sum = 0;
            for($i = 0; $i < $rowEmpKey; $i ++)
            {
                $sum += $result[$i][$j][0];
            }
            $all += $sum;
            $result[$rowAllKey][$j][0] = $sum;
        }
        $result[$rowAllKey][$colAllKey][0] = $all;

        /* Init - */
        $result[$rowAllKey][$colEmpKey][0] = '-';
        $result[$rowEmpKey][$colAllKey][0] = '-';

        /* Init Eij and kafang*/
        for($i = 0; $i < $rowEmpKey; $i ++)
        {
            for($j = 0; $j < $colEmpKey; $j ++)
            {
                $result[$i][$j][1] = $result[$i][$colAllKey][0] * $result[$rowAllKey][$j][0] / $result[$rowAllKey][$colAllKey][0];
                $result[$i][$j][2] = $result[$i][$j][1] == 0 ? 0 :pow($result[$i][$j][0] - $result[$i][$j][1], 2) / $result[$i][$j][1];
                $result[$i][$j][3] = $result[$i][$j][0] == 0 ? 0 : $result[$i][$j][0] * log($result[$i][$j][0] / $result[$i][$j][1]);
            }
        }

        return $result;
    }

    public function getSummaryResult($dataframe, $data, $maxLength)
    {
        $rowCount = $maxLength;
        $colCount = count($data);
        $rowAllKey = $rowCount;
        $colAllKey = $colCount;
        /* Init $result */
        $result = array();
        for($i = 0; $i < $rowCount + 1; $i ++)
        {
            for($l = 0; $l < $colCount + 1; $l ++)
            {
                $result[$i][$l] = array(0, 0, 0);
            }
        }

        foreach($data as $j => $col)
        {
            $colData = $dataframe->col($col)->data;
            $sum = 0;
            for($i = 0; $i < count($colData); $i ++)
            {
                $result[$i][$j][0] = $colData[$i];
                $sum += $colData[$i];
            }
            $result[$rowAllKey][$j][0] = $sum;
        }
        for($i = 0; $i < $rowCount + 1; $i ++)
        {
            $sum = 0;
            for($j = 0; $j < $colCount; $j ++)
            {
                $sum += $result[$i][$j][0];
            }
            $result[$i][$colAllKey][0] = $sum;
        }

        for($i = 0; $i < $rowCount; $i ++)
        {
            for($j = 0; $j < $colCount; $j ++)
            {
                $result[$i][$j][1] = $result[$i][$colAllKey][0] * $result[$rowAllKey][$j][0] / $result[$rowAllKey][$colAllKey][0];
                $result[$i][$j][2] = $result[$i][$j][1] == 0 ? 0 : pow($result[$i][$j][0] - $result[$i][$j][1], 2) / $result[$i][$j][1];
                $result[$i][$j][3] = $result[$i][$j][0] == 0 ? 0 : $result[$i][$j][0] * log($result[$i][$j][0] / $result[$i][$j][1]);
            }
        }
        return $result;

    }
    public function getTableData($result, $params, $addNull = false)
    {

        $col1CVKeys = $params->col1CVKeys;
        $col2CVKeys = $params->col2CVKeys;
        $col1Empty  = $params->col1Empty;
        $col2Empty  = $params->col2Empty;
        $colEmpKey  = $params->colEmpKey;
        $colAllKey  = $params->colAllKey;
        $rowEmpKey  = $params->rowEmpKey;
        $rowAllKey  = $params->rowAllKey;
        $lang       = $params->lang;

        $tableData = array();
        foreach($col1CVKeys as $i => $col1Value)
        {
            $start = $i * 3;
            $tableData[$start][] = $col1Value;
            $tableData[$start + 1][] = NULL;
            $tableData[$start + 2][] = NULL;
            foreach($col2CVKeys as $j => $col2Value)
            {
                $tableData[$start][] = $result[$i][$j][0];
                $tableData[$start + 1][] = round($result[$i][$j][1], 4);
                $tableData[$start + 2][] = round($result[$i][$j][2], 4);
            }
        }

        if($col1Empty)
        {
            $tableData[count($col1CVKeys) * 3][] = $lang->miss;
            foreach($col2CVKeys as $j => $col2Value)
            {
                $tableData[count($col1CVKeys) * 3][] = $result[$rowEmpKey][$j][0];
            }
            $all1Key = count($col1CVKeys) * 3 + 1;
        }
        else
        {
            $all1Key = count($col1CVKeys) * 3;
        }
        $tableData[$all1Key][] = $lang->all;
        for($j = 0; $j < $colAllKey + 1; $j ++)
        {
            if($result[$rowAllKey][$j][0] === '-' and !$col2Empty) continue;
            $tableData[$all1Key][] = $result[$rowAllKey][$j][0];
        }

        if($col1Empty and $col2Empty)
        {
            $tableData[count($col1CVKeys) * 3][] = $result[$rowEmpKey][$colEmpKey][0];
            $tableData[count($col1CVKeys) * 3 - 2][] = NULL;
            $tableData[count($col1CVKeys) * 3 - 1][] = NULL;
        }

        if($col2Empty)
        {
            foreach($col1CVKeys as $i => $col1Value)
            {
                $tableData[$i * 3][] = $result[$i][$colEmpKey][0];
                if($i != 0)
                {
                    $tableData[$i * 3 - 2][] = NULL;
                    $tableData[$i * 3 - 1][] = NULL;
                }
            }
        }
        $all2Key = $colAllKey;
        for($i = 0; $i < $rowAllKey; $i ++)
        {
            if($result[$i][$all2Key][0] === '-' and !$col1Empty) continue;
            $start = $i * 3;
            $tableData[$start][] = $result[$i][$all2Key][0];
            if($i != 0)
            {
                $tableData[$start - 2][] = NULL;
                $tableData[$start - 1][] = NULL;
            }
        }

        if(!$col1Empty and $col2Empty)
        {
            $tableData[$all1Key - 2][$colEmpKey + 1] = NULL;
            $tableData[$all1Key - 1][$colEmpKey + 1] = NULL;
            $tableData[$all1Key - 2][$colEmpKey + 2] = NULL;
            $tableData[$all1Key - 1][$colEmpKey + 2] = NULL;
        }

        // TODO 汇总数据的时候有问题，但是不加这个原始数据又会少点东西
        if($this->dataDesc == 'origin')
        {
            if(!$col1Empty and !$col2Empty)
            {
                $tableData[($rowAllKey - 1) * 3 - 1][$colAllKey] = NULL;
                $tableData[($rowAllKey - 1) * 3 - 2][$colAllKey] = NULL;
            }
        }

        if($addNull)
        {
            $tableData[$rowAllKey * 3 - 2][$colAllKey + 1] = NULL;
            $tableData[$rowAllKey * 3 - 1][$colAllKey + 1] = NULL;
        }

        return $tableData;

    }

    public function checkNotNull($value)
    {
        return (is_numeric($value) or (!is_numeric($value) and !empty($value)));
    }

}
