<?php
require_once LIB_ROOT . '/zendasmath/distribution/normal.php';

/* Simulate normal distribute data. */
class normalSimulate
{

    public static $settings = array();

    public static function data($dataframe, $settings)
    {
        global $config;
        $decimals = $config->default->decimals;

        $σ     = (float)$settings['standardDeviation'];
        $μ     = (float)$settings['mean'];
        $count = (int)$settings['count'];
        $col   = (int)$settings['col'];

        $normal = new normal($μ, $σ);
        $data   = array();

        for($index = 0; $index < $count; $index++)
        {
            $data[] = sprintf("%01.{$decimals}f",round($normal->rand(), $decimals));
        }

        return array($col => $data);
    }

    /**
     * Get settings.
     *
     * @access public
     * @return object
     */
    public static function getSettings($dataframe)
    {
        global $dasLang;
        $lang = $dasLang->simulate;
        $columns = $dataframe->columns;
        $length  = count($columns) + 1;

        $colEnum = array();
        $i       = 1;
        $firstEmptyCol = null;
        foreach($columns as $col => $column)
        {
            $colData = $dataframe->colData($col);
            if(empty($colData) && $firstEmptyCol === null) $firstEmptyCol = $i;
            $colEnum[$i] = $column;
            $i++;
        }
        if($firstEmptyCol === null) $firstEmptyCol = $length;
        for($i = $length; $i < $length + 10; $i++)
        {
            $colEnum[$i] = 'C' . $i;
        }

        self::$settings['standardDeviation'] = array('name' => 'standardDeviation', 'label' => $lang->standardDeviation, 'type' => 'number', 'required' => true, 'columnType' => 'number', 'pattern' => "/^[+]{0,1}[1-9]\d*$|^[+]{0,1}(0\.\d*[1-9])$|^[+]{0,1}([1-9]\d*\.\d*[1-9])$/", 'error' => $lang->errorSD);
        self::$settings['mean']              = array('name' => 'mean',              'label' => $lang->mean,              'type' => 'number', 'required' => true, 'columnType' => 'number', 'pattern' => "/^[\+\-]?[\d]+(\.[\d]+)?$/", 'error' => $lang->errorMean);
        self::$settings['count']             = array('name' => 'count',             'label' => $lang->count,             'type' => 'number', 'required' => true, 'columnType' => 'number', 'min' => 1, 'max' => 1000, 'error' => $lang->errorCount);
        self::$settings['col']               = array('name' => 'col',               'label' => $lang->col,               'type' => 'enum', 'required' => true, 'columnType' => 'text', 'enumOptions' => $colEnum, 'defaultValue' => $firstEmptyCol);

        return self::$settings;
    }
}
