<?php
require_once LIB_ROOT . '/zendasmath/basic/describe.php';
require_once LIB_ROOT . '/dataframe/validatedata.php';
require_once LIB_ROOT . '/dataframe/checkdata.php';

/* Basic statistic method 基本量统计 */
class basicStatisticMethod
{
    /* Method name 分析方法内部名称 */
    public static $name = 'basicStatistic';

    /* Method settings 方法设置参数定义 */
    public static $settings = array();

    /* Callback for basic statistic method 基本量统计计算回调函数 */
    public static function func($dataframe, $settings)
    {
        global $dasLang;
        global $lang;

        $vars    = $settings['vars'];
        $targets = $settings['targets'];

        $sliceDF = $dataframe->sliceDataframe($dataframe, $vars, 'any');
        $check = new checkData();
        $check->setDataList($dataframe->colsData($vars), $dataframe->colsName($vars), self::$settings['vars']['validate']);

        $checkRes = $check->check();
        if(is_string($checkRes)) return ValidateData::result($checkRes);

        $result = new stdclass();
        $result->type  = 'table';
        $result->title = $dataframe->getChartTitle($settings['vars'], $lang->perfanalysis->methods->statistic['basicStatistic']);

        $result->data = array();
        $result->data['data'] = array();

        $columns = array();
        $columns[] = array('label' => self::$settings['vars']['label'], 'type' => 'text');
        foreach($targets as $target)
        {
            $columns[] = array('label' => self::$settings['targets']['enumOptions'][$target], 'type' => 'number');
        }
        $result->data['columns'] = $columns;

        foreach($vars as $index => $var)
        {
            $sliceDF     = $dataframe->sliceDataframe($dataframe, $var, 'any');
            $name        = $sliceDF->columns[$var];
            $data        = $sliceDF->col($var)->data;
            $numericData = $sliceDF->col($var, 'number')->data;

            $dataResult = array($name);
            foreach($targets as $target)
            {
                $dataResult[] = $dataframe->roundDigit(self::getResult($data, $numericData, $target));
            }
            $result->data['data'][] = $dataResult;
        }

        return array($result);
    }

    public static function getResult($data, $numericData, $type)
    {
        $result = null;
        switch($type)
        {
            case 'count':
                $result = count($data);
                break;
            case 'mean':
                $result = Describe::mean($numericData);
                break;
            case 'max':
                $result = Describe::max($numericData);
                break;
            case 'min':
                $result = Describe::min($numericData);
                break;
            case 'sum':
                $result = Describe::sum($numericData);
                break;
            case 'mid':
                $result = Describe::percentData($numericData, 0.5);
                break;
            case 'quart1':
                $result = Describe::percentData($numericData, 0.25);
                break;
            case 'quart3':
                $result = Describe::percentData($numericData, 0.75);
                break;
            case 'percent10':
                $result = Describe::percentData($numericData, 0.1);
                break;
            case 'percent90':
                $result = Describe::percentData($numericData, 0.9);
                break;
            case 'standard':
                $result = Describe::standard($numericData);
                break;
        }

        return $result;
    }

    /**
     * Get settings.
     *
     * @access public
     * @return object
     */
    public static function getSettings()
    {
        global $dasLang;
        $lang = $dasLang->basic;

        /* Basic settings */
        /* Type settings */
        /* Limit settings */
        /* Col grid settings */
        /* More settings */

        self::$settings['vars']    = array('name' => 'vars', 'label' => $lang->vars, 'type' => 'list', 'listType' => 'column', 'required' => true, 'columnType' => 'number');
        self::$settings['targets'] = array('name' => 'targets', 'label' => $lang->targets, 'type' => 'list', 'listType' => 'enum', 'ui' => 'checkbox', 'col' => 4, 'enumOptions' => $lang->enum, 'required' => true, 'defaultValue' => array_keys($lang->enum));

        /* Data validate */
        self::$settings['vars'] += array('validate' => array('continuous', 'number', 'notCommon', 'N >= 2'));

        return self::$settings;
    }

    /**
     * Get config.
     *
     * @access public
     * @return object
     */
    public static function getConfig()
    {
        global $dasLang;
        $lang = $dasLang->config;

        //return self::$config;
    }
}
