<?php
require_once LIB_ROOT . '/dataframe/hypothesis/twosample.php';
require_once LIB_ROOT . '/dataframe/checkdata.php';
require_once LIB_ROOT . '/dataframe/validatedata.php';

/* 双样本t */
class TwosampleMethod
{
    /* Method name 分析方法内部名称 */
    public static $name = 'Twosample';

    /* Method settings 方法设置参数定义 */
    public static $settings = array();

    /* Diagram config 图表配置项 */
    public static $config = array();

    /* Callback for basic hypothesis method 基本量统计计算回调函数 */
    public static function func($dataframe, $settings)
    {
        global $dasLang;
        global $lang;

        $dataDesc       = $settings['data'];
        $sampleS        = $settings['sampleS'];
        $sampleID       = $settings['sampleID'];
        $sample1        = $settings['sample1'];
        $sample2        = $settings['sample2'];
        $sample1Sample  = $settings['sample1Sample'];
        $sample1Mean    = $settings['sample1Mean'];
        $sample1SD      = $settings['sample1SD'];
        $sample2Sample  = $settings['sample2Sample'];
        $sample2Mean    = $settings['sample2Mean'];
        $sample2SD      = $settings['sample2SD'];
        $deviation      = $settings['deviation'];
        $confidence     = $settings['confidence'];
        $alterHypo      = $settings['alternativeHypo'];

        $twosample = new twoSample($dataframe, $dataDesc, $confidence, $deviation, $alterHypo, $dasLang->twosample);

        if($dataDesc == 'inSameCol')
        {
            $sliceDF = $dataframe->sliceDataframe($dataframe, array($sampleS, $sampleID), 'any');

            $check = new checkData();
            $check->setData($dataframe->colData($sampleS), $dataframe->columns[$sampleS], self::$settings['sampleS']['validate']);
            $check->setData($dataframe->colData($sampleID), $dataframe->columns[$sampleID], self::$settings['sampleID']['validate']);

            $checkRes = $check->check();
            if(is_string($checkRes)) return ValidateData::result($checkRes);

            $C1      = $sliceDF->columns[$sampleS];
            $C2      = $sliceDF->columns[$sampleID];

            $column1Data = $sliceDF->col($sampleS, 'nopercentstring')->data;
            $column2Data = $sliceDF->col($sampleID)->data;

            $column1Name = $sliceDF->columns[$sampleS];
            $column2Name = $sliceDF->columns[$sampleID];

            $result = $twosample->setISCParams($column1Data, $column2Data, $column1Name, $column2Name);
            if(isset($result['result']) and $result['result'] == 'fail') return $result;
        }
        else
        {
            if($dataDesc == 'notSameCol')
            {
                $sliceDF = $dataframe->sliceDataframe($dataframe, array($sample1, $sample2), 'any');

                $check = new checkData();
                $check->setData($dataframe->colData($sample1), $dataframe->columns[$sample1], self::$settings['sample1']['validate']);
                $check->setData($dataframe->colData($sample2), $dataframe->columns[$sample2], self::$settings['sample2']['validate']);

                $checkRes = $check->check();
                if(is_string($checkRes)) return ValidateData::result($checkRes);

                $C1      = $sliceDF->columns[$sample1];
                $C2      = $sliceDF->columns[$sample2];

                $column1Data = $sliceDF->col($sample1, 'nopercentstring')->trimdata;
                $column2Data = $sliceDF->col($sample2, 'nopercentstring')->trimdata;
                $column1Name = $sliceDF->columns[$sample1];
                $column2Name = $sliceDF->columns[$sample2];

                $twosample->setNSCParams($column1Data, $column2Data, $column1Name, $column2Name);
            }
            elseif($dataDesc == 'summary')
            {
                $sample1Name = $dasLang->twosample->sam1;
                $sample2Name = $dasLang->twosample->sam2;

                $params = new stdclass();
                $params->sample1Sample = $sample1Sample;
                $params->sample1Mean   = $sample1Mean;
                $params->sample1SD     = $sample1SD;
                $params->sample1Name   = $sample1Name;
                $params->sample2Sample = $sample2Sample;
                $params->sample2Mean   = $sample2Mean;
                $params->sample2SD     = $sample2SD;
                $params->sample2Name   = $sample2Name;

                $twosample->setSummaryParams($params);
            }
        }

        $twosample->setDifference();
        $twosample->setTest();

        $allResult = array();
        $allResult[] = $twosample->getMethod();
        $allResult[] = $twosample->getDescriptiveStatistics();
        $allResult[] = $twosample->getDifference();
        $allResult[] = $twosample->getTest();

        return $allResult;
    }

    /**
     * Get settings.
     *
     * @access public
     * @return object
     */
    public static function getSettings()
    {
        global $dasLang;
        $lang = $dasLang->twosample;

        /* Basic settings */
        self::$settings['data']            = array('name' => 'data',            'label' => $lang->data);
        self::$settings['sampleS']         = array('name' => 'sampleS',         'label' => $lang->sampleS,         'required' => true);
        self::$settings['sampleID']        = array('name' => 'sampleID',        'label' => $lang->sampleID,        'required' => true);
        self::$settings['sample1']         = array('name' => 'sample1',         'label' => $lang->sample1,         'required' => true);
        self::$settings['sample2']         = array('name' => 'sample2',         'label' => $lang->sample2,         'required' => true);
        self::$settings['sample1Sample']   = array('name' => 'sample1Sample',   'label' => $lang->sample1Sample,   'required' => true);
        self::$settings['sample1Mean']     = array('name' => 'sample1Mean',     'label' => $lang->sample1Mean,     'required' => true);
        self::$settings['sample1SD']       = array('name' => 'sample1SD',       'label' => $lang->sample1SD,       'required' => true);
        self::$settings['sample2Sample']   = array('name' => 'sample2Sample',   'label' => $lang->sample2Sample,   'required' => true);
        self::$settings['sample2Mean']     = array('name' => 'sample2Mean',     'label' => $lang->sample2Mean,     'required' => true);
        self::$settings['sample2SD']       = array('name' => 'sample2SD',       'label' => $lang->sample2SD,       'required' => true);
        self::$settings['deviation']       = array('name' => 'deviation',       'label' => $lang->deviation,       'required' => true);
        self::$settings['confidence']      = array('name' => 'confidence',      'label' => $lang->confidence,      'required' => true);
        self::$settings['alternativeHypo'] = array('name' => 'alternativeHypo', 'label' => $lang->alternativeHypo, 'required' => true);

        /* Type settings */
        self::$settings['data']            += array('type' => 'enum', 'enumOptions' => array('inSameCol' => $lang->inSameCol, 'notSameCol' => $lang->notSameCol, 'summary' => $lang->summary), 'defaultValue' => 'inSameCol');
        self::$settings['sampleS']         += array('type' => 'column', 'listType' => 'column', 'columnType' => 'number');
        self::$settings['sampleID']        += array('type' => 'column', 'listType' => 'column', 'columnType' => 'number');
        self::$settings['sample1']         += array('type' => 'column', 'listType' => 'column', 'columnType' => 'number');
        self::$settings['sample2']         += array('type' => 'column', 'listType' => 'column', 'columnType' => 'number');
        self::$settings['sample1Sample']   += array('type' => 'number', 'columnType' => 'number');
        self::$settings['sample1Mean']     += array('type' => 'number');
        self::$settings['sample1SD']       += array('type' => 'number');
        self::$settings['sample2Sample']   += array('type' => 'number', 'columnType' => 'number');
        self::$settings['sample2Mean']     += array('type' => 'number');
        self::$settings['sample2SD']       += array('type' => 'number');
        self::$settings['deviation']       += array('type' => 'number', 'defaultValue' => 0);
        self::$settings['confidence']      += array('type' => 'number', 'defaultValue' => 95);
        self::$settings['alternativeHypo'] += array('type' => 'enum', 'ui' => 'select', 'defaultValue' => 'ne', 'enumOptions' => $lang->alternativeHypoEnum);

        /* Limit settings */
        self::$settings['sampleS']         += array('conditions' => array('data' => 'inSameCol'));
        self::$settings['sampleID']        += array('conditions' => array('data' => 'inSameCol'));
        self::$settings['sample1']         += array('conditions' => array('data' => 'notSameCol'));
        self::$settings['sample2']         += array('conditions' => array('data' => 'notSameCol'));
        self::$settings['sample1Sample']   += array('conditions' => array('data' => 'summary'), 'pattern' => "/^[1-9]([0-9]{1,7})?$/", 'min' => 1.00000001, 'max' => 99999998.99, 'error' => $lang->errorSample);
        self::$settings['sample1Mean']     += array('conditions' => array('data' => 'summary'), 'pattern' => "/^[\+\-]?[\d]+(\.[\d]+)?$/", 'min' => -99999998.99, 'max' => 99999998.99, 'error' => $lang->errorMean);
        self::$settings['sample1SD']       += array('conditions' => array('data' => 'summary'), 'pattern' => "/^([1-9]\d*)(\.[\d]+)?$|^0\.\d+?$/", 'max' => 99999998.99, 'error' => $lang->errorSD);
        self::$settings['sample2Sample']   += array('conditions' => array('data' => 'summary'), 'pattern' => "/^[1-9]([0-9]{1,7})?$/", 'min' => 1.00000001, 'max' => 99999998.99, 'error' => $lang->errorSample);
        self::$settings['sample2Mean']     += array('conditions' => array('data' => 'summary'), 'pattern' => "/^[\+\-]?[\d]+(\.[\d]+)?$/", 'min' => -99999998.99, 'max' => 99999998.99, 'error' => $lang->errorMean);
        self::$settings['sample2SD']       += array('conditions' => array('data' => 'summary'), 'pattern' => "/^([1-9]\d*)(\.[\d]+)?$|^0\.\d+?$/", 'max' => 99999998.99, 'error' => $lang->errorSD);
        self::$settings['deviation']       += array('pattern' => "/^[\+\-]?[\d]+(\.[\d]+)?$/", 'min' => -99999998.99, 'max' => 99999998.99, 'error' => $lang->errorDeviation);
        self::$settings['confidence']      += array('pattern' => "/^[\+\-]?[\d]+(\.[\d]+)?$/", 'error' => $lang->errorConfidence, 'min' => 0.000101, 'max' => 99.999899);

        /* Col grid settings */
        self::$settings['data']            += array('col' => 4);

        /* More settings */
        self::$settings['deviation']       += array('paramType' => 'more');
        self::$settings['confidence']      += array('paramType' => 'more');
        self::$settings['alternativeHypo'] += array('paramType' => 'more');

        /* Data validate */
        self::$settings['sampleS']  += array('validate' => array('continuous', 'number', 'notCommon', 'rowEqual'));
        self::$settings['sampleID'] += array('validate' => array('continuous', 'columnUnique == 2', 'rowEqual'));
        self::$settings['sample1']  += array('validate' => array('continuous', 'number', 'notCommon'));
        self::$settings['sample2']  += array('validate' => array('continuous', 'number', 'notCommon'));

        return self::$settings;
    }

    /**
     * Get config.
     *
     * @access public
     * @return object
     */
    public static function getConfig()
    {
        global $dasLang;
        $lang = $dasLang->config;

        //return self::$config;
    }
}
