<?php
require_once LIB_ROOT . '/dataframe/hypothesis/pairt.php';
require_once LIB_ROOT . '/dataframe/checkdata.php';
require_once LIB_ROOT . '/dataframe/validatedata.php';

/* 配对t */
class pairtMethod
{
    /* Method name 分析方法内部名称 */
    public static $name = 'pairt';

    /* Method settings 方法设置参数定义 */
    public static $settings = array();

    /* Diagram config 图表配置项 */
    public static $config = array();

    /* Callback for basic hypothesis method 基本量统计计算回调函数 */
    public static function func($dataframe, $settings)
    {
        global $dasLang;
        global $lang;

        $dataDesc     = $settings['data'];
        $sampleS      = $settings['sampleS'];
        $sampleA      = $settings['sampleA'];
        $sampleSample = $settings['sampleSample'];
        $sampleMean   = $settings['sampleMean'];
        $sampleSD     = $settings['sampleSD'];
        $deviation    = $settings['deviation'];
        $confidence   = $settings['confidence'];
        $alterHypo    = $settings['alternativeHypo'];

        $pairt = new pairt($dataframe, $dataDesc, $confidence, $deviation, $alterHypo, $dasLang->pairt);

        if($dataDesc == 'notSameCol')
        {
            $sliceDF = $dataframe->sliceDataframe($dataframe, array($sampleS, $sampleA), 'any');
            $check = new checkData();
            $check->setData($dataframe->colData($sampleS), $dataframe->columns[$sampleS], self::$settings['sampleS']['validate']);
            $check->setData($dataframe->colData($sampleA), $dataframe->columns[$sampleA], self::$settings['sampleA']['validate']);

            $checkRes = $check->check();
            if(is_string($checkRes)) return ValidateData::result($checkRes);

            $C1      = $sliceDF->columns[$sampleS];
            $C2      = $sliceDF->columns[$sampleA];

            $column1Data = $sliceDF->col($sampleS, 'number')->data;
            $column2Data = $sliceDF->col($sampleA, 'number')->data;

            $pairt->setISCParams($column1Data, $column2Data, $C1, $C2);
        }
        elseif($dataDesc == 'summary')
        {
            $pairt->setSummaryParams($sampleSample, $sampleMean, $sampleSD);
        }

        $pairt->setDifference();
        $pairt->setTest();

        $allResult = array();
        if($dataDesc == 'notSameCol') $allResult[] = $pairt->getDescriptiveStatistics();
        $allResult[] = $pairt->getDifference();
        $allResult[] = $pairt->getTest();

        return $allResult;
    }

    /**
     * Check whether the data meets the requirements.
     *
     * @param  object $dataframe
     * @param  string $dataDesc
     * @param  int    $col1
     * @param  int    $col2
     * @param  int    $col3
     * @param  int    $col4
     * @access public
     * @return object
     */
    public static function checkData($dataframe, $dataDesc, $col1, $col2)
    {
        global $dasLang;
        $lang = $dasLang->pairt;

        if($dataDesc == 'notSameCol')
        {
            $sliceDF = $dataframe->sliceDataframe($dataframe, array($col1, $col2), 'any');

            $check = checkNullColumns($sliceDF, array($col1, $col2), $dasLang->common->errorLine);
            if($check['result'] == 'fail') return $check;

            $check = checkColumnsLengthSame($sliceDF, array($col1, $col2), $dasLang->common->notSameLine);
            if($check['result'] == 'fail') return $check;

            $column1 = $sliceDF->col($col1);
            $column2 = $sliceDF->col($col2);
            if($col1 == $col2) return array('result' => 'fail', 'message' => $lang->errorCheck);
            if($column1->haveString) return array('result' => 'fail', 'message' => sprintf($lang->errorString, $sliceDF->columns[$col1]));
            if($column2->haveString) return array('result' => 'fail', 'message' => sprintf($lang->errorString, $sliceDF->columns[$col2]));
        }
    }

    /**
     * Get settings.
     *
     * @access public
     * @return object
     */
    public static function getSettings()
    {
        global $dasLang;
        $lang = $dasLang->pairt;

        /* Basic settings */
        self::$settings['data']            = array('name' => 'data',            'label' => $lang->data);
        self::$settings['sampleS']         = array('name' => 'sampleS',         'label' => $lang->sampleS,         'required' => true);
        self::$settings['sampleA']         = array('name' => 'sampleA',         'label' => $lang->sampleA,         'required' => true);
        self::$settings['sampleSample']    = array('name' => 'sampleSample',    'label' => $lang->sampleSample,    'required' => true);
        self::$settings['sampleMean']      = array('name' => 'sampleMean',      'label' => $lang->sampleMean,      'required' => true);
        self::$settings['sampleSD']        = array('name' => 'sampleSD',        'label' => $lang->sampleSD,        'required' => true);
        self::$settings['deviation']       = array('name' => 'deviation',       'label' => $lang->deviation,       'required' => true);
        self::$settings['confidence']      = array('name' => 'confidence',      'label' => $lang->confidence,      'required' => true);
        self::$settings['alternativeHypo'] = array('name' => 'alternativeHypo', 'label' => $lang->alternativeHypo, 'required' => true);

        /* Type settings */
        self::$settings['data']            += array('type' => 'enum', 'enumOptions' => array('notSameCol' => $lang->notSameCol, 'summary' => $lang->summary), 'defaultValue' => 'notSameCol');
        self::$settings['sampleS']         += array('type' => 'column', 'listType' => 'column', 'columnType' => 'number');
        self::$settings['sampleA']         += array('type' => 'column', 'listType' => 'column', 'columnType' => 'number');
        self::$settings['sampleSample']    += array('type' => 'number', 'columnType' => 'number');
        self::$settings['sampleMean']      += array('type' => 'number');
        self::$settings['sampleSD']        += array('type' => 'number');
        self::$settings['deviation']       += array('type' => 'number', 'defaultValue' => 0, 'error' => $lang->errorDeviation);
        self::$settings['confidence']      += array('type' => 'number', 'defaultValue' => 95);
        self::$settings['alternativeHypo'] += array('type' => 'enum', 'ui' => 'select', 'enumOptions' => $lang->alternativeHypoEnum, 'defaultValue' => 'ne');

        /* Limit settings */
        self::$settings['sampleS']         += array('conditions' => array('data' => 'notSameCol'));
        self::$settings['sampleA']         += array('conditions' => array('data' => 'notSameCol'));
        self::$settings['sampleSample']    += array('conditions' => array('data' => 'summary'), 'pattern' => "/^[1-9]([0-9]{1,7})?$/", 'min' => 1, 'max' => 99999998.99, 'error' => $lang->errorSample);
        self::$settings['sampleMean']      += array('conditions' => array('data' => 'summary'), 'pattern' => "/^[\+\-]?[\d]+(\.[\d]+)?$/", 'min' => -99999998.99, 'max' => 99999998.99, 'error' => $lang->errorMean);
        self::$settings['sampleSD']        += array('conditions' => array('data' => 'summary'), 'pattern' => "/^([1-9]\d*)(\.[\d]+)?$|^0\.\d+?$/", 'min' => -99999998.99, 'max' => 99999998.99, 'error' => $lang->errorSD);
        self::$settings['deviation']       += array('pattern' => "/^[\+\-]?[\d]+(\.[\d]+)?$/", 'min' => -99999998.99, 'max' => 99999998.99, 'error' => $lang->errorDeviation);
        self::$settings['confidence']      += array('pattern' => "/^[\+\-]?[\d]+(\.[\d]+)?$/", 'error' => $lang->errorConfidence, 'min' => 0.000101, 'max' => 99.999899);

        /* Col grid settings */
        self::$settings['data']            += array('col' => 6);

        /* More settings */
        self::$settings['deviation']       += array('paramType' => 'more');
        self::$settings['confidence']      += array('paramType' => 'more');
        self::$settings['alternativeHypo'] += array('paramType' => 'more');

        /* Data validate */
        self::$settings['sampleS'] += array('validate' => array('continuous', 'number', 'N >= 2', 'notCommon', 'rowEqual'));
        self::$settings['sampleA'] += array('validate' => array('continuous', 'number', 'N >= 2', 'notCommon', 'rowEqual'));

        return self::$settings;
    }

    /**
     * Get config.
     *
     * @access public
     * @return object
     */
    public static function getConfig()
    {
        global $dasLang;
        $lang = $dasLang->config;

        //return self::$config;
    }
}
