<?php
require_once LIB_ROOT . '/dataframe/checkdata.php';
require_once LIB_ROOT . '/dataframe/validatedata.php';

/* Radar plot method 基本量统计 */
class radarPlotMethod
{
    /* Method name 分析方法内部名称 */
    public static $name = 'radarPlot';

    /* Method settings 方法设置参数定义 */
    public static $settings = array();

    /* Callback for basic statistic method 基本量统计计算回调函数 */
    public static function func($dataframe, $settings)
    {
        global $lang;
        global $dasLang;

        $xaxis = $settings['xaxis'];
        $yaxis = $settings['yaxis'];

        $xaxisName  = $dataframe->columns[$xaxis];
        $yaxisNames = array();
        foreach($yaxis as $yi)
        {
            $yaxisNames[] = $dataframe->columns[$yi];
        }

        $sliceDF = $dataframe->sliceDataframe($dataframe, array_merge(array($xaxis), $yaxis), 'any');

        $check = new checkData();
        $check->setData($dataframe->colData($xaxis), $dataframe->columns[$xaxis], self::$settings['xaxis']['validate']);
        $check->setDataList($dataframe->colsData($yaxis), $dataframe->colsName($yaxis), self::$settings['yaxis']['validate']);

        $checkRes = $check->check();
        if(is_string($checkRes)) return ValidateData::result($checkRes);

        $result = new stdclass();
        $result->type  = 'chart';
        $result->title = '';

        $result->data = array();
        $result->data['type'] = 'scatterpolar';

        $data = array();
        $x    = $sliceDF->col($xaxis, 'any');

        foreach($yaxis as $yi)
        {
            if($yi == $xaxis) continue;

            $y      = $sliceDF->col($yi, 'number');
            $name   = $sliceDF->columns[$yi];
            $data[] = array('theta' => $x->trimdata, 'r' => $y->trimdata, 'name' => $name, 'type' => 'scatterpolar', 'fill' => 'toself');
        }

        $result->data['data'] = json_encode($data);
        $result->data['layout'] = array('polar' => array('radialaxis' => array('visible' => true)), 'title' => $settings['title']);

        $legend = $dasLang->config->legendConfig;
        $legend['defaultValue'] = 'true';
        $result->data['config'] = array('legend' => $legend);

        $textResult = $dataframe->getTextResult($dataframe->getChartTitle(array('x' => $settings['xaxis'], 'y' => $settings['yaxis']), $lang->perfanalysis->methods->graphic['radarPlot'], 'versus'));
        $textResult->children = 1;

        return array($textResult, $result);
    }

    /**
     * Get settings.
     *
     * @param object $lang
     * @access public
     * @return object
     */
    public static function getSettings()
    {
        global $dasLang;

        /* Basic settings */
        /* Type settings */
        /* Limit settings */
        /* Col grid settings */
        /* More settings */

        self::$settings['xaxis'] = array('name' => 'xaxis', 'label' => $dasLang->radar->xaxis, 'type' => 'column', 'required' => true, 'columnType' => 'any');
        self::$settings['yaxis'] = array('name' => 'yaxis', 'label' => $dasLang->radar->yaxis, 'type' => 'column', 'required' => true, 'type' => 'list', 'listType' => 'column', 'columnType' => 'number', 'distinct' => 'xaxis');

        /* Data validate */
        self::$settings['xaxis'] += array('validate' => array('rowEqual'));
        self::$settings['yaxis'] += array('validate' => array('continuous', 'number', 'rowEqual'));

        return self::$settings;
    }

    /**
     * Get config.
     *
     * @access public
     * @return object
     */
    public static function getConfig()
    {
        global $dasLang;
        $lang = $dasLang->config;

        //return self::$config;
    }

    /**
     * Get Setting column type.
     *
     * @param string $index
     * @access public
     * @return string
     */
    public static function columnType($index)
    {
        return self::$settings[$index]['columnType'];
    }
}
