<?php
require_once LIB_ROOT . '/dataframe/checkdata.php';
require_once LIB_ROOT . '/dataframe/validatedata.php';

/* Pie plot method 基本量统计 */
class piePlotMethod
{
    /* Method name 分析方法内部名称 */
    public static $name = 'piePlot';

    /* Method settings 方法设置参数定义 */
    public static $settings = array();

    /* Callback for basic statistic method 基本量统计计算回调函数 */
    public static function func($dataframe, $settings)
    {
        global $lang;
        global $dasLang;
        $data = array();

        $xaxis = $settings['xaxis'];
        $yaxis = $settings['yaxis'];
        $sort  = $settings['sort'];

        $check = new checkData();
        $check->setData($dataframe->colData($xaxis), $dataframe->columns[$xaxis], self::$settings['xaxis']['validate']);
        $check->setData($dataframe->colData($yaxis), $dataframe->columns[$yaxis], self::$settings['yaxis']['validate']);

        $checkRes = $check->check();
        if(is_string($checkRes)) return ValidateData::result($checkRes);

        $sliceDF = $dataframe->sliceDataframe($dataframe, array($xaxis, $yaxis), 'any');

        $result = new stdclass();
        $result->type  = 'chart';
        $result->title = '';

        $result->data = array();
        $result->data['type'] = 'pie';

        $x = $sliceDF->col($xaxis, self::columnType('xaxis'));
        $y = $sliceDF->col($yaxis, self::columnType('yaxis'));

        $pieData = array();
        foreach($x->data as $index => $value)
        {
            if(!is_numeric($value) and empty($value)) $value = 'null';
            if(!isset($pieData[$value])) $pieData[$value] = 0;
            $pieData[$value] += $y->data[$index];
        }

        if($sort == 'desc') arsort($pieData);
        if($sort == 'asc') asort($pieData);

        $sum = array_sum($pieData);
        $text = array();
        foreach($pieData as $key => $value)
        {
            $text[] = round($value / $sum * 100, 2);
        }

        array_pop($text);
        $text[] = round(100 - array_sum($text), 2);

        $data = array();
        $data['labels']        = array_keys($pieData);
        $data['values']        = array_values($pieData);
        $data['text']          = $text;
        $data['type']          = 'pie';
        $data['sort']          = false;
        $data['direction']     = 'clockwise';
        $data['texttemplate']  = '%{text}%';
        $data['hovertemplate'] = '%{label}<br>%{text}%<extra></extra>';

        $result->data['data']   = json_encode(array($data));
        $result->data['layout'] = array('title' => $settings['title']);

        $legend = $dasLang->config->legendConfig;
        $legend['defaultValue'] = 'true';
        $result->data['config'] = array('legend' => $legend);

        $textResult = $dataframe->getTextResult($dataframe->getChartTitle(array('x' => $settings['xaxis'], 'y' => $settings['yaxis']), $lang->perfanalysis->methods->graphic['piePlot'], 'versus'));
        $textResult->children = 1;

        return array($textResult, $result);
    }

    /**
     * Get settings.
     *
     * @param object $lang
     * @access public
     * @return object
     */
    public static function getSettings()
    {
        global $dasLang;

        /* Basic settings */
        /* Type settings */
        /* Limit settings */
        /* Col grid settings */
        /* More settings */

        self::$settings['xaxis'] = array('name' => 'xaxis', 'label' => $dasLang->pie->xaxis, 'type' => 'column', 'required' => true, 'columnType' => 'any');
        self::$settings['yaxis'] = array('name' => 'yaxis', 'label' => $dasLang->pie->yaxis, 'type' => 'column', 'required' => true, 'columnType' => 'number', 'distinct' => 'xaxis');
        self::$settings['sort']  = array('name' => 'sort', 'label' => $dasLang->pie->sort, 'type' => 'enum', 'col' => 4, 'enumOptions' => $dasLang->pie->sortEnum, 'defaultValue' => 'default');

        /* Data validate */
        self::$settings['xaxis'] += array('validate' => array('rowEqual'));
        self::$settings['yaxis'] += array('validate' => array('continuous', 'positive', 'number', 'rowEqual'));

        return self::$settings;
    }

    /**
     * Get config.
     *
     * @access public
     * @return object
     */
    public static function getConfig()
    {
        global $dasLang;
        $lang = $dasLang->config;

        //return self::$config;
    }

    /**
     * Get Setting column type.
     *
     * @param string $index
     * @access public
     * @return string
     */
    public static function columnType($index)
    {
        return self::$settings[$index]['columnType'];
    }
}
