<?php
require_once LIB_ROOT . '/dataframe/checkdata.php';
require_once LIB_ROOT . '/dataframe/validatedata.php';
require_once LIB_ROOT . '/dataframe/plotly.php';

/* Line plot method 基本量统计 */
class linePlotMethod
{
    /* Method name 分析方法内部名称 */
    public static $name = 'linePlot';

    /* Method settings 方法设置参数定义 */
    public static $settings = array();

    /* Diagram config 图表配置项 */
    public static $config = array();

    /* Callback for basic statistic method 基本量统计计算回调函数 */
    public static function func($dataframe, $settings)
    {
        global $lang;
        global $dasLang;
        $data = array();

        $result = new stdclass();
        $result->type  = 'chart';
        $result->title = '';

        $result->data = array();
        $result->data['type'] = 'line';

        $datas = array();
        $xaxis = $settings['xaxis'];
        $yaxis = $settings['yaxis'];
        $xName = $settings['xname'];
        $yName = $settings['yname'];

        $check = new checkData();
        $check->setData($dataframe->colData($xaxis), $dataframe->columns[$xaxis], self::$settings['xaxis']['validate']);
        $check->setDataList($dataframe->colsData($yaxis), $dataframe->colsName($yaxis), self::$settings['yaxis']['validate']);

        $checkRes = $check->check();
        if(is_string($checkRes)) return ValidateData::result($checkRes);

        $sliceDF = $dataframe->sliceDataframe($dataframe, array_merge(array($xaxis), $yaxis), 'any');
        $x       = $sliceDF->col($settings['xaxis'], 'any');

        $xdata       = $x->trimdata;
        $unsortDatas = $x->trimdata;
        asort($xdata);
        $xdataValues = array_values($xdata);

        foreach($settings['yaxis'] as $yaxis)
        {
            if($yaxis == $xaxis) continue;

            $y      = $sliceDF->col($yaxis, self::columnType('yaxis'));
            $name   = $sliceDF->columns[$yaxis];

            $ydata = array();
            foreach($xdata as $index => $value)
            {
                $ydata[] = $y->trimdata[$index];
            }

            $data = array('x' => $xdataValues, 'y' => $ydata, 'name' => $name, 'type' => 'scatter', 'marker' => array('size' => $sliceDF->pointSize));
            $data = getHoverTemplateXY($data, array('xname' => $sliceDF->columns[$xaxis], 'yname' => $sliceDF->columns[$yaxis], 'custom' => getDisOrderCustom($xdataValues, $unsortDatas)));
            $datas[] = $data;
        }

        $result->data['data']   = json_encode($datas);
        $result->data['layout'] = array('title' => $settings['title'], 'xaxis' => array('title' => !empty($xName) ? $xName : $sliceDF->columns[$xaxis]), 'yaxis' => array('title' => $yName));

        $grid   = $dasLang->config->gridConfig;
        $title  = $dasLang->config->titleConfig;
        $legend = $dasLang->config->legendConfig;
        $legend['defaultValue'] = 'true';
        $result->data['config'] = array('grid' => $grid, 'title' => $title, 'legend' => $legend);

        $textResult = $sliceDF->getTextResult($sliceDF->getChartTitle(array('x' => $settings['xaxis'], 'y' => $settings['yaxis']), $lang->perfanalysis->methods->graphic['linePlot'], 'versus'));
        $textResult->children = 1;

        return array($textResult, $result);
    }

    /**
     * Get settings.
     *
     * @access public
     * @return object
     */
    public static function getSettings()
    {
        global $dasLang;

        /* Basic settings */
        /* Type settings */
        /* Limit settings */
        /* Col grid settings */
        /* More settings */

        self::$settings['xaxis'] = array('name' => 'xaxis', 'label' => $dasLang->line->xaxis, 'type' => 'column', 'required' => true, 'columnType' => 'any');
        self::$settings['yaxis'] = array('name' => 'yaxis', 'label' => $dasLang->line->yaxis, 'type' => 'column', 'required' => true, 'type' => 'list', 'listType' => 'column', 'columnType' => 'number', 'distinct' => 'xaxis');
        self::$settings['xname'] = array('name' => 'xname', 'type' => 'any', 'label' => $dasLang->xAxisName, 'paramType' => 'more');
        self::$settings['yname'] = array('name' => 'yname', 'type' => 'any', 'label' => $dasLang->yAxisName, 'paramType' => 'more');

        /* Data validate */
        self::$settings['xaxis'] += array('validate' => array('continuous', 'rowEqual'));
        self::$settings['yaxis'] += array('validate' => array('continuous', 'number', 'rowEqual'));

        return self::$settings;
    }

    /**
     * Get config.
     *
     * @access public
     * @return object
     */
    public static function getConfig()
    {
        global $dasLang;
        $lang = $dasLang->config;
        self::$config['grid']   = $lang->gridConfig;
        self::$config['legend'] = $lang->legendConfig;

        return self::$config;
    }

    /**
     * Get Setting column type.
     *
     * @param string $index
     * @access public
     * @return string
     */
    public static function columnType($index)
    {
        return self::$settings[$index]['columnType'];
    }
}
