<?php
require_once LIB_ROOT . '/dataframe/checkdata.php';
require_once LIB_ROOT . '/dataframe/validatedata.php';
require_once LIB_ROOT . '/dataframe/plotly.php';

/* Individual value plot method 基本量统计 */
class individualValuePlotMethod
{
    /* Method name 分析方法内部名称 */
    public static $name = 'individualValuePlot';

    /* Method settings 方法设置参数定义 */
    public static $settings = array();

    /* Diagram config 图表配置项 */
    public static $config = array();

    /* Callback for basic statistic method 基本量统计计算回调函数 */
    public static function func($dataframe, $settings)
    {
        global $lang;
        global $dasLang;

        $yaxis = $settings['yaxis'];
        $yName = $settings['yname'];

        $sliceDF = $dataframe->sliceDataframe($dataframe, $yaxis, 'any');

        $check = new checkData();
        $check->setDataList($dataframe->colsData($yaxis), $dataframe->colsName($yaxis), self::$settings['yaxis']['validate']);

        $checkRes = $check->check();
        if(is_string($checkRes)) return ValidateData::result($checkRes);

        $result = new stdclass();
        $result->type  = 'chart';
        $result->title = '';

        $result->data = array();
        $result->data['type'] = 'scatter';

        $datas       = array();
        $annotations = array();
        foreach($yaxis as $index => $yi)
        {
            $y      = $sliceDF->col($yi, 'number');
            $name   = $sliceDF->columns[$yi];
            $ydata  = $y->trimdata;
            $unsort = $y->trimdata;
            sort($ydata);
            $x      = self::getRepeat($ydata, $index + 1);

            $data    = array('x' => $x, 'y' => $ydata, 'name' => $name, 'hoverinfo'=> 'x+y', 'mode' => 'markers', 'type' => 'scatter', 'marker' => array('size' => $dataframe->pointSize));
            $data    = getHoverTemplateY($data, array('yname' => $sliceDF->columns[$yi], 'custom' => getDisOrderCustom($ydata, $unsort)));
            $datas[] = $data;
            $annotations[] = array('x' => $index + 1, 'y' => 0, 'yanchor' => 'top', 'text' => $name, 'showarrow' => false);
        }

        $result->data['data'] = json_encode($datas);
        $result->data['layout'] = array('xaxis' => array('range' => array(0, count($settings['yaxis']) + 1), 'visible' => false), 'yaxis' => array('title' => $yName), 'annotations' => $annotations);

        $grid   = $dasLang->config->gridConfig;
        $legend = $dasLang->config->legendConfig;
        $legend['defaultValue'] = 'true';
        $result->data['config'] = array('grid' => $grid, 'legend' => $legend);

        $textResult = $dataframe->getTextResult($dataframe->getChartTitle($settings['yaxis'], $lang->perfanalysis->methods->graphic['individualValuePlot']));
        $textResult->children = 1;

        return array($textResult, $result);
    }

    /**
     * Get settings.
     *
     * @access public
     * @return object
     */
    public static function getSettings()
    {
        global $dasLang;

        /* Basic settings */
        /* Type settings */
        /* Limit settings */
        /* Col grid settings */
        /* More settings */

        self::$settings['yaxis'] = array('name' => 'yaxis', 'label' => $dasLang->individualValue->yaxis, 'type' => 'column', 'required' => true, 'type' => 'list', 'listType' => 'column', 'columnType' => 'number');
        self::$settings['yname'] = array('name' => 'yname', 'type' => 'any', 'label' => $dasLang->yAxisName, 'paramType' => 'more');

        /* Data validate */
        self::$settings['yaxis'] += array('validate' => array('continuous', 'number'));

        return self::$settings;
    }

    /**
     * Get config.
     *
     * @access public
     * @return object
     */
    public static function getConfig()
    {
        global $dasLang;
        $lang = $dasLang->config;
        self::$config['grid']   = $lang->gridConfig;
        self::$config['legend'] = $lang->legendConfig;

        return self::$config;
    }

    /*
     * Get repeat value of data
     *
     * @access private
     * @return array
     */
    private static function getRepeat($data, $basic)
    {
        $result = array();
        $repeat = 0;
        $n      = count($data);
        $increment = 0.01;

        foreach($data as $index => $item)
        {
            $nextData = $index + 1 >= $n ? null : $data[$index + 1];

            if($nextData === null || ($nextData != $item && $repeat == 0))
            {
                $result[] = $basic;
            }

            if($item != $nextData && $repeat != 0)
            {
                $repeat += 1;

                $pre  = array();
                $next = array();

                for($i = 1; $i <= $repeat / 2; $i++)
                {
                    $pre[]  = round($basic - ($increment * $i), 2);
                    $next[] = round($basic + ($increment * $i), 2);
                }

                $result = array_merge($result, $pre);
                if($repeat % 2 != 0) $result[] = $basic;
                $result = array_merge($result, $next);

                $repeat = 0;
            }

            if($item == $nextData) $repeat += 1;
        }

        return $result;
    }

    /**
     * Get Setting column type.
     *
     * @param string $index
     * @access public
     * @return string
     */
    public static function columnType($index)
    {
        return self::$settings[$index]['columnType'];
    }
}

