<?php
require_once LIB_ROOT . '/dataframe/checkdata.php';
require_once LIB_ROOT . '/dataframe/validatedata.php';
require_once LIB_ROOT . '/dataframe/plotly.php';
require_once LIB_ROOT . '/dataframe/stat/empirical.php';

/* Empirical plot method 基本量统计 */
class empiricalPlotMethod
{
    /* Method name 分析方法内部名称 */
    public static $name = 'empiricalPlot';

    /* Method settings 方法设置参数定义 */
    public static $settings = array();

    /* Diagram config 图表配置项 */
    public static $config = array();

    /* Callback for basic statistic method 基本量统计计算回调函数 */
    public static function func($dataframe, $settings)
    {
        global $dasLang;
        global $lang;

        $datas   = array();
        $xaxis   = $settings['xaxis'];
        $x       = $dataframe->col($xaxis, 'number');
        $n       = count($x->trimdata);

        $check = new checkData();
        $check->setData($dataframe->colData($xaxis), $dataframe->columns[$xaxis], self::$settings['xaxis']['validate']);

        $checkRes = $check->check();
        if(is_string($checkRes)) return ValidateData::result($checkRes);

        $result = new stdclass();
        $result->type  = 'chart';
        $result->title = '';

        $result->data = array();
        $result->data['type'] = 'empirical';

        if($n < 2) return array();

        $empirical = new empirical($dataframe, $x->trimdata);
        list($xlines, $ylines) = $empirical->exp();
        $data = array('x' => $xlines, 'y' => $ylines, 'mode' => 'lines', 'name' => $dasLang->empirical->expLine, 'type' => 'scatter');
        $data = getHoverTemplateXY($data, array('xname' => $dataframe->columns[$xaxis], 'yname' => $dasLang->empirical->percentage, 'extra' => $dasLang->empirical->expLine, 'custom' => getDisOrderCustom($xlines, $x->trimdata)));
        $datas[] = $data;

        /* Fit Line  */
        list($xpoints, $expoints) = $empirical->fit();
        $data = array('name' => $dasLang->empirical->fitLine, 'x' => $xpoints, 'y' => $expoints, 'line' => array('shape' => 'spline'), 'mode' => 'lines', 'type' => 'scatter', 'marker' => array('size' => $dataframe->pointSize));
        $data = getHoverTemplateXY($data, array('xname' => $dataframe->columns[$xaxis], 'yname' => $dasLang->empirical->percentage, 'extra' => $dasLang->empirical->fitLine));
        $datas[] = $data;

        /* Percent lines */
        $percent = $settings['percent'];
        if(is_numeric($percent) && $percent <= 100 && $percent > 0)
        {
            list($percentX, $percentY) = $empirical->percentage($xpoints, $expoints, $percent);
            $data = array('x' => array(0, $percentX, $percentX), 'y' => array($percentY, $percentY, 0), 'mode'=>'lines', 'name' => "$percent%" . $dasLang->empirical->percentLine, 'type' => 'scatter');
            $datas[] = $data;
        }
        $result->data['data'] = json_encode($datas);
        $result->data['layout'] = array('xaxis' => array('title' => $dataframe->columns[$xaxis], 'range' => $empirical->limit()), 'yaxis' => array('title' => $dasLang->empirical->percentage));

        $grid   = $dasLang->config->gridConfig;
        $title  = $dasLang->config->titleConfig;
        $legend = $dasLang->config->legendConfig;
        $legend['defaultValue'] = 'true';
        $result->data['config'] = array('grid' => $grid, 'title' => $title, 'legend' => $legend);

        $textResult = $dataframe->getTextResult($dataframe->getChartTitle($settings['xaxis'], $lang->perfanalysis->methods->graphic['empiricalPlot']));
        $textResult->children = 1;

        return array($textResult, $result);
    }

    /**
     * Get settings.
     *
     * @access public
     * @return object
     */
    public static function getSettings()
    {
        global $dasLang;

        /* Basic settings */
        self::$settings['xaxis']   = array('name' => 'xaxis', 'label' => $dasLang->empirical->xaxis, 'required' => true);
        self::$settings['percent'] = array('name' => 'percent', 'label' => $dasLang->empirical->percent, 'required' => false);

        /* Type settings */
        self::$settings['xaxis']   += array('type' => 'column', 'columnType' => 'number');
        self::$settings['percent'] += array('type' => 'number', 'columnType' => 'number');

        /* Limit settings */
        /* Col grid settings */
        /* More settings */

        /* Data validate */
        self::$settings['xaxis']   += array('validate' => array('continuous', 'number', 'notCommon'));

        return self::$settings;
    }

    /**
     * Get config.
     *
     * @access public
     * @return object
     */
    public static function getConfig()
    {
        global $dasLang;
        $lang = $dasLang->config;
        self::$config['grid']   = $lang->gridConfig;
        self::$config['legend'] = $lang->legendConfig;

        return self::$config;
    }
}
