<?php
require_once LIB_ROOT . '/dataframe/checkdata.php';
require_once LIB_ROOT . '/dataframe/validatedata.php';

/* Bubble plot method 基本量统计 */
class bubblePlotMethod
{
    /* Method name 分析方法内部名称 */
    public static $name = 'bubblePlot';

    /* Method settings 方法设置参数定义 */
    public static $settings = array();

    /* Diagram config 图表配置项 */
    public static $config = array();

    /* Color config 颜色配置项 */
    public static $colors = array('#5470c6', '#91cc75', '#fac858', '#ee6666', '#73c0de', '#3ba272', '#fc8452', '#9a60b4', '#ea7ccc');

    /* Callback for basic statistic method 基本量统计计算回调函数 */
    public static function func($dataframe, $settings)
    {
        global $lang;
        global $dasLang;

        $data  = array();
        $xaxis = $settings['xaxis'];
        $yaxis = $settings['yaxis'];
        $size  = $settings['size'];
        $minSize  = $settings['minSize'];
        $maxSize  = $settings['maxSize'];
        $xName = $settings['xname'];
        $yName = $settings['yname'];

        $check = new checkData();
        $check->setData($dataframe->colData($xaxis), $dataframe->columns[$xaxis], self::$settings['xaxis']['validate']);
        $check->setDataList($dataframe->colsData($yaxis), $dataframe->colsName($yaxis), self::$settings['yaxis']['validate']);
        $check->setDataList($dataframe->colsData($size), $dataframe->colsName($size), self::$settings['size']['validate']);

        $checkRes = $check->check();
        if(is_string($checkRes)) return ValidateData::result($checkRes);

        $result = new stdclass();
        $result->type  = 'chart';
        $result->title = '';

        $result->data = array();
        $result->data['type'] = 'bubble';

        $colorIndex = 0;
        $x          = $dataframe->col($xaxis, 'any');

        foreach($yaxis as $index => $yi)
        {
            if($yi == $xaxis) continue;

            $y     = $dataframe->col($yi, 'number');
            $index = isset($size[$index]) ? $index : 0;
            $s     = $dataframe->col($size[$index], 'number');
            $name  = $dataframe->columns[$yi];

            $sizeMax = max($s->trimdata);
            $sizeMin = min($s->trimdata);

            $sizeData = array();
            foreach($s->trimdata as $value)
            {
                $sizeData[] = round(($value - $sizeMin) / ($sizeMax - $sizeMin) * ($maxSize - $minSize)) + $minSize;
            }
            $color  = array_fill(0, count($y->trimdata), self::$colors[$colorIndex]);
            $data[] = array('x' => $x->trimdata, 'y' => $y->trimdata, 'name' => $name, 'mode' => 'markers', 'marker' => array('color' => $color, 'size' => $sizeData));

            $colorIndex = ($colorIndex + 1) % count(self::$colors);
        }

        $result->data['data']   = json_encode($data);
        $result->data['layout'] = array('title' => $settings['title'], 'xaxis' => array('title' => !empty($xName) ? $xName : $dataframe->columns[$xaxis]), 'yaxis' => array('title' => $yName));

        $grid   = $dasLang->config->gridConfig;
        $title  = $dasLang->config->titleConfig;
        $legend = $dasLang->config->legendConfig;
        $legend['defaultValue'] = 'true';
        $result->data['config'] = array('grid' => $grid, 'title' => $title, 'legend' => $legend);

        $textResult = $dataframe->getTextResult($dataframe->getChartTitle(array('x' => $settings['xaxis'], 'y' => $settings['yaxis']), $lang->perfanalysis->methods->graphic['bubblePlot'], 'versus'));
        $textResult->children = 1;

        return array($textResult, $result);
    }

    /**
     * Get settings.
     *
     * @access public
     * @return object
     */
    public static function getSettings()
    {
        global $dasLang;

        /* Basic settings */
        self::$settings['xaxis']   = array('name' => 'xaxis', 'label' => $dasLang->bubble->xaxis, 'required' => true);
        self::$settings['yaxis']   = array('name' => 'yaxis', 'label' => $dasLang->bubble->yaxis, 'required' => true);
        self::$settings['size']    = array('name' => 'size',  'label' => $dasLang->bubble->size, 'required' => true);
        self::$settings['minSize'] = array('name' => 'minSize',  'label' => $dasLang->bubble->minSize, 'required' => true, 'defaultValue' => 3);
        self::$settings['maxSize'] = array('name' => 'maxSize',  'label' => $dasLang->bubble->maxSize, 'required' => true, 'defaultValue' => 40);
        self::$settings['xname']   = array('name' => 'xname', 'label' => $dasLang->xAxisName);
        self::$settings['yname']   = array('name' => 'yname', 'label' => $dasLang->yAxisName);

        /* Type settings */
        self::$settings['xaxis']   += array('type' => 'column', 'columnType' => 'any');
        self::$settings['yaxis']   += array('type' => 'list', 'listType' => 'column', 'columnType' => 'number');
        self::$settings['size']    += array('type' => 'list', 'listType' => 'column', 'columnType' => 'number');
        self::$settings['minSize'] += array('type' => 'number');
        self::$settings['maxSize'] += array('type' => 'number');
        self::$settings['xname']   += array('type' => 'any');
        self::$settings['yname']   += array('type' => 'any');

        /* Limit settings */
        self::$settings['yaxis']   += array('distinct' => 'xaxis');
        self::$settings['minSize'] += array('min' => 0, 'max' => 11);
        self::$settings['maxSize'] += array('min' => 21, 'max' => 41);

        /* Col grid settings */
        /* More settings */
        self::$settings['xname']   += array('paramType' => 'more');
        self::$settings['yname']   += array('paramType' => 'more');
        self::$settings['minSize'] += array('paramType' => 'more');
        self::$settings['maxSize'] += array('paramType' => 'more');

        /* Data validate */
        self::$settings['xaxis'] += array('validate' => array('continuous', 'rowEqual'));
        self::$settings['yaxis'] += array('validate' => array('continuous', 'number', 'rowEqual'));
        self::$settings['size']  += array('validate' => array('continuous', 'number', 'positive', 'rowEqual'));

        return self::$settings;
    }

    /**
     * Get config.
     *
     * @access public
     * @return object
     */
    public static function getConfig()
    {
        global $dasLang;
        $lang = $dasLang->config;
        self::$config['grid']   = $lang->gridConfig;
        self::$config['label']  = $lang->labelConfig;
        self::$config['legend'] = $lang->legendConfig;

        return self::$config;
    }
}
