<?php
require_once LIB_ROOT . '/dataframe/spc/C.php';
require_once LIB_ROOT . '/dataframe/checkdata.php';
require_once LIB_ROOT . '/dataframe/validatedata.php';
require_once 'spc.php';

/* C 控制图 */
class CMethod
{
    /* Method name 分析方法内部名称 */
    public static $name = 'C';

    /* Method settings 方法设置参数定义 */
    public static $settings = array();

    /* Diagram config 图表配置项 */
    public static $config = array();

    /* Callback for basic statistic method 基本量统计计算回调函数 */
    public static function func($dataframe, $settings)
    {
        global $dasLang;
        global $lang;

        $result = array();

        $multiple = C::formatMultiple($settings['multiple']);
        $ref      = C::formatReference($settings['ref']);
        $type     = 'number';
        $vars     = $settings['var'];
        $tests    = isset($settings['tests']) ? $settings['tests'] : '';

        $sliceDF = $dataframe->sliceDataframe($dataframe, $vars, $type);

        $check = new checkData();
        $check->setDataList($sliceDF->colsData($vars), $sliceDF->colsName($vars), self::$settings['var']['validate']);

        $checkRes = $check->check();
        if(is_string($checkRes)) return ValidateData::result($checkRes);

        $c = new C($sliceDF);

        foreach($vars as $var)
        {
            $points = $sliceDF->col($var)->trimdata;

            $μ = $c->cBar($var, $type);
            $σ = $c->sigma($var, $type);

            $limit = $c->limit($μ, $σ, $multiple);
            $title = $dataframe->getChartTitle($var, $lang->perfanalysis->methods->control['C']);

            /* Std ULCLs */
            $stdLimit = $c->limit($μ, $σ, array(1,2,3));
            $stdULCLs = $stdLimit->SLs;
            $stdULCLs['C'] = $stdLimit->CL;

            $param = new stdclass();

            $param->lang         = $dasLang->C;
            $param->points       = $points;
            $param->name         = $dataframe->columns[$var];
            $param->lineBegin    = 0;
            $param->lineEnd      = count($param->points) - 1;
            $param->CL           = $μ;
            $param->CLName       = $dasLang->C->cl;
            $param->ULCLs        = $limit->SLs;
            $param->title        = $title;
            $param->xTitle       = $dasLang->C->sample;
            $param->yTitle       = $dasLang->C->samplePerUnit;
            $param->testsResults = SPC::checkTestsRules($points, $stdULCLs, $tests);
            $param->ref          = $ref;

            $textResult = $dataframe->getTextResult($dataframe->getChartTitle($var, $lang->perfanalysis->methods->control['C']));
            $textResult->name     = 'var' . $var;
            $textResult->children = 1;

            $result[] = $textResult;
            $result[] = SPC::buildChartResult($param);

            if(!empty($param->testsResults))
            {
                $result[] = SPC::buildTestsResult($param->testsResults, $dasLang->C->samplePerUnit, array($var));
            }
        }

        return $result;
    }

    /**
     * Get settings.
     *
     * @param object $lang
     * @access public
     * @return object
     */
    public static function getSettings()
    {
        global $dasLang;
        $lang = $dasLang->C;

        /* Basic settings */
        self::$settings['var']      = array('name' => 'var',      'label' => $lang->var, 'required' => true);
        self::$settings['multiple'] = array('name' => 'multiple', 'label' => $lang->multiple);
        self::$settings['ref']      = array('name' => 'ref',      'label' => $lang->ref);
        self::$settings['tests']    = array('name' => 'tests',    'label' => $dasLang->cu->tests);

        /* Type settings */
        self::$settings['var']      += array('type' => 'list', 'listType' => 'column', 'columnType' => 'number');
        self::$settings['multiple'] += array('type' => 'list', 'listType' => 'number');
        self::$settings['ref']      += array('type' => 'list', 'listType' => 'number');
        self::$settings['tests']    += array('type' => 'list', 'listType' => 'enum', 'enumOptions' => $dasLang->cu->testsRules, 'ui' => 'checkbox-list', 'defaultValue' => array('1'));

        /* Limit settings */
        self::$settings['multiple'] += array('pattern' => "/^[\d]+(\.[\d]+)?$/", 'error' => $lang->errorMultiple);
        self::$settings['ref']      += array('pattern' => "/^[\d]+(\.[\d]+)?$/", 'error' => $lang->errorRef);

        /* Col grid settings */

        /* More settings */
        self::$settings['multiple'] += array('paramType' => 'more');
        self::$settings['ref']      += array('paramType' => 'more');
        self::$settings['tests']    += array('paramType' => 'more');

        /* Data validate */
        self::$settings['var'] += array('validate' => array('continuous', 'number', 'int', 'nonnegative', 'notCommon'));

        return self::$settings;
    }

    /**
     * Get config.
     *
     * @access public
     * @return object
     */
    public static function getConfig()
    {
        global $dasLang;
        $lang = $dasLang->config;
        self::$config['grid']   = $lang->gridConfig;
        self::$config['legend'] = $lang->legendConfig;

        return self::$config;
    }
}
