<?php
$lang = new stdclass();

$lang->grid  = '网格线';
$lang->xLine = 'x 轴';
$lang->yLine = 'y 轴';
$lang->column    = '行';
$lang->xAxisName = 'X轴标题';
$lang->yAxisName = 'Y轴标题';
$lang->highlight = '高亮显示';

$lang->config = new stdclass();

$lang->config->grid              = '网格线';
$lang->config->gridEnum          = array();
$lang->config->gridEnum['xaxis'] = 'X 轴';
$lang->config->gridEnum['yaxis'] = 'Y 轴';
$lang->config->gridConfig        = array('name' => 'grid', 'label' => $lang->config->grid, 'type' => 'checkbox', 'enumOptions' => $lang->config->gridEnum, 'defaultValue' => array());

$lang->config->label              = '显示数据';
$lang->config->labelEnum          = array();
$lang->config->labelEnum['xaxis'] = 'X 轴';
$lang->config->labelEnum['yaxis'] = 'Y 轴';
$lang->config->labelConfig        = array('name' => 'label', 'label' => $lang->config->label, 'type' => 'checkbox', 'enumOptions' => $lang->config->labelEnum, 'defaultValue' => '');

$lang->config->legend              = '图例';
$lang->config->legendEnum          = array();
$lang->config->legendEnum['true']  = '显示';
$lang->config->legendEnum['false'] = '隐藏';
$lang->config->legendConfig        = array('name' => 'legend', 'label' => $lang->config->legend, 'type' => 'radio', 'enumOptions' => $lang->config->legendEnum, 'defaultValue' => 'true');

$lang->config->title              = '坐标轴标题';
$lang->config->titleEnum          = array();
$lang->config->titleEnum['xaxis'] = 'X 轴';
$lang->config->titleEnum['yaxis'] = 'Y 轴';
$lang->config->titleConfig        = array('name' => 'title', 'label' => $lang->config->title, 'type' => 'checkbox', 'enumOptions' => $lang->config->titleEnum, 'defaultValue' => array('xaxis', 'yaxis'));

$lang->config->orientation          = '显示方向';
$lang->config->orientationEnum      = array();
$lang->config->orientationEnum['v'] = '垂直显示';
$lang->config->orientationEnum['h'] = '水平显示';

$lang->common = new stdclass();
$lang->common->columnNotAllNumber = '所选列“%s”包含非数值';
$lang->common->columnNoNumber     = '所选列“%s”没有包含任何数值';
$lang->common->errorColEqual      = '请选择有效列，列的行数与变量列的行数相等且行数≥2。';
$lang->common->errorRowEqual      = '请选择有效列，列中需至少相邻2行数据相同。';
$lang->common->errorLine          = '不能选择空列:%s';
$lang->common->allSame            = '分组中所有值相同';
$lang->common->notSameLine        = '输入的列长度不一致';
$lang->common->haveEmptyLine      = '输入的列存在空值:%s';
$lang->common->haveStringLine     = '输入的列存在非数值(字符串):%s';
$lang->common->continuousError    = '列数据不能包含空值';
$lang->common->notNumberError     = '列数据需为数值';
$lang->common->notPositiveError   = '列数据需全为正数';
$lang->common->notIntegerError    = '列数据需全为整数';
$lang->common->notCommonError     = '列数据不能为常量列';
$lang->common->rowNotEqualError   = '列数据列长需相等';
$lang->common->rowLengthError     = '列数据列长需 >= %s';
$lang->common->groupLengthError   = '列数据分类后每个类别组的项数需 >= %s';
$lang->common->group2Error        = '列数据分类后类别组数需为2';

$lang->common->notEmptyError     = '[%s]列不能为空。';
$lang->common->continuousError   = '[%s]列不能包含空值, 异常值为第%s行。';
$lang->common->numberError       = '[%s]列需全部为数值, 异常值为第%s行。';
$lang->common->notCommonError    = '[%s]列不能为常量列。';
$lang->common->uniqueError       = '[%s]列不能包含重复值。';
$lang->common->intError          = '[%s]列需全部为整数，异常值为第%s行。';
$lang->common->positiveError     = '[%s]列需全部大于0，异常值为第%s行。';
$lang->common->nonnegativeError  = '[%s]列需全部为非负数，异常值为第%s行。';
$lang->common->rowEqualError     = '[%s]列需列长相等。';
$lang->common->columnUniqueError = '[%s]列需类别数%s。';
$lang->common->unionUniqueError  = '[%s]列联合后需类别数%s。';
$lang->common->numberCountError  = '[%s]列需数列个数%s。';
$lang->common->invertibleError   = '数据错误，构成了不可逆矩阵。';

$lang->fourInOne = new stdclass();

$lang->fourInOne->data            = "数据";
$lang->fourInOne->residual        = "残差";
$lang->fourInOne->frequency       = "频率";
$lang->fourInOne->fit             = "拟合";
$lang->fourInOne->fitValue        = "拟合值";
$lang->fourInOne->response        = "响应为%s";
$lang->fourInOne->withFit         = "残差与拟合值图";
$lang->fourInOne->histogram       = "残差频率的直方图";
$lang->fourInOne->percent         = "百分比";
$lang->fourInOne->withOrder       = "残差与观测值顺序图";
$lang->fourInOne->normal          = "残差的正态概率图";
$lang->fourInOne->observeOrder    = "观测值顺序";

$lang->fourInOne->errorSD = "由于均方误差 = 0 或误差自由度 = 0，不能绘制指定残差类型的图形";

$lang->simulate = new stdclass();
$lang->simulate->cols = array_fill(1, 20, 'C');

$lang->simulate->standardDeviation = '标准差';
$lang->simulate->mean              = '均值';
$lang->simulate->count             = '行数';
$lang->simulate->col               = '填充到列';

$lang->simulate->errorSD    = '标准差只能输入正数';
$lang->simulate->errorMean  = '均值只允许输入数字';
$lang->simulate->errorCount = '只能生成1到1000行数据';

$methods = array('analysis', 'control', 'graphic', 'hypothesis', 'statistic');

foreach($methods as $method)
{
    $methodDir = LIB_ROOT . "/das/lang/methods/$method/zh-cn";
    $files = glob($methodDir . '/*.php');
    foreach ($files as $file) include $file;
}

$simulateDir = LIB_ROOT . "/das/lang/simulate/zh-cn";
$files = glob($simulateDir . '/*.php');
foreach ($files as $file) include $file;
