<?php
/**
 * The edit view file of perfproject module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Zemei Wang <wangzemei@easycorp.ltd>
 * @package     perfproject
 * @link        https://www.zentao.net
 */
namespace zin;

$fields = defineFieldList('perfproject.edit');

$fields->field('name')
    ->label($lang->perfproject->name)
    ->control('input')
    ->value($project->name)
    ->required(true)
    ->width('full');

$fields->field('desc')
    ->label($lang->perfproject->desc)
    ->control('textarea', array('autoHeight' => true))
    ->value($project->desc)
    ->width('full');

formGridPanel
(
    set::title($title),
    set::layout('horz'),
    set::loadUrl(inlink('edit', "projectID=$project->id&model={model}")),
    set::defaultMode('full'),
    set::modeSwitcher(false),
    set::size('sm'),
    set::formClass('pt-4'),
    set::submitBtnText($lang->save),
    set::fields($fields)
);
