<?php
/**
 * The create view file of perfproject module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Zemei Wang <wangzemei@easycorp.ltd>
 * @package     perfproject
 * @link        https://www.zentao.net
 */
namespace zin;

$products      = $this->loadModel('product')->getPairs('nodeleted', 0, '', 0);
$executions    = $this->loadModel('execution')->getPairs();
$tasks         = $this->loadModel('task')->getAllParisForPerf();
$hasStory      = hasPriv('product', 'browse');
$hasBug        = hasPriv('bug', 'browse');
$hasExecution  = hasPriv('project', 'execution');
$hasTask       = hasPriv('execution', 'task');
$hasExecutions = empty($products) && !empty($executions);
$hasTasks      = empty($products) && empty($executions) && !empty($tasks);
$noData        = empty($products) && empty($executions) && empty($tasks);
$noStoryBug    = !$hasStory && !$hasBug;
$showExecution = !empty($executions) && $noStoryBug && $hasExecution;
$noOthers      = !$hasStory && !$hasBug && !$hasExecution;
$showTask      = !empty($tasks) && $hasTask && $noOthers;
$showCreate    = $noOthers && !$hasTask;

$productStoryLink = '';
if(!empty($products) && $hasStory)             $productStoryLink = createLink('product', 'browse', "productID=0&branch=all&browseType=&param=0&storyType=story&orderBy=&recTotal=0&recPerPage=20&pageID=1&projectID=0&from=perf&blockID=$analysisID");
if(!empty($products) && !$hasStory && $hasBug) $productStoryLink = createLink('bug', 'browse', "productID=0&branch=&browseType=&param=0&orderBy=&recTotal=0&recPerPage=20&pageID=1&from=perf&blockID=$analysisID");
if($hasExecutions || $showExecution)           $productStoryLink = createLink('project', 'execution', "status=undone&projectID=0&orderBy=order_asc&productID=0&recTotal=1&recPerPage=100&pageID=1&queryID=0&from=perf&blockID=$analysisID");
if($hasTasks || $showTask)                     $productStoryLink = createLink('execution', 'task', "execution=0&status=unclosed&param=0&orderBy=&recTotal=0&recPerPage=100&pageID=1&from=perf&blockID=$analysisID");
if($noData || $showCreate)                     $productStoryLink = createLink('perfproject', 'create', "analysisID=$analysisID&type=upload");

$perfprojectLink  = createLink('perfproject', 'create', "analysisID=$analysisID&type={type}");

$hasStory     = hasPriv('product', 'browse');
$hasBug       = hasPriv('bug', 'browse');
$hasExecution = hasPriv('project', 'execution');
$hasTask      = hasPriv('execution', 'task');
if(!empty($analysisID)) unset($lang->perfproject->dataTypeList['empty']);
if(!$hasStory && !$hasBug && !$hasExecution && !$hasTask) unset($lang->perfproject->dataTypeList['select']);

$dataTypeList = array();
foreach($lang->perfproject->dataTypeList as $key => $value) $dataTypeList[] = array('text' => $value, 'value' => $key, 'disabled' => ($key == 'select' && $noData) ? true : false);

$excels = array();
if($type == 'upload')
{
    foreach($excelData as $item)
    {
        $excels[] = div
        (
            setClass('flex items-center gap-2 border p-3 relative cursor-pointer rounded history-item'),
            setData(array('sourceID' => $item->id)),
            setStyle(array('flex' => '0 0 calc(25% - 16px)', 'max-width' => 'calc(25% - 16px)')),
            icon(setStyle(array('font-size' => '2.5rem')), 'file-excel'),
            div
            (
                setClass('col gap-1 overflow-hidden'),
                div(setClass('text-ellipsis'), $item->name),
                div(setClass('text-gray'), $item->filesize)
            ),
            radio
            (
                set::title($item->name),
                setID('source' . $item->id),
                set::type('radio'),
                set::name('source'),
                set::value($item->id),
                on::change()->call('changeSource')
            )
        );
    }
}

formPanel(setClass('create-form'), setData(array('notesLang' => $lang->perfproject->notes, 'fileTypeLang' => $lang->perfproject->tips->fileType)), set::title(!empty($analysisID) ? $lang->perfanalysis->addData : $this->lang->perfproject->createTitle), set::submitBtnText(!empty($analysisID) ? $lang->save : $lang->perfproject->create), formGroup
(
    set::label($lang->perfproject->selectData),
    set::required(true),
    radioList
    (
        set::inline(true),
        set::name('sourcetype'),
        set::items($dataTypeList),
        set::value($type),
        on::change('[name="sourcetype"]')->do("
                const value = $(this).val();
                if(value == 'select')
                {
                    loadModal('$productStoryLink')
                }
                else
                {
                    loadModal('$perfprojectLink'.replace('{type}', value))
                }
            ")
    )
), $type == 'empty' ? div(setStyle(array('padding-left' => ' var(--form-horz-label-width)')), setClass('flex items-center gap-2'), icon(setClass('text-warning'), 'help'), span(setClass('text-gray'), $lang->perfproject->notes->emptyTable), formHidden('table', 0)) : array
(
    formGroup
    (
        setStyle(array('align-items' => 'center')),
        set::label($lang->perfproject->selectFile),
        set::width('1/2'),
        set::required(true),
        fileSelector
        (
            set::maxFileCount(1),
            set::accept('.xlsx'),
            set::mode('button'),
            set::name('file'),
            set::tip(sprintf($lang->perfproject->notes->file, strtoupper(ini_get('upload_max_filesize')))),
            set::onSelect(jsRaw('window.onSelectFile')),
            set::onAdd(jsRaw('window.onAddFile')),
            set::onRemove(jsRaw('window.onRemoveFile'))
        )
    ),
    formGroup(setClass('select-table hidden'), set::label($lang->perfproject->table), set::width('1/2'), set::required(true), picker(set::name('table'), set::items(array()), set::required(true))),
    empty($excels) ? null : div
    (
        setStyle(array('padding-left' => ' var(--form-horz-label-width)')),
        setClass('col gap-3'),
        div(
            $lang->perfproject->history,
            btn(set::size('sm'), set::icon('help'), setClass('ghost form-label-hint text-gray-300'), toggle::tooltip(array('title' => $lang->perfproject->notes->history, 'className' => 'text-gray border border-gray-300', 'type' => 'white', 'placement' => 'right')))
        ),
        div(setClass('flex flex-wrap gap-4 history-data'), $excels)
    )
), formHidden('acl', 'private'));
