window.customPlotlyIcon =
{
    plus: {
        width: 1000,
        height: 1000,
        path: 'M860.445 334.223h-298.666v298.666c0 29.866-19.911 49.779-49.779 49.779s-49.779-19.911-49.779-49.779v-298.666h-298.666c-29.866 0-49.779-19.911-49.779-49.779s19.911-49.779 49.779-49.779h298.666v-298.666c0-29.866 19.911-49.779 49.779-49.779s49.779 19.911 49.779 49.779v298.666h298.666c29.866 0 49.779 19.911 49.779 49.779s-19.911 49.779-49.779 49.779z',
        transform: 'matrix(1 0 0 1 0 300)'
    },
    minus: {
        width: 1000,
        height: 1000,
        path: 'M860.443 334.222h-696.885c-29.869 0-49.778-19.913-49.778-49.778s19.913-49.778 49.778-49.778h696.885c29.869 0 49.778 19.913 49.778 49.778s-19.913 49.778-49.778 49.778z',
        transform: 'matrix(1 0 0 1 0 300)'
    },
    home: {
        width: 1000,
        height: 1000,
        path: 'M850.469 611.002c-14.285 14.283-37.442 14.283-51.719 0l-129.553-129.551v79.782c0 20.198-16.374 36.571-36.571 36.571s-36.571-16.374-36.571-36.571v-170.667c0-20.198 16.374-36.571 36.571-36.571h170.666c20.195 0 36.571 16.374 36.571 36.571s-16.377 36.571-36.571 36.571h-84.969l132.146 132.145c14.277 14.282 14.277 37.437 0 51.719zM193.569-20.678l132.144 132.146h-84.969c-20.198 0-36.571 16.373-36.571 36.571s16.374 36.571 36.571 36.571h170.667c20.198 0 36.571-16.374 36.571-36.571v-170.663c0-20.202-16.374-36.571-36.571-36.571s-36.571 16.369-36.571 36.571v79.777l-129.551-129.551c-14.282-14.277-37.437-14.277-51.719 0-14.283 14.285-14.283 37.442 0 51.719zM266.911 452.16l51.72 51.72 438.859-438.856-51.722-51.719-438.857 438.856z',
        transform: 'matrix(1 0 0 1 0 300)'
    },
    move: {
        width: 1000,
        height: 1000,
        path: 'M497.218 761.257l-91.67-114.677c-5.712-7.15-3.727-17.005 4.436-22.010 3.035-1.86 6.649-2.857 10.35-2.857h55.095v-292.571h-292.571v55.095c0 9.969-7.076 18.048-15.804 18.048-3.242 0-6.407-1.137-9.063-3.262l-114.677-91.666c-7.15-5.716-8.889-16.969-3.884-25.136 1.058-1.726 2.373-3.226 3.884-4.432l114.677-91.67c7.15-5.712 17.005-3.727 22.010 4.436 1.86 3.035 2.857 6.649 2.857 10.35v55.095h292.571v-292.571h-55.095c-9.969 0-18.048-7.077-18.048-15.803 0-3.244 1.137-6.407 3.262-9.066l91.666-114.673c5.716-7.153 16.969-8.891 25.136-3.884 1.726 1.057 3.226 2.37 4.432 3.884l91.67 114.673c5.712 7.153 3.727 17.006-4.436 22.012-3.035 1.858-6.649 2.856-10.35 2.856h-55.095v292.571h292.571v-55.095c0-9.969 7.077-18.048 15.803-18.048 3.244 0 6.407 1.137 9.066 3.262l114.673 91.666c7.153 5.716 8.891 16.969 3.884 25.136-1.057 1.726-2.37 3.226-3.884 4.432l-114.673 91.67c-7.153 5.712-17.006 3.727-22.012-4.436-1.858-3.035-2.856-6.649-2.856-10.35v-55.095h-292.571v292.571h55.095c9.969 0 18.048 7.076 18.048 15.804 0 3.242-1.137 6.407-3.262 9.063l-91.666 114.677c-5.716 7.15-16.969 8.889-25.136 3.884-1.726-1.058-3.226-2.373-4.432-3.884z',
        transform: 'matrix(0.9 0 0 0.9 0 300)'
    }
};


var removeBtns = ['zoom2d', 'select2d', 'lasso2d', 'toImage', 'autoScale2d'];
window.createPlot = function(id, data, layout, config, chartId, methodID)
{
    waitElement(id, function()
    {
        requestAnimationFrame(function(){Plotly.newPlot(id, data, layout, {modeBarButtonsToRemove: removeBtns});});
    });
}

window.createRange = function(id, config, data, layout)
{
    waitElement(id + " .plot-container", function()
    {
        config.chartData = data;

        var rangeContent = jQuery('#' + id + '-range');
        config.onstatechange = function(value)
        {
            var lower = $('#' + id + '-range').find('input.lower');
            var upper = $('#' + id + '-range').find('input.upper');

            clearError(lower, upper);
            var [low, high] = value.split(',');
            low = Number(low);
            high = Number(high);

            var from = this.options.from;
            var to   = this.options.to;

            var p = [];
            var color = this.options.chartData[0].x.map((value, index) => {
                value = Number(value);
                if (value > low && value < high || (value <= low && from == low) || (value >= high && to == high))
                {
                    p.push(Number(this.options.chartData[0].y[index]));
                    return this.options.selectColor;
                }
                return this.options.unselectColor;
            });

            if(p.length == 0 || (this.options.pType == 'range' && from == low)) p.push(0);

            if(this.options.pType == 'sum') p = p.reduce(function(s,v){return s+v;});
            if(this.options.pType == 'range') p = Math.max.apply(null, p) - Math.min.apply(null, p);

            var pInverse = Math.abs(1 - p);

            lower.val(low);
            upper.val(high);
            rangeContent.find('input.p-value').val(p.toFixed(2));
            rangeContent.find('input.p-value-inverse').val(pInverse.toFixed(2));

            Plotly.restyle(id, {'marker': {'color': color}});
        }
        rangeContent.find('.slider-input').jRange(config);

        $('[data-toggle="tooltip"]').tooltip(
        {
            tipClass: 'tooltip-danger',
            trigger: 'hover focus'
        });
    });
}

window.clearError = function(lower, upper)
{
    lower.removeClass('has-error').tooltip('destroy');
    upper.removeClass('has-error').tooltip('destroy');
}

window.rangeChange = function(elem, value)
{
    var rangeContent = jQuery(elem).parents('div.slider-content');
    var lower = $(elem).closest('.form-row').find('input.lower');
    var upper = $(elem).closest('.form-row').find('input.upper');

    clearError(lower, upper);

    var lowValue  = lower.val();
    var highValue = upper.val();

    if(lowValue.length == 0)
    {
        hasError = true;
        rangeTooltip(lower, window.rangeLang.lowerEmpty);
    }

    if(highValue.length == 0)
    {
        hasError = true;
        rangeTooltip(upper, window.rangeLang.upperEmpty);
    }

    if(hasError) return;

    if(isNaN(lowValue))
    {
        hasError = true;
        rangeTooltip(lower, window.rangeLang.numberError);
    }

    if(isNaN(highValue))
    {
        hasError = true;
        rangeTooltip(upper, window.rangeLang.numberError);
    }

    if(hasError) return;

    lowValue = Number(lowValue);
    highValue = Number(highValue);

    var lowLimit = Number(lower.attr('min'));
    var highLimit = Number(upper.attr('max'));

    var hasError = false;

    if(lowValue < lowLimit)
    {
        hasError = true;
        rangeTooltip(lower, window.rangeLang.lowerError.replace('%s', lowLimit));
    }

    if(highValue > highLimit)
    {
        hasError = true;
        rangeTooltip(upper, window.rangeLang.upperError.replace('%s', highLimit));
    }

    if(hasError) return;

    if(lowValue > highValue)
    {
        hasError = true;
        var errorInfo = $(elem).hasClass('lower') ? window.rangeLang.lowerLtUpper : window.rangeLang.upperGtLower;
        rangeTooltip($(elem), errorInfo);
    }

    if(hasError) return;

    rangeContent.find('.slider-input').jRange('setValue', lowValue + ',' + highValue);
}

window.rangeTooltip = function(elem, title)
{
    elem.addClass('has-error');
    elem.tooltip({tipClass: 'tooltip-danger', title: title, placement: 'top'});
}

function waitElement(id, callback)
{
    var count = 0;
    var timer = setInterval(function()
    {
        count += 1;
        if($('#' + id).length > 0 || count >= 300)
        {
            clearInterval(timer);
            callback();
        }
    }, 100);
}

function setWhite(acl)
{
    acl != 'open' ? $('#whitelistBox').removeClass('hidden') : $('#whitelistBox').addClass('hidden');
    acl != 'open' ? $('#manageprivForm').addClass('mh-200') : $('#manageprivForm').removeClass('mh-200');
}

function calcTextWidth(text, maxWidth)
{
    if(!text) return 6;
    var width = 0;
    text = String(text);
    for(var i = 0; i < text.length; ++i)
    {
        width += text.charCodeAt(i) > 255 ? 13 : 7;
        if(maxWidth && width > maxWidth) return maxWidth;
    }
    return Math.ceil(width);
}

function upCells(dtable)
{
    var cells = dtable.$.getSelectedCells();
    if(!cells.length) return;
    const {row: firstRowIndex, col: firstColIndex} = cells[0];
    const {row: lastRowIndex, col: lastColIndex}   = cells[cells.length - 1];
    const rowsCount = dtable.$.layout.rows.length;
    const datasource = [];

    for(let i = 0; i< rowsCount; i++)
    {
        var rowValues = [];
        for(let j = firstColIndex; j <= lastColIndex; j++)
        {
            const col = dtable.$.layout.colsList[j];
            const value = dtable.$.getCellDraftValue(i, col);
            rowValues.push(value === undefined ? '' : value);
        }

        datasource.push(rowValues.join('\t'));
    }

    var data = datasource.filter((col, index) => index >= (lastRowIndex + 1)).concat('').join('\n');
    dtable.$.pasteCells(cells[0], {data, select: false});
};

function deleteRowByCell(dtable)
{
   var cells = dtable.$.getSelectedCells();
   if(!cells.length) return;
   var row = dtable.$.getRowInfoByIndex(cells[0].row);
   dtable.$.deleteRows(row);
};

function deleteColByCell(dtable)
{
    var cells = dtable.$.getSelectedCells();
    if(!cells.length) return;
    var col = dtable.$.layout.colsList[cells[0].col];
    dtable.$.deleteCols(col);
};

/** Handle dataframe change and push changes to server */
function postDataframe(changes, skipApplyChange)
{
    var data = {};
    var colNames = {};
    $.each(changes, function(rowID, rowData)
    {
        if(rowID === 'HEADER')
        {
            return $.each(rowData, function(colName, colTitle)
            {
                colNames['col' + (colName.replace('C', '') - 1)] = colTitle;
            });
        }
        $.each(rowData, function(colName, value)
        {
            if(value === undefined || value === null) value = '';

            var colIndex = colName.replace('C', '');
            var colValues = data[colIndex];
            if(!colValues)
            {
                colValues = {};
                data[colIndex] = colValues;
            }
            colValues[rowID] = value;
        });
    });
    changes = $.extend(true, {}, changes);
    $.post($.createLink('analysis', 'ajaxUpdateDataframe', 'analysisID=' + analysisID), {data: JSON.stringify(data), colNames: JSON.stringify(colNames)}, function(data)
    {
        if(!skipApplyChange && data && data.result === 'success')
        {
            var dtable = $('#dataframe' + analysisID).data('zui.dtable').$;

            dtable.applyDraft(changes);
            dtable.appendRows(1, {autoScroll: false, skipUpdate: false, select: false});
        }
    }, 'json');
}

/** Handle dataframe change and push changes to server */
function handleDataframeChange(_changes, allChanges)
{
    postDataframe.call(this, allChanges);
}

/** Handle dataframe history applied */
function handleHistoryApplied(changes)
{
    postDataframe.call(this, changes, true);
}

$(document).ready(function()
{
  $(document).on('click', 'a.iframe', function(e)
  {
    $('#triggerModal .modal-header').removeClass('min-bar');
    if($(e.target).hasClass('mini-header'))
    {
      $('#triggerModal .modal-header').addClass('min-bar');
    }
  });
});

window.onRenderCell = function(result, info)
{
    if(info.col.name === 'name')
    {
        const url = $.createLink('perfproject', 'firstanalysis', 'project=' + info.row.data.id);
        result[0] = {html: `<a href="${url}" title="${info.row.data.name}">${info.row.data.name}</a>`, className: 'text-ellipsis'};
    }
    if(info.col.name === 'desc') result[0] = {html: `<div class="text-ellipsis" title="${info.row.data.desc}">${info.row.data.desc}</div>`, className: 'text-ellipsis'};

    return result;
}
