<?php
namespace zin;

$requestHeader = array(
    array('title' => $lang->montecarlo->request,     'width' => '18'),
    array('title' => $lang->montecarlo->forecastVar, 'width' => '24'),
    array('title' => $lang->montecarlo->statistic,   'width' => '24'),
    array('title' => $lang->montecarlo->condition,   'width' => '24'),
    array('title' => $lang->montecarlo->value,       'width' => '24')
);

$requestForm = $config->montecarlo->requestForm->form;

$requestForm['reqText']['width'] = $requestHeader[0]['width'];
$requestForm['reqText']['values'] = array($lang->montecarlo->let, $lang->montecarlo->andSingle);

$requestForm['reqVar']['width'] = $requestHeader[1]['width'];
$requestForm['reqVar']['items'] = $forecastList;

$requestForm['reqStat']['width'] = $requestHeader[2]['width'];
$requestForm['reqStat']['items'] = $lang->montecarlo->statisticList;

$requestForm['reqCondition']['width'] = $requestHeader[3]['width'];
$requestForm['reqCondition']['items'] = $lang->montecarlo->conditionList;

$requestForm['reqValue']['width'] = $requestHeader[4]['width'];
$requestForm['reqValue']['errorTip'] = sprintf($lang->montecarlo->validMsg['required'], $lang->montecarlo->value);

$requestRow = array($requestForm['reqText'], $requestForm['reqVar'], $requestForm['reqStat'], $requestForm['reqCondition'], $requestForm['reqValue']);

$fnGenerateRequest = function($data) use ($lang, $requestHeader, $requestRow, $fnGenerateFormHeader, $fnGenerateFormRow)
{
    $rows = array();
    if(!empty($data)) foreach($data as $index => $value) $rows[] = $fnGenerateFormRow('request', $index, $requestRow, $value, true, 'removeRequest($this)');

    return array
    (
        $fnGenerateFormHeader($requestHeader),
        $rows,
        formGroup
        (
            btn
            (
                set::type('default'),
                set::icon('plus'),
                $lang->montecarlo->addRequest,
                on::click()->do('addRequest()')
            )
        ),
        divider()
    );
};
