<?php
$config->montecarlo = new stdclass();

$config->montecarlo->conditionList = array();
$config->montecarlo->conditionList['>']  = '>';
$config->montecarlo->conditionList['<']  = '<';
$config->montecarlo->conditionList['>='] = '>=';
$config->montecarlo->conditionList['<='] = '<=';
$config->montecarlo->conditionList['=']  = '=';
$config->montecarlo->conditionList['!='] = '!=';

$config->montecarlo->dists = array();
$config->montecarlo->dists['normal']             = array();
$config->montecarlo->dists['normal']['mu']       = array('type' => 'number', 'min' => -99999,     'max' => 99999, 'required' => true);
$config->montecarlo->dists['normal']['sigma']    = array('type' => 'number', 'min' => 0.00001,    'max' => 99999, 'required' => true);
$config->montecarlo->dists['normal']['lowLimit'] = array('type' => 'number', 'min' => -99999,     'max' => 'upLimit', 'noEqual' => true, 'required' => false);
$config->montecarlo->dists['normal']['upLimit']  = array('type' => 'number', 'min' => 'lowLimit', 'max' => 99999, 'noEqual' => true, 'required' => false);
$config->montecarlo->dists['normal']['col']      = 6;

$config->montecarlo->dists['triangular']          = array();
$config->montecarlo->dists['triangular']['left']  = array('type' => 'number', 'min' => -99999, 'max' => 'right', 'noEqual' => true, 'required' => true);
$config->montecarlo->dists['triangular']['mode']  = array('type' => 'number', 'min' => 'left', 'max' => 'right', 'required' => true);
$config->montecarlo->dists['triangular']['right'] = array('type' => 'number', 'min' => 'left', 'max' => 99999, 'noEqual' => true, 'required' => true);
$config->montecarlo->dists['triangular']['col']   = 4;

$config->montecarlo->hypoForm = new stdclass();
$config->montecarlo->hypoForm->id     = 'hypoTable';
$config->montecarlo->hypoForm->field  = 'hypo';
$config->montecarlo->hypoForm->group  = true;
$config->montecarlo->hypoForm->form   = array();
$config->montecarlo->hypoForm->form['varName']      = array('name' => 'varName',      'control' => 'input',  'required' => false);
$config->montecarlo->hypoForm->form['type']         = array('name' => 'type',         'control' => 'picker', 'required' => true);
$config->montecarlo->hypoForm->form['distribution'] = array('name' => 'distribution', 'control' => 'input',  'required' => true);
$config->montecarlo->hypoForm->form['addDist']      = array('name' => 'addDist',      'control' => 'btn',    'required' => false);

$config->montecarlo->forecastForm = new stdclass();
$config->montecarlo->forecastForm->id     = 'forecastTable';
$config->montecarlo->forecastForm->field  = 'forecast';
$config->montecarlo->forecastForm->group  = true;
$config->montecarlo->forecastForm->form   = array();
$config->montecarlo->forecastForm->form['exportY']       = array('name' => 'exportY',       'control' => 'radio',    'required' => false);
$config->montecarlo->forecastForm->form['forecastName']  = array('name' => 'forecastName',  'control' => 'input',    'required' => false);
$config->montecarlo->forecastForm->form['forecastYname'] = array('name' => 'forecastYname', 'control' => 'input',    'required' => false);
$config->montecarlo->forecastForm->form['formula']       = array('name' => 'formula',       'control' => 'textarea', 'required' => true);
$config->montecarlo->forecastForm->form['condition']     = array('name' => 'condition',     'control' => 'btn',      'required' => false);

$config->montecarlo->decisionForm = new stdclass();
$config->montecarlo->decisionForm->id          = 'decisionTable';
$config->montecarlo->decisionForm->field       = 'decision';
$config->montecarlo->decisionForm->group       = true;
$config->montecarlo->decisionForm->conditions  = array('decision' => 'true');
$config->montecarlo->decisionForm->form        = array();
$config->montecarlo->decisionForm->form['decisionName']  = array('name' => 'decisionName',  'control' => 'input', 'required' => false);
$config->montecarlo->decisionForm->form['decisionXname'] = array('name' => 'decisionXname', 'control' => 'input', 'required' => false);
$config->montecarlo->decisionForm->form['decisionVar']   = array('name' => 'decisionVar',   'control' => 'input', 'required' => true);

$config->montecarlo->targetForm = new stdclass();
$config->montecarlo->targetForm->id     = 'targetTable';
$config->montecarlo->targetForm->field  = 'target';
$config->montecarlo->targetForm->group  = true;
$config->montecarlo->targetForm->form   = array();
$config->montecarlo->targetForm->form['target']      = array('name' => 'target',      'control' => 'picker', 'required' => true);
$config->montecarlo->targetForm->form['targetYname'] = array('name' => 'targetYname', 'control' => 'input',  'required' => false);
$config->montecarlo->targetForm->form['statistic']   = array('name' => 'statistic',   'control' => 'picker', 'required' => true);

$config->montecarlo->requestForm = new stdclass();
$config->montecarlo->requestForm->id     = 'requestTable';
$config->montecarlo->requestForm->field  = 'request';
$config->montecarlo->requestForm->group  = true;
$config->montecarlo->requestForm->form   = array();
$config->montecarlo->requestForm->form['reqText']       = array('name' => 'reqText',      'control' => 'label',  'required' => false);
$config->montecarlo->requestForm->form['reqVar']        = array('name' => 'reqVar',       'control' => 'picker', 'required' => true);
$config->montecarlo->requestForm->form['reqStat']       = array('name' => 'reqStat',      'control' => 'picker', 'required' => true);
$config->montecarlo->requestForm->form['reqCondition']  = array('name' => 'reqCondition', 'control' => 'picker', 'required' => true);
$config->montecarlo->requestForm->form['reqValue']      = array('name' => 'reqValue',     'control' => 'input',  'required' => true);

$config->montecarlo->decisionRadio = new stdclass();
$config->montecarlo->decisionRadio->id       = 'decision';
$config->montecarlo->decisionRadio->field    = 'decisionStus';
$config->montecarlo->decisionRadio->group    = false;
$config->montecarlo->decisionRadio->type     = 'radio';

$config->montecarlo->runNumber = new stdclass();
$config->montecarlo->runNumber->id       = 'runNumber';
$config->montecarlo->runNumber->field    = 'runNumber';
$config->montecarlo->runNumber->group    = false;
$config->montecarlo->runNumber->type     = 'input';
$config->montecarlo->runNumber->required = true;
$config->montecarlo->runNumber->rule     = 'integer';
$config->montecarlo->runNumber->min      = 10;
$config->montecarlo->runNumber->max      = 1000000;

$config->montecarlo->formConfig   = array();
$config->montecarlo->formConfig[] = $config->montecarlo->hypoForm;
$config->montecarlo->formConfig[] = $config->montecarlo->forecastForm;
$config->montecarlo->formConfig[] = $config->montecarlo->decisionForm;
$config->montecarlo->formConfig[] = $config->montecarlo->targetForm;
$config->montecarlo->formConfig[] = $config->montecarlo->requestForm;
$config->montecarlo->formConfig[] = $config->montecarlo->decisionRadio;
$config->montecarlo->formConfig[] = $config->montecarlo->runNumber;
