<?php
require_once dirname(__DIR__) . '/das/methods/vendor/autoload.php';

function utf8_array_asort(&$array)
{
    if(!isset($array) || !is_array($array)) {
        return false;
    }
    foreach($array as $k=>$v) {
        $array[$k] = iconv('UTF-8', 'GBK//IGNORE',$v);//对不能识别的字符进行跳过处理
    }
    asort($array);
    foreach($array as $k=>$v) {
        $array[$k] = iconv('GBK', 'UTF-8//IGNORE', $v);
    }
    return true;
}

function formatDigit($value)
{
    if(is_numeric($value)) return $value;

    if(is_string($value))
    {
        if(strpos($value, '%') !== false)
        {
            $value = str_replace('%', '', $value) / 100;
        }
        return floatval($value);
    }
    return null;
}
