<?php

class PolynomialRegression
{
    /**
     * 回归多项式的类型
     *
     * @var int
     * @access public
     */
    public $degree;

    /**
     * 预测变量
     *
     * @var array
     * @access public
     */
    public $x;

    /**
     * 响应变量
     *
     * @var array
     * @access public
     */
    public $y;

    /**
     * 多项式系数
     *
     * @var object
     * @access public
     */
    public $coeff;

    /**
     * 模型汇总
     *
     * @var object
     * @access public
     */
    public $model;

    /**
     * 方差分析
     *
     * @var object
     * @access public
     */
    public $anova;

    public $service;

    public $path;

    public function __construct($degree, $x, $y)
    {
        global $config;
        $this->service = $config->gonumService;
        $this->path    = dirname(__DIR__);
        $this->degree = $degree;
        $this->x = $x;
        $this->y = $y;

        $analysisJson = $this->analysis();

        $data = json_decode($analysisJson);

        if($data)
        {
            $this->coeff = $data->Coeff;
            $this->model = $data->Model;
            $this->anova = $data->Anova;
        }
    }

    /**
     * 调用golang计算服务进行回归分析。
     *
     * @access private
     * @return void
     */
    private function analysis()
    {
        $path   = $this->path;
        $xStr   = implode(',', $this->x);
        $yStr   = implode(',', $this->y);
        return exec("$path/{$this->service} -exec -method=polynomial-regression $this->degree $xStr $yStr");
    }
}
