<?php
require_once dirname(dirname(__DIR__)) . '/das/methods/vendor/autoload.php';

/**
 * 获取多个数组的组合
 * @list  二维数组$list [] = array (1,2,3);
 * return  array
 */
class Combination
{

    private $Combination;

    private $separator;

    public function __construct($list = array(), $separator = ',')
    {
        $this->separator = $separator;
        $list = array_values($list);
        $this->GetForeach($list);
    }

    /**
     *  拦截器
     * @param $name 成员属性名称
     * @return 成员属性
     */
    public function getCombination()
    {
        return $this->Combination;
    }

    /**
     * 调用getSulie完成组合
     * @param type $list
     */
    private function GetForeach($list)
    {
        foreach($list[0] as $v)
        {
            $this->getSulie($list,array($v),1);
        }
    }

    /**
     * 实现组合
     * @param type $list
     * @param type $content
     * @param type $deep
     * @return type
     */
    private function getSulie($list, $content, $deep)
    {
        $i = 0;
        if($deep > count($list))
        {
            return;
        }

        foreach($list as $k => $v)
        {
            if($i == $deep)
            {
                foreach($list[$k] as $vv)
                {
                    $newContent = unserialize(serialize($content));
                    $newContent[] = $vv;
                    if($deep == count($list) - 1)
                    {
                        $this->Combination[] = $newContent;
                    }
                    else
                    {
                        $this->getSulie($list, $newContent, $deep + 1);
                    }
                }
                break;
            }
            $i ++;
        }
        //return $this->Combination;
    }
}


/**
 * 使用例子
 * $list [] = array (1,2,3);
 * $list [] = array (1,2);
 * $list [] = array (1,2,3,4);
 * $list [] = array ('a','b');
 * $list [] = array ('A','B');
 * $s = new arrayCombination($list);
 * print_r($s->Combination);
 */
?>
