<?php

/**
 * SpcChart
 */
class spcChart
{

    /**
     * 数据
     * dataframe
     *
     * @var object
     * @access public
     */
    public $dataframe;

    public $decimals;

    /**
     * 构造方法。
     *
     * The construct function.
     *
     * @access public
     * @return void
     */
    public function __construct($dataframe)
    {
        global $config;
        $this->decimals  = $config->default->decimals;
        $this->dataframe = $dataframe;
    }

    /**
     * Group data with group num.
     *
     * @param string $var
     * @param int $groupNum
     * @access public
     * @return object
     */
    public function groupData($var, $sub, $groupNum, $groupCol)
    {
        $datas     = $this->dataframe->cols($var, 'number');
        $charts    = array();

        $indexs = array();
        if($sub == 'number')
        {
            foreach($datas as $i => $data)
            {
                $data  = $data->trimdata;
                $count = 0;
                $indexs[$i] = array();
                foreach($data as $value)
                {
                    if($count >= $groupNum) $count = 0;
                    if(!isset($indexs[$i][$count])) $indexs[$i][$count] = array();

                    if(!empty($value) or is_numeric($value)) $indexs[$i][$count][] = $value;

                    $count += 1;
                }
            }
        }
        else
        {
            $groupCols = $this->dataframe->col($groupCol, 'any')->data;
            foreach($datas as $i => $data)
            {
                $data        = $data->trimdata;
                $pre         = null;
                $groupData   = array();
                $subCount       = 0; // current subgroup amount.
                $subIndex       = 0; // value amount of current subgroup.
                foreach($data as $s => $value)
                {
                    $curr = $groupCols[$s];
                    if($pre == null)
                    {
                        $groupData[$subIndex] = array($value);
                        $pre = $curr;
                        continue;
                    }

                    if($curr != $pre)
                    {
                        $subCount += 1;
                        $subIndex = 0;
                    }
                    if($curr == $pre) $subIndex += 1;

                    if(!isset($groupData[$subIndex])) $groupData[$subIndex] = array();
                    while(count($groupData[$subIndex]) < $subCount)
                    {
                        $groupData[$subIndex][] = null;
                    }
                    $groupData[$subIndex][] = $value;

                    $pre = $curr;
                }

                $indexs[$i] = $groupData;
            }
        }

        $this->dataframe->data = array();
        $this->dataframe->columns = array();

        foreach($datas as $i => $data)
        {
            $trans = $indexs[$i];
            $groupKey = 'sub';
            $subs = array();
            foreach($trans as $index => $subgroup)
            {
                if(empty($subgroup)) continue;
                $key = $groupKey . $i . $index;
                $subs[] = $key;
                $this->dataframe = self::addData($this->dataframe, $key, $key, $subgroup);
            }
            $charts[] = $subs;
        }

        return $charts;
    }

    /**
     * Format multiple string to multiple float array.
     *
     * @param string $multiple
     * @access public
     * @return object
     */
    public static function formatMultiple($multiple)
    {
        $multiple  = $multiple ? explode(',', $multiple) : array('3');
        foreach($multiple as $key => $multi)
        {
            if(strlen($multi) > 1) $multiple[$key] = (string)round((float)$multi, 2);
        }
        if(!in_array('3', $multiple)) $multiple[] = '3';

        return $multiple;
    }

    /**
     * Format reference string to reference float array.
     *
     * @param string $reference
     * @access public
     * @return object
     */
    public static function formatReference($reference)
    {
        $reference  = $reference ? explode(',', $reference) : array();
        foreach($reference as $key => $ref)
        {
            if(strlen($ref) > 1) $reference[$key] = (string)round((float)$ref, 2);
        }

        return array_unique($reference);
    }

    /**
     * SPC calculate subgroup size method.
     *
     * @param array $cols
     * @param string $type
     * @access public
     * @return object
     */
    public function subgroup($cols, $type)
    {
        $subgroup = array();
        foreach($this->dataframe->data as $index => $data)
        {
            $sub = array();
            foreach($cols as $i => $col)
            {
                if(isset($data[$col]))
                {
                    $value = $data[$col];
                    if(strpos($value, '%') !== false) $value = (string)(trim($value, '%') / 100);

                    if(is_numeric($value)) $sub[] = $value;
                }
            }
            $subgroup[] = count($sub);
        }
        $sizeFixed = count(array_count_values($subgroup)) == 1;

        $result            = new stdclass();
        $result->subgroup  = $subgroup;
        $result->sizeFixed = $sizeFixed;

        return $result;
    }

    /**
     * Add data to dataframe.
     *
     * @param object $dataframe
     * @param string $key
     * @access public
     * @return object
     */
    public static function addData($dataframe, $key, $name, $data)
    {
        global $dasLang;
        $dataframe->columns[$key] = $name;

        foreach(array_values($data) as $index => $item)
        {
            $dataframe->data[$index][$key] = $item;
        }

        return $dataframe;
    }
}
