<?php
require_once LIB_ROOT . '/zendasmath/basic/describe.php';
require_once LIB_ROOT . '/dataframe/checkdata.php';
require_once LIB_ROOT . '/dataframe/validatedata.php';

/* Simulate data reciprocal. */
class reciprocalSimulate
{
    public static $settings = array();

    public static function data($dataframe, $settings)
    {
        global $dasLang;
        global $config;
        $decimals = $config->default->decimals;

        $type      = 'any';
        $dataCol   = $settings['dataCol'];
        $resultCol = $settings['resultCol'];

        $check = new checkData();
        $check->setData($dataframe->colData($dataCol), $dataframe->columns[$dataCol], self::$settings['dataCol']['validate']);

        $checkRes = $check->check();
        if(is_string($checkRes)) return ValidateData::result($checkRes);

        $col = $dataframe->col($dataCol, $type);

        $resultData  = Describe::reciprocal($col->trimdata);

        return array($resultCol => $resultData);
    }

    public static function checkNotNull($value)
    {
        return (is_numeric($value) or (!is_numeric($value) and !empty($value)));
    }

    /**
     * Get settings.
     *
     * @access public
     * @return object
     */
    public static function getSettings($dataframe)
    {
        global $dasLang;
        $columns = $dataframe->columns;
        $length  = count($columns) + 1;

        $colEnum = array();
        $i       = 1;
        $firstEmptyCol = null;
        foreach($columns as $col => $column)
        {
            $colData = $dataframe->colData($col);
            if(empty($colData) && $firstEmptyCol === null) $firstEmptyCol = $i;
            $colEnum[$i] = $column;
            $i++;
        }
        if($firstEmptyCol === null) $firstEmptyCol = $length;
        for($i = $length; $i < $length + 10; $i++)
        {
            $colEnum[$i] = 'C' . $i;
        }

        self::$settings['dataCol']   = array('name' => 'dataCol', 'label' => $dasLang->reciprocal->reciprocalCol, 'type' => 'column', 'required' => true, 'columnType' => 'text');
        self::$settings['resultCol'] = array('name' => 'resultCol', 'label' => $dasLang->reciprocal->resultCol, 'type' => 'enum', 'required' => true, 'columnType' => 'text', 'enumOptions' => $colEnum, 'defaultValue' => $firstEmptyCol);

        self::$settings['dataCol'] += array('validate' => array('number'));

        return self::$settings;
    }
}
