<?php
require_once LIB_ROOT . '/zendasmath/basic/describe.php';
require_once LIB_ROOT . '/dataframe/checkdata.php';
require_once LIB_ROOT . '/dataframe/validatedata.php';

/* Simulate data rank. */
class rankSimulate
{

    public static $settings = array();

    public static function data($dataframe, $settings)
    {
        global $dasLang;
        global $config;
        $decimals = $config->default->decimals;

        $type      = 'any';
        $rankCol   = $settings['rankCol'];
        $resultCol = $settings['resultCol'];

        $check = new checkData();
        $check->setData($dataframe->colData($rankCol), $dataframe->columns[$rankCol], self::$settings['rankCol']['validate']);

        $checkRes = $check->check();
        if(is_string($checkRes)) return ValidateData::result($checkRes);

        $sliceDF = $dataframe->sliceDataframe($dataframe, $rankCol, $type);
        $rowData = $sliceDF->col($rankCol, $type);

        $originData = $rowData->trimdata;
        $neData     = $sliceDF->col($rankCol, $type)->trimdata;
        $neRanking  = Describe::fractionalRanking($neData);
        $resultMap  = array();

        foreach($neData as $key => $value)
        {
            $resultMap[(string)$value] = $neRanking[$key];
        }

        $resultData = array();
        foreach($originData as $key => $value)
        {
            if(!self::checkNotNull($value))
            {
                $resultData[] = NULL;
            }
            else
            {
                $resultData[] = $resultMap[(string)$value];
            }
        }

        return array($resultCol => $resultData);
    }

    public static function checkNotNull($value)
    {
        return (is_numeric($value) or (!is_numeric($value) and !empty($value)));
    }

    /**
     * Get settings.
     *
     * @access public
     * @return object
     */
    public static function getSettings($dataframe)
    {
        global $dasLang;
        $columns = $dataframe->columns;
        $length  = count($columns) + 1;

        $colEnum = array();
        $i       = 1;
        $firstEmptyCol = null;
        foreach($columns as $col => $column)
        {
            $colData = $dataframe->colData($col);
            if(empty($colData) && $firstEmptyCol === null) $firstEmptyCol = $i;
            $colEnum[$i] = $column;
            $i++;
        }
        if($firstEmptyCol === null) $firstEmptyCol = $length;
        for($i = $length; $i < $length + 10; $i++)
        {
            $colEnum[$i] = 'C' . $i;
        }

        self::$settings['rankCol']   = array('name' => 'rankCol', 'label' => $dasLang->rank->rankCol, 'type' => 'column', 'required' => true, 'columnType' => 'text');
        self::$settings['resultCol'] = array('name' => 'resultCol', 'label' => $dasLang->rank->resultCol, 'type' => 'enum', 'required' => true, 'columnType' => 'text', 'enumOptions' => $colEnum, 'defaultValue' => $firstEmptyCol);

        self::$settings['rankCol'] += array('validate' => array('number'));

        return self::$settings;
    }
}
