<?php

namespace MathPHP\Tests\LinearAlgebra\Fixture;

use MathPHP\Expression\Polynomial;
use MathPHP\Number\Complex;

trait MatrixDataProvider
{
    /**************************************************************************
     * MATRIX PROPERTIES
     *  - dataProviderForSquareMatrix
     *  - dataProviderForSquareMatrixGreaterThanOne
     *  - dataProviderForNotSquareMatrix
     *  - dataProviderForSymmetricMatrix
     *  - dataProviderForNotSymmetricMatrix
     *  - dataProviderForSkewSymmetricMatrix
     *  - dataProviderForSingularMatrix
     *  - dataProviderForNonsingularMatrix
     *  - dataProviderForTwoNonsingularMatrices
     *  - dataProviderForPositiveDefiniteMatrix
     *  - dataProviderForNotPositiveDefiniteMatrix
     *  - dataProviderForPositiveSemidefiniteMatrix
     *  - dataProviderForNotPositiveSemidefiniteMatrix
     *  - dataProviderForNegativeDefiniteMatrix
     *  - dataProviderForNotNegativeDefiniteMatrix
     *  - dataProviderForNegativeSemidefiniteMatrix
     *  - dataProviderForNotNegativeSemidefiniteMatrix
     *  - dataProviderForNotSquareAndSymmetricMatrix
     *  - dataProviderForUpperTriangularMatrix
     *  - dataProviderForNotTriangularMatrix
     *  - dataProviderForLowerTriangularMatrix
     *  - dataProviderForDiagonalMatrix
     *  - dataProviderForNotDiagonalMatrix
     *  - dataProviderForRectangularDiagonalMatrix
     *  - dataProviderForNotRectangularDiagonalMatrix
     *  - dataProviderForRefMatrix
     *  - dataProviderForNotRefMatrix
     *  - dataProviderForRrefMatrix
     *  - dataProviderForTwoSquareMatrices
     *  - dataProviderForThreeMatrices
     *  - dataProviderForFourMatrices
     *  - dataProviderForSolve
     *  - dataProviderForTwoPositiveDefiniteMatrices
     *  - dataProviderForIdempotentMatrix
     *  - dataProviderForNotIdempotentMatrix
     *  - dataProviderForNilpotentMatrix
     *  - dataProviderForNotNilpotentMatrix
     *  - dataProviderForInvolutoryMatrix
     *  - dataProviderForNotInvolutoryMatrix
     *  - dataProviderForSignatureMatrix
     *  - dataProviderForNotSignatureMatrix
     *  - dataProviderForHilbertMatrix
     *  - dataProviderForUpperBidiagonalMatrix
     *  - dataProviderForNotUpperBidiagonalMatrix
     *  - dataProviderForLowerBidiagonalMatrix
     *  - dataProviderForNotLowerBidiagonalMatrix
     *  - dataProviderForBidiagonalMatrix
     *  - dataProviderForNotBidiagonalMatrix
     *  - dataProviderForTridiagonalMatrix
     *  - dataProviderForNotTridiagonalMatrix
     *  - dataProviderForUpperHessenbergMatrix
     *  - dataProviderForNotUpperHessenbergMatrix
     *  - dataProviderForLowerHessenbergMatrix
     *  - dataProviderForNotLowerHessenbergMatrix
     *  - dataProviderForIdentityMatrix
     *  - dataProviderForSingleMatrix
     *  - dataProviderForOrthogonalMatrix
     *  - dataProviderForNonOrthogonalMatrix
     *  - dataProviderForNonNormalMatrix
     *  - dataProviderForMatrixWithWeirdNumbers
     *  - dataProviderForObjectMatrix
     *  - dataProviderForObjectSquareMatrix
     *  - dataProviderForComplexObjectMatrix
     *  - dataProviderForComplexSquareObjectMatrix
     **************************************************************************/

    public function dataProviderForSquareMatrix()
    {
        return [
            [
                [
                    [1]
                ]
            ],
            [
                [
                    [1, 2],
                    [2, 3],
                ]
            ],
            [
                [
                    [-1, 2],
                    [-2, 3],
                ]
            ],
            [
                [
                    [5, 12],
                    [6, -5],
                ]
            ],
            [
                [
                    [1, 5],
                    [4, 3],
                ],
            ],
            [
                [
                    [5, 6],
                    [2, 1],
                ],
            ],
            [
                [
                    [1, 0, 5],
                    [4, 2, 0],
                    [3, 0, 3],
                ],
            ],
            [
                [
                    [1, 2, 3],
                    [4, 5, 6],
                    [7, 8, 9],
                ]
            ],
            [
                [
                    [7, -2, 13],
                    [5, 0, 4],
                    [6, -2, 1],
                ]
            ],
            [
                [
                    [3, 8, 5],
                    [3, 6, 1],
                    [9, 5, 8],
                ],
            ],
            [
                [
                    [5, 3, 8],
                    [6, 4, 5],
                    [1, 8, 9],
                ],
            ],
            [
                [
                    [-4, -2, 9],
                    [3, 14, -6],
                    [3, 9, 9],
                ],
            ],
            [
                [
                    [8, 7, 8],
                    [-5, 4, 1],
                    [3, 5, 1],
                ],
            ],
            [
                [
                    [1, 2, 3, 2],
                    [4, 5, 6, 2],
                    [7, 8, 9, 2],
                    [4, 5, 5, 6],
                ]
            ],
            [
                [
                    [7, 8, 9, 2],
                    [1, 2, 3, 2],
                    [4, -3, 2, 12],
                    [4, 1, -6, 6],
                ]
            ],
            [
                [
                    [4, 7, 7, 8],
                    [3, 6, 4, 1],
                    [-3, 6, 8, -3],
                    [3, 2, 1, -54],
                ],
            ],
            [
                [
                    [3, 2, 6, 7],
                    [4, 3, -6, 2],
                    [12, 14, 14, -6],
                    [4, 6, 4, -42],
                ],
            ],
            [
                [
                    [-5, -12, 12, -13],
                    [0, -5, -1, -3,],
                    [13, -20, -12, -8],
                    [16, -18, 11, -14],
                ]
            ],
            [
                [
                    [11, 11, -8, -18, 17],
                    [-19, -20, 6, -10, 0],
                    [3, -17, 10, 14, -20],
                    [-14, 7, -4, 0, 5],
                    [-15, -18, -4, -14, -6],
                ]
            ],
            [
                [
                    [-7, 14, 15, 14, 2],
                    [1, -10, 11, 17, -20],
                    [3, -18, 9, 13, -19],
                    [-17, -3, 5, -9, -6],
                    [1, -2, -9, -19, 7],
                ]
            ],
            [
                [
                    [-17, -3, 0, 1, -8],
                    [-7, 9, 16, 0, -5],
                    [3, 6, -6, 16, -5],
                    [-1, -5, -10, 14, 16],
                    [18, 5, 20, -17, -15],
                ]
            ],
            [
                [
                    [10, -18, 19, -5, 7],
                    [-18, 18, -15, -19, 16],
                    [-11, -14, -15, 12, -13],
                    [-3, 4, 1, -13, -17],
                    [17, 17, -15, 17, -13],
                ]
            ],
            [
                [
                    [-8, 11, -9, 4, 19],
                    [-20, 20, 16, 14, -9],
                    [1, -11, 14, -2, 4],
                    [11, -10, 9, -2, -5],
                    [9, -5, -20, -19, 3],
                ]
            ],
            [
                [
                    [1, 9, -10, 14, -2],
                    [-1, -14, 3, 6, 0],
                    [-2, 5, -5, 19, -5],
                    [-12, 8, -18, 0, 14],
                    [19, -3, 16, 15, 3],
                ]
            ],
            [
                [
                    [-18, -13, 1, 3, -8],
                    [9, 18, 20, 18, 8],
                    [-16, 2, 12, -5, -11],
                    [-9, 20, -6, 4, 9],
                    [-16, 1, -17, 20, 5],
                ]
            ],
            [
                [
                    [8, -14, 6, -5, 11],
                    [-20, -5, -2, -13, -6],
                    [0, 17, -7, -9, -15],
                    [10, -12, 13, 15, 3],
                    [1, 16, -1, 9, 11],
                ]
            ],
            [
                [
                    [-9, -9, 14, -6, -8],
                    [3, -1, 18, 15, 4],
                    [-10, -3, 18, -12, 7],
                    [-7, 4, -17, -11, -7],
                    [7, -2, -7, 12, 8],
                ]
            ],
        ];
    }

    public function dataProviderForSquareMatrixGreaterThanOne()
    {
        return [
            [
                [
                    [1, 2],
                    [2, 3],
                ]
            ],
            [
                [
                    [-1, 2],
                    [-2, 3],
                ]
            ],
            [
                [
                    [5, 12],
                    [6, -5],
                ]
            ],
            [
                [
                    [1, 5],
                    [4, 3],
                ],
            ],
            [
                [
                    [5, 6],
                    [2, 1],
                ],
            ],
            [
                [
                    [1, 0, 5],
                    [4, 2, 0],
                    [3, 0, 3],
                ],
            ],
            [
                [
                    [1, 2, 3],
                    [4, 5, 6],
                    [7, 8, 9],
                ]
            ],
            [
                [
                    [7, -2, 13],
                    [5, 0, 4],
                    [6, -2, 1],
                ]
            ],
            [
                [
                    [3, 8, 5],
                    [3, 6, 1],
                    [9, 5, 8],
                ],
            ],
            [
                [
                    [5, 3, 8],
                    [6, 4, 5],
                    [1, 8, 9],
                ],
            ],
            [
                [
                    [-4, -2, 9],
                    [3, 14, -6],
                    [3, 9, 9],
                ],
            ],
            [
                [
                    [8, 7, 8],
                    [-5, 4, 1],
                    [3, 5, 1],
                ],
            ],
            [
                [
                    [1, 2, 3, 2],
                    [4, 5, 6, 2],
                    [7, 8, 9, 2],
                    [4, 5, 5, 6],
                ]
            ],
            [
                [
                    [7, 8, 9, 2],
                    [1, 2, 3, 2],
                    [4, -3, 2, 12],
                    [4, 1, -6, 6],
                ]
            ],
            [
                [
                    [4, 7, 7, 8],
                    [3, 6, 4, 1],
                    [-3, 6, 8, -3],
                    [3, 2, 1, -54],
                ],
            ],
            [
                [
                    [3, 2, 6, 7],
                    [4, 3, -6, 2],
                    [12, 14, 14, -6],
                    [4, 6, 4, -42],
                ],
            ],
            [
                [
                    [-5, -12, 12, -13],
                    [0, -5, -1, -3,],
                    [13, -20, -12, -8],
                    [16, -18, 11, -14],
                ]
            ],
            [
                [
                    [11, 11, -8, -18, 17],
                    [-19, -20, 6, -10, 0],
                    [3, -17, 10, 14, -20],
                    [-14, 7, -4, 0, 5],
                    [-15, -18, -4, -14, -6],
                ]
            ],
            [
                [
                    [-7, 14, 15, 14, 2],
                    [1, -10, 11, 17, -20],
                    [3, -18, 9, 13, -19],
                    [-17, -3, 5, -9, -6],
                    [1, -2, -9, -19, 7],
                ]
            ],
            [
                [
                    [-17, -3, 0, 1, -8],
                    [-7, 9, 16, 0, -5],
                    [3, 6, -6, 16, -5],
                    [-1, -5, -10, 14, 16],
                    [18, 5, 20, -17, -15],
                ]
            ],
            [
                [
                    [10, -18, 19, -5, 7],
                    [-18, 18, -15, -19, 16],
                    [-11, -14, -15, 12, -13],
                    [-3, 4, 1, -13, -17],
                    [17, 17, -15, 17, -13],
                ]
            ],
            [
                [
                    [-8, 11, -9, 4, 19],
                    [-20, 20, 16, 14, -9],
                    [1, -11, 14, -2, 4],
                    [11, -10, 9, -2, -5],
                    [9, -5, -20, -19, 3],
                ]
            ],
            [
                [
                    [1, 9, -10, 14, -2],
                    [-1, -14, 3, 6, 0],
                    [-2, 5, -5, 19, -5],
                    [-12, 8, -18, 0, 14],
                    [19, -3, 16, 15, 3],
                ]
            ],
            [
                [
                    [-18, -13, 1, 3, -8],
                    [9, 18, 20, 18, 8],
                    [-16, 2, 12, -5, -11],
                    [-9, 20, -6, 4, 9],
                    [-16, 1, -17, 20, 5],
                ]
            ],
            [
                [
                    [8, -14, 6, -5, 11],
                    [-20, -5, -2, -13, -6],
                    [0, 17, -7, -9, -15],
                    [10, -12, 13, 15, 3],
                    [1, 16, -1, 9, 11],
                ]
            ],
            [
                [
                    [-9, -9, 14, -6, -8],
                    [3, -1, 18, 15, 4],
                    [-10, -3, 18, -12, 7],
                    [-7, 4, -17, -11, -7],
                    [7, -2, -7, 12, 8],
                ]
            ],
        ];
    }

    public function dataProviderForSquareMatrixGreaterThanOneWithoutOddMatrices()
    {
        return [
            [
                [
                    [1, 2],
                    [2, 3],
                ]
            ],
            [
                [
                    [-1, 2],
                    [-2, 3],
                ]
            ],
            [
                [
                    [5, 12],
                    [6, -5],
                ]
            ],
            [
                [
                    [1, 5],
                    [4, 3],
                ],
            ],
            [
                [
                    [5, 6],
                    [2, 1],
                ],
            ],
            [
                [
                    [1, 0, 5],
                    [4, 2, 0],
                    [3, 0, 3],
                ],
            ],
            [
                [
                    [7, -2, 13],
                    [5, 0, 4],
                    [6, -2, 1],
                ]
            ],
            [
                [
                    [3, 8, 5],
                    [3, 6, 1],
                    [9, 5, 8],
                ],
            ],
            [
                [
                    [5, 3, 8],
                    [6, 4, 5],
                    [1, 8, 9],
                ],
            ],
            [
                [
                    [-4, -2, 9],
                    [3, 14, -6],
                    [3, 9, 9],
                ],
            ],
            [
                [
                    [8, 7, 8],
                    [-5, 4, 1],
                    [3, 5, 1],
                ],
            ],
            [
                [
                    [7, 8, 9, 2],
                    [1, 2, 3, 2],
                    [4, -3, 2, 12],
                    [4, 1, -6, 6],
                ]
            ],
            [
                [
                    [4, 7, 7, 8],
                    [3, 6, 4, 1],
                    [-3, 6, 8, -3],
                    [3, 2, 1, -54],
                ],
            ],
            [
                [
                    [3, 2, 6, 7],
                    [4, 3, -6, 2],
                    [12, 14, 14, -6],
                    [4, 6, 4, -42],
                ],
            ],
            [
                [
                    [-5, -12, 12, -13],
                    [0, -5, -1, -3,],
                    [13, -20, -12, -8],
                    [16, -18, 11, -14],
                ]
            ],
            [
                [
                    [11, 11, -8, -18, 17],
                    [-19, -20, 6, -10, 0],
                    [3, -17, 10, 14, -20],
                    [-14, 7, -4, 0, 5],
                    [-15, -18, -4, -14, -6],
                ]
            ],
            [
                [
                    [-7, 14, 15, 14, 2],
                    [1, -10, 11, 17, -20],
                    [3, -18, 9, 13, -19],
                    [-17, -3, 5, -9, -6],
                    [1, -2, -9, -19, 7],
                ]
            ],
            [
                [
                    [-17, -3, 0, 1, -8],
                    [-7, 9, 16, 0, -5],
                    [3, 6, -6, 16, -5],
                    [-1, -5, -10, 14, 16],
                    [18, 5, 20, -17, -15],
                ]
            ],
            [
                [
                    [10, -18, 19, -5, 7],
                    [-18, 18, -15, -19, 16],
                    [-11, -14, -15, 12, -13],
                    [-3, 4, 1, -13, -17],
                    [17, 17, -15, 17, -13],
                ]
            ],
            [
                [
                    [-8, 11, -9, 4, 19],
                    [-20, 20, 16, 14, -9],
                    [1, -11, 14, -2, 4],
                    [11, -10, 9, -2, -5],
                    [9, -5, -20, -19, 3],
                ]
            ],
            [
                [
                    [1, 9, -10, 14, -2],
                    [-1, -14, 3, 6, 0],
                    [-2, 5, -5, 19, -5],
                    [-12, 8, -18, 0, 14],
                    [19, -3, 16, 15, 3],
                ]
            ],
            [
                [
                    [-18, -13, 1, 3, -8],
                    [9, 18, 20, 18, 8],
                    [-16, 2, 12, -5, -11],
                    [-9, 20, -6, 4, 9],
                    [-16, 1, -17, 20, 5],
                ]
            ],
            [
                [
                    [8, -14, 6, -5, 11],
                    [-20, -5, -2, -13, -6],
                    [0, 17, -7, -9, -15],
                    [10, -12, 13, 15, 3],
                    [1, 16, -1, 9, 11],
                ]
            ],
            [
                [
                    [-9, -9, 14, -6, -8],
                    [3, -1, 18, 15, 4],
                    [-10, -3, 18, -12, 7],
                    [-7, 4, -17, -11, -7],
                    [7, -2, -7, 12, 8],
                ]
            ],
        ];
    }

    public function dataProviderForNotSquareMatrix()
    {
        return [
            [
                [[1,2]]
            ],
            [
                [
                    [1, 2, 4],
                    [2, 3, 5],
                ]
            ],
            [
                [
                    [1, 2, 3, 5],
                    [4, 5, 6, 5],
                    [7, 8, 9, 5],
                ]
            ],
            [
                [
                    [1, 2, 3],
                    [4, 5, 6],
                    [7, 8, 9],
                    [1, 2, 3],
                ]
            ],
        ];
    }

    public function dataProviderForSymmetricMatrix()
    {
        return [
            [
                [
                    [1],
                ],
            ],
            [
                [
                    [1, 2],
                    [2, 3],
                ]
            ],
            [
                [
                    [1, 2],
                    [2, 1],
                ],
            ],
            [
                [
                    [4, 1],
                    [1, -2],
                ],
            ],
            [
                [
                    [4, -1],
                    [-1, 9],
                ],
            ],
            [
                [
                    [1, 2, 3],
                    [2, 6, 4],
                    [3, 4, 5],
                ],
            ],
            [
                [
                    [1, 7, 3],
                    [7, 4, -5],
                    [3, -5, 6],
                ],
            ],
            [
                [
                    [5, 6, 7],
                    [6, 3, 2],
                    [7, 2, 1],
                ],
            ],
            [
                [
                    [2, 7, 3],
                    [7, 9, 4],
                    [3, 4, 7],
                ],
            ],
            [
                [
                    [4, -1, -1, -1],
                    [-1, 4, -1, -1],
                    [-1, -1, 4, -1],
                    [-1, -1, -1, 4],
                ],
            ],
            [
                [
                    [1, 5, 6, 8],
                    [5, 2, 7, 9],
                    [6, 7, 3, 10],
                    [8, 9, 10, 4],
                ],
            ],
            [
                [
                    [1, 7, 3, 6],
                    [7, 4, -5, 3],
                    [3, -5, 6, 2],
                    [6, 3, 2, 4],
                ],
            ],
        ];
    }

    public function dataProviderForNotSymmetricMatrix()
    {
        return [
            [
                [[1, 1]],
            ],
            [
                [
                    [1, 2],
                    [5, 3],
                ]
            ],
            [
                [
                    [1, 7, 3],
                    [7, 4, 5],
                    [-3, -5, 6],
                ],
            ],
            [
                [
                    [1, 2, 3, 4],
                    [1, 2, 3, 4],
                ],
            ],
        ];
    }

    public function dataProviderForSkewSymmetricMatrix()
    {
        return [
            [
                [
                    [0]
                ]
            ],
            [
                [
                    [0, 0],
                    [0, 0],
                ]
            ],
            [
                [
                    [0, 2],
                    [-2, 0],
                ],
            ],
            [
                [
                    [0, -1],
                    [1, 0],
                ],
            ],
            [
                [
                    [0, 1],
                    [-1, 0],
                ],
            ],
            [
                [
                    [0, 2, -1],
                    [-2, 0, -4],
                    [1, 4, 0],
                ]
            ],
            [
                [
                    [0, -2, 3],
                    [2, 0, -5],
                    [-3, 5, 0],
                ]
            ],
            [
                [
                    [0, 2, -3],
                    [-2, 0, -4],
                    [3, 4, 0],
                ],
            ],
            [
                [
                    [0, 7, 3],
                    [-7, 0, -5],
                    [-3, 5, 0],
                ],
            ],
            [
                [
                    [0, 6, 7],
                    [-6, 0, 2],
                    [-7, -2, 0],
                ],
            ],
            [
                [
                    [0, -7, -3],
                    [7, 0, -4],
                    [3, 4, 0],
                ],
            ],
            [
                [
                    [0, -1, -1, -1],
                    [1, 0, -1, -1],
                    [1, 1, 0, -1],
                    [1, 1, 1, 0],
                ],
            ],
            [
                [
                    [0, -5, -6, 8],
                    [5, 0, 7, 9],
                    [6, -7, 0, 10],
                    [-8, -9, -10, 0],
                ],
            ],
            [
                [
                    [0, -7, -3, -6],
                    [7, 0, -5, 3],
                    [3, 5, 0, 2],
                    [6, -3, -2, 0],
                ],
            ],
        ];
    }

    public function dataProviderForNotSkewSymmetricMatrix()
    {
        return [
            [
                [
                    [1]
                ]
            ],
            [
                [
                    [1, 0],
                    [0, 1],
                ]
            ],
            [
                [
                    [0, 2],
                    [2, 0],
                ],
            ],
            [
                [
                    [1, -1],
                    [1, 1],
                ],
            ],
            [
                [
                    [0, 2, -1],
                    [-2, 1, -4],
                    [1, 4, 0],
                ]
            ],
            [
                [
                    [0, -1, -1, -1],
                    [1, 0, -1, -1],
                    [1, 1, 0, 1],
                    [1, 1, 1, 0],
                ],
            ],
        ];
    }

    public function dataProviderForSingularMatrix()
    {
        return [
            [
                [
                    [0],
                ],
            ],
            [
                [
                    [0, 0],
                    [0, 0],
                ]
            ],
            [
                [
                    [0, 0],
                    [0, 1],
                ]
            ],
            [
                [
                    [0, 0],
                    [1, 0],
                ]
            ],
            [
                [
                    [0, 0],
                    [1, 1],
                ]
            ],
            [
                [
                    [0, 1],
                    [0, 0],
                ]
            ],
            [
                [
                    [0, 1],
                    [0, 1],
                ]
            ],
            [
                [
                    [1, 0],
                    [0, 0],
                ]
            ],
            [
                [
                    [1, 0],
                    [1, 0],
                ]
            ],
            [
                [
                    [1, 1],
                    [0, 0],
                ]
            ],
            [
                [
                    [1, 1],
                    [1, 1],
                ]
            ],
            [
                [
                    [1, 2, 3],
                    [2, 3, 4],
                    [3, 4, 5],
                ],
            ],
            [
                [
                    [1, 2, 1],
                    [-2, -3, 1],
                    [3, 5, 0],
                ],
            ],
            [
                [
                    [1, -1, 2],
                    [2, 1, 1],
                    [1, 1, 0],
                ],
            ],
            [
                [
                    [1, 0, 1],
                    [0, 1, -1],
                    [0, 0, 0],
                ],
            ],
            [
                [
                    [1, 1, 4, 1, 2],
                    [0, 1, 2, 1, 1],
                    [0, 0, 0, 1, 2],
                    [1, -1, 0, 0, 2],
                    [2, 1, 6, 0, 1],
                ],
            ],
        ];
    }

    public function dataProviderForNonsingularMatrix()
    {
        return [
            [
                [
                    [1],
                ],
            ],
            [
                [
                    [0, 1],
                    [1, 0],
                ]
            ],
            [
                [
                    [0, 1],
                    [1, 1],
                ]
            ],
            [
                [
                    [1, 0],
                    [0, 1],
                ]
            ],
            [
                [
                    [1, 0],
                    [1, 1],
                ]
            ],
            [
                [
                    [1, 1],
                    [0, 1],
                ]
            ],
            [
                [
                    [1, 1],
                    [1, 0],
                ]
            ],
            [
                [
                    [-7, -6, -12],
                    [5, 5, 7],
                    [1, 0, 4],
                ],
            ],
            [
                [
                    [1, 0, 0],
                    [0, 1, 0],
                    [0, 0, 1],
                ],
            ],
            [
                [
                    [3, 8],
                    [4, 6],
                ],
            ],
            [
                [
                    [4, 3],
                    [3, 2],
                ],
            ],
            [
                [
                    [6, 1, 1],
                    [4, -2, 5],
                    [2, 8, 7],
                ],
            ],
            [
                [
                    [1, 2, 0],
                    [-1, 1, 1],
                    [1, 2, 3],
                ],
            ],
            [
                [
                    [4, 6, 3, 2],
                    [3, 6, 5, 3],
                    [5, 7, 8, 6],
                    [5, 4, 3, 2],
                ],
            ],
            [
                [
                    [3, 2, 0, 1],
                    [4, 0, 1, 2],
                    [3, 0, 2, 1],
                    [9, 2, 3, 1],
                ],
            ],
            [
                [
                    [1, 2, 3, 4],
                    [5, 6, 7, 8],
                    [2, 6, 4, 8],
                    [3, 1, 1, 2],
                ],
            ],
            [
                [
                    [7, 4, 2, 0],
                    [6, 3, -1, 2],
                    [4, 6, 2, 5],
                    [8, 2, -7, 1],
                ],
            ],
            [
                [
                  [-4, 3, 1, 5, -8],
                  [6, 0, 9, 2, 6],
                  [-1, 4, 4, 0, 2],
                  [8, -1, 3, 4, 0],
                  [5, 9, -7, -7, 1]
                ],
            ],
            [
                [
                  [4, 3, 1, 5, -8],
                  [6, 0, 9, 2, 6],
                  [-1, 4, 4, 0, 2],
                  [8, -1, 3, 4, 0],
                  [5, 9, -7, -7, 1]
                ],
            ],
            [
                [
                  [4, 3, 1, 5, 8],
                  [6, 0, 9, 2, 6],
                  [-1, 4, 4, 0, 2],
                  [8, -1, 3, 4, 0],
                  [5, 9, -7, -7, 1]
                ],

            ],
            [
                [
                  [4, 3, 1, 5, 8],
                  [6, 0, 9, 2, 6],
                  [1, 4, 4, 0, 2],
                  [8, -1, 3, 4, 0],
                  [5, 9, -7, -7, 1]
                ],
            ],
            [
                [
                  [4, 3, 1, 5, 8],
                  [6, 0, 9, 2, 6],
                  [1, 4, 4, 0, 2],
                  [8, 1, 3, 4, 0],
                  [5, 9, -7, -7, 1]
                ],
            ],
            [
                [
                  [4, 3, 1, 5, 8],
                  [6, 0, 9, 2, 6],
                  [1, 4, 4, 0, 2],
                  [8, 1, 3, 4, 0],
                  [5, 9, 7, -7, 1]
                ],
            ],
            [
                [
                  [4, 3, 1, 5, 8],
                  [6, 0, 9, 2, 6],
                  [1, 4, 4, 0, 2],
                  [8, 1, 3, 4, 0],
                  [5, 9, 7, 7, 1]
                ],
            ],
            [
                [
                    [5, 2, 0, 0, -2],
                    [0, 1, 4, 3, 2],
                    [0, 0, 2, 6, 3],
                    [0, 0, 3, 4, 1],
                    [0, 0, 0, 0, 2],
                ],
            ],
            [
                [
                    [5, 2, 0, 0, 2],
                    [0, 1, 4, 3, 2],
                    [0, 0, 2, 6, 3],
                    [0, 0, 3, 4, 1],
                    [0, 0, 0, 0, 2],
                ],
            ],
            [
                [
                    [5, 2, 0, 0, -2],
                    [0, -1, 4, 3, 2],
                    [0, 0, 2, 6, 3],
                    [0, 0, 3, 4, 1],
                    [0, 0, 0, 0, 2],
                ],
            ],
            [
                [
                    [2, -9, 1, 8, 4],
                    [-10, -1, 2, 7, 0],
                    [0, 4, -6, 1, -8],
                    [6, -14, 11, 0, 3],
                    [5, 1, -3, 2, -1],
                ],
            ],
            [
                [
                    [2, 9, 1, 8, 4],
                    [-10, -1, 2, 7, 0],
                    [0, 4, -6, 1, -8],
                    [6, -14, 11, 0, 3],
                    [5, 1, -3, 2, -1],
                ],
            ],
            [
                [
                    [2, 9, 1, 8, 4],
                    [10, -1, 2, 7, 0],
                    [0, 4, -6, 1, -8],
                    [6, -14, 11, 0, 3],
                    [5, 1, -3, 2, -1],
                ],
            ],
            [
                [
                    [2, 9, 1, 8, 4],
                    [10, 1, 2, 7, 0],
                    [0, 4, -6, 1, -8],
                    [6, -14, 11, 0, 3],
                    [5, 1, -3, 2, -1],
                ],
            ],
            [
                [
                    [276,1,179,23, 9387],
                    [0, 0, 78, 0, 0],
                    [0, 0, -1, 0, 1],
                    [0, 0, 1994, -1, 1089],
                    [1, 0, 212, 726, -378],
                ],
            ],
            [
                [
                    [276,1,179,23, 9387],
                    [0, 0, 78, 0, 0],
                    [0, 0, 1, 0, 1],
                    [0, 0, 1994, -1, 1089],
                    [1, 0, 212, 726, -378],
                ],
            ],
            [
                [
                    [276,1,179,23, 9387],
                    [0, 0, 78, 0, 0],
                    [0, 0, 1, 0, 1],
                    [0, 0, 1994, 1, 1089],
                    [1, 0, 212, 726, -378],
                ],
            ],
            [
                [
                    [276,1,179,23, 9387],
                    [0, 0, 78, 0, 0],
                    [0, 0, 1, 0, 1],
                    [0, 0, 1994, 1, 1089],
                    [1, 0, 212, 726, 378],
                ],
            ],
            [
                [
                    [276,1,179,23, -9387],
                    [0, 0, 78, 0, 0],
                    [0, 0, 1, 0, 1],
                    [0, 0, 1994, 1, 1089],
                    [1, 0, 212, 726, 378],
                ],
            ],
            [
               [
                    [1, 0, 3, 5, 1],
                    [0, 1, 5, 1, 0],
                    [0, 4, 0, 0, 2],
                    [2, 3, 1, 2, 0],
                    [1, 0, 0, 1, 1],
                ],
            ],
            [
                [
                    [2, 3, 4, 1, 3],
                    [6, 1, 3, 1, 2],
                    [6, 3, 1, 2, 5],
                    [4, 2, 4, 7, 8],
                    [2, 1, 2, 4, 2],
                ],
            ],
            [
                [
                    [2, 3, -4, 1, 3],
                    [6, 1, 3, 1, 2],
                    [6, 3, 1, 2, 5],
                    [4, 2, 4, 7, 8],
                    [2, 1, 2, 4, 2],
                ],
            ],
            [
                [
                    [2, 3, -4, 1, 3],
                    [6, 1, -3, 1, 2],
                    [6, 3, 1, 2, 5],
                    [4, 2, 4, 7, 8],
                    [2, 1, 2, 4, 2],
                ],
            ],
            [
                [
                    [2, 3, -4, 1, 3],
                    [6, 1, -3, 1, 2],
                    [6, 3, -1, 2, 5],
                    [4, 2, 4, 7, 8],
                    [2, 1, 2, 4, 2],
                ],
            ],
            [
                [
                    [2, 3, -4, 1, 3],
                    [6, 1, -3, 1, 2],
                    [6, 3, -1, 2, 5],
                    [4, 2, -4, 7, 8],
                    [2, 1, 2, 4, 2],
                ],
            ],
            [
                [
                    [2, 3, -4, 1, 3],
                    [6, 1, -3, 1, 2],
                    [6, 3, -1, 2, 5],
                    [4, 2, -4, 7, 8],
                    [2, 1, -2, 4, 2],
                ],
            ],
            [
                [
                    [2, 3, -4, -1, 3],
                    [6, 1, -3, 1, 2],
                    [6, 3, -1, 2, 5],
                    [4, 2, -4, 7, 8],
                    [2, 1, -2, 4, 2],
                ],
            ],
            [
                [
                    [2, 3, -4, -1, -3],
                    [6, 1, -3, -1, 2],
                    [6, 3, -1, 2, 5],
                    [4, 2, -4, 7, -8],
                    [2, 1, -2, 4, 2],
                ],
            ],
            [
                [
                    [2, 1, 2],
                    [1, 1, 1],
                    [2, 2, 5],
                ],
            ],
            [
                [
                    [1, 0, 2, -1],
                    [3, 0, 0, 5],
                    [2, 1, 4, -3],
                    [1, 0, 5, 0],
                ],
            ],
            [
                [
                    [1, 0, 2, 0, 0, 4],
                    [18, 1, 5, 0, 0, 9],
                    [3, 5, 3, 6, 0, 4],
                    [2, 0, 8, 0, 0, 7],
                    [7, 0, 4, 0, 6, 0],
                    [0, 0, 1, 0, 0, 0]
                ],
            ],
            [
                [
                    [-1, 0, 2, 0, 0, 4],
                    [18, 1, 5, 0, 0, 9],
                    [3, 5, 3, 6, 0, 4],
                    [2, 0, 8, 0, 0, 7],
                    [7, 0, 4, 0, 6, 0],
                    [0, 0, 1, 0, 0, 0]
                ],
            ],
            [
                [
                    [-1, 0, -2, 0, 0, 4],
                    [18, 1, 5, 0, 0, 9],
                    [3, 5, 3, 6, 0, 4],
                    [2, 0, 8, 0, 0, 7],
                    [7, 0, 4, 0, 6, 0],
                    [0, 0, 1, 0, 0, 0]
                ],
            ],
            [
                [
                    [-1, 0, -2, 0, 0, -4],
                    [18, 1, 5, 0, 0, 9],
                    [3, 5, 3, 6, 0, 4],
                    [2, 0, 8, 0, 0, 7],
                    [7, 0, 4, 0, 6, 0],
                    [0, 0, 1, 0, 0, 0]
                ],
            ],
            [
                [
                    [1, 1, 1, 1, 1,  1],
                    [1, 3, 1, 3, 1,  3],
                    [1, 1, 4, 1, 1,  4],
                    [1, 3, 1, 7, 1,  3],
                    [1, 1, 1, 1, 6,  1],
                    [1, 3, 4, 3, 1, 12]
                ],
            ],
            [
                [
                    [-1, 1, 1, 1, 1, 1],
                    [1, 3, 1, 3, 1,  3],
                    [1, 1, 4, 1, 1,  4],
                    [1, 3, 1, 7, 1,  3],
                    [1, 1, 1, 1, 6,  1],
                    [1, 3, 4, 3, 1, 12]
                ],
            ],
            [
                [
                    [-1, 1, 1, 1, 1, 1],
                    [1, 3, 1, 3, 1,  3],
                    [1, 1, 4, 1, 1,  4],
                    [1, -3, 1, 7, 1, 3],
                    [1, 1, 1, 1, 6,  1],
                    [1, 3, 4, 3, 1, 12]
                ],
            ],
            [
                [
                    [1, 0, 0, 0, 0, 0],
                    [0, 2, 0, 0, 0, 0],
                    [0, 0, 3, 0, 0, 0],
                    [0, 0, 0, 4, 0, 0],
                    [0, 0, 0, 0, 5, 0],
                    [0, 0, 0, 0, 0, 6]
                ],
            ],
            [
                [
                    [-1, 0, 0, 0, 0, 0],
                    [0, 2, 0, 0, 0, 0],
                    [0, 0, 3, 0, 0, 0],
                    [0, 0, 0, 4, 0, 0],
                    [0, 0, 0, 0, 5, 0],
                    [0, 0, 0, 0, 0, 6]
                ],
            ],
            [
                [
                    [-1, 0, 0, 0, 0, 0],
                    [0, 2, 0, 0, 0, 0],
                    [0, 0, 0, 4, 0, 0],
                    [0, 0, 3, 0, 0, 0],
                    [0, 0, 0, 0, 5, 0],
                    [0, 0, 0, 0, 0, 6]
                ],
            ],
            [
                [
                    [1, 0, 0, 0, 0, 0],
                    [1, 2, 0, 0, 0, 0],
                    [1, 0, 3, 0, 0, 0],
                    [1, 2, 0, 4, 0, 0],
                    [1, 0, 0, 0, 5, 0],
                    [1, 2, 3, 0, 0, 6],
                ],
            ],
            [
                [
                    [0, 1, 4, 3, 2, 3, 3, 4, 4],
                    [1, 0, 3, 2, 1, 2, 2, 3, 3],
                    [4, 3, 0, 1, 2, 3, 3, 4, 4],
                    [3, 2, 1, 0, 1, 2, 2, 3, 3],
                    [2, 1, 2, 1, 0, 1, 1, 2, 2],
                    [3, 2, 3, 2, 1, 0, 2, 3, 3],
                    [3, 2, 3, 2, 1, 2, 0, 1, 2],
                    [4, 3, 4, 3, 2, 3, 1, 0, 2],
                    [4, 3, 4, 3, 2, 3, 2, 2, 0],
                ],
            ],
            [
                [
                    [2, 1, 4, 3, 2, 3, 3, 4, 4],
                    [1, 2, 3, 2, 1, 2, 2, 3, 3],
                    [4, 3, 2, 1, 2, 3, 3, 4, 4],
                    [3, 2, 1, 2, 1, 2, 2, 3, 3],
                    [2, 1, 2, 1, 2, 1, 1, 2, 2],
                    [3, 2, 3, 2, 1, 2, 2, 3, 3],
                    [3, 2, 3, 2, 1, 2, 2, 1, 2],
                    [4, 3, 4, 3, 2, 3, 1, 2, 2],
                    [4, 3, 4, 3, 2, 3, 2, 2, 2],
                ],
            ],
            [
                [
                    [2, -1, 4, 3, 2, 3, 3, 4, 4],
                    [1, 2, 3, 2, 1, 2, 2, 3, 3],
                    [4, 3, 2, 1, 2, 3, 3, 4, 4],
                    [3, 2, 1, 2, 1, 2, 2, 3, 3],
                    [2, 1, 2, 1, 2, 1, 1, 2, 2],
                    [3, 2, 3, 2, 1, 2, 2, 3, 3],
                    [3, 2, 3, 2, 1, 2, 2, 1, 2],
                    [4, 3, 4, 3, 2, 3, 1, 2, 2],
                    [4, 3, 4, 3, 2, 3, 2, 2, 2],
                ],
            ],
            [
                [
                    [2, 1, 4, 3, 2, 3, 3, 4, 4],
                    [-1, 2, 3, 2, 1, 2, 2, 3, 3],
                    [4, 3, 2, 1, 2, 3, 3, 4, 4],
                    [3, 2, 1, 2, 1, 2, 2, 3, 3],
                    [2, 1, 2, 1, 2, 1, 1, 2, 2],
                    [3, 2, 3, 2, 1, 2, 2, 3, 3],
                    [3, 2, 3, 2, 1, 2, 2, 1, 2],
                    [4, 3, 4, 3, 2, 3, 1, 2, 2],
                    [4, 3, 4, 3, 2, 3, 2, 2, 2],
                ],
            ],
            [
                [
                    [2, -1, 4, 3, 2, 3, 3, 4, 4],
                    [-1, 2, 3, 2, 1, 2, 2, 3, 3],
                    [4, 3, 2, 1, 2, 3, 3, 4, 4],
                    [3, 2, 1, 2, 1, 2, 2, 3, 3],
                    [2, 1, 2, 1, 2, 1, 1, 2, 2],
                    [3, 2, 3, 2, 1, 2, 2, 3, 3],
                    [3, 2, 3, 2, 1, 2, 2, 1, 2],
                    [4, 3, 4, 3, 2, 3, 1, 2, 2],
                    [4, 3, 4, 3, 2, 3, 2, 2, 2],
                ],
            ],
            [
                [
                    [2, -1, 4, 3, 2, 3, 3, 4, 4],
                    [-1, 2, 3, 2, 1, 2, 2, 3, 3],
                    [4, 3, 2, 1, 2, 3, 3, 4, 4],
                    [2, 1, 2, 1, 2, 1, 1, 2, 2],
                    [3, 2, 1, 2, 1, 2, 2, 3, 3],
                    [3, 2, 3, 2, 1, 2, 2, 3, 3],
                    [3, 2, 3, 2, 1, 2, 2, 1, 2],
                    [4, 3, 4, 3, 2, 3, 1, 2, 2],
                    [4, 3, 4, 3, 2, 3, 2, 2, 2],
                ],
            ],
        ];
    }

    public function dataProviderForTwoNonsingularMatrices()
    {
        return [
            [
                [
                    [0, 1],
                    [1, 0],
                ],
                [
                    [0, 1],
                    [1, 1],
                ]
            ],
            [
                [
                    [1, 0],
                    [0, 1],
                ],
                [
                    [1, 0],
                    [1, 1],
                ]
            ],
            [
                [
                    [1, 1],
                    [0, 1],
                ],
                [
                    [1, 1],
                    [1, 0],
                ]
            ],
            [
                [
                    [-7, -6, -12],
                    [5, 5, 7],
                    [1, 0, 4],
                ],
                [
                    [1, 0, 0],
                    [0, 1, 0],
                    [0, 0, 1],
                ],
            ],
            [
                [
                    [3, 8],
                    [4, 6],
                ],
                [
                    [4, 3],
                    [3, 2],
                ],
            ],
            [
                [
                    [6, 1, 1],
                    [4, -2, 5],
                    [2, 8, 7],
                ],
                [
                    [1, 2, 0],
                    [-1, 1, 1],
                    [1, 2, 3],
                ],
            ],
            [
                [
                    [4, 6, 3, 2],
                    [3, 6, 5, 3],
                    [5, 7, 8, 6],
                    [5, 4, 3, 2],
                ],
                [
                    [3, 2, 0, 1],
                    [4, 0, 1, 2],
                    [3, 0, 2, 1],
                    [9, 2, 3, 1],
                ],
            ],
            [
                [
                    [1, 2, 3, 4],
                    [5, 6, 7, 8],
                    [2, 6, 4, 8],
                    [3, 1, 1, 2],
                ],
                [
                    [7, 4, 2, 0],
                    [6, 3, -1, 2],
                    [4, 6, 2, 5],
                    [8, 2, -7, 1],
                ],
            ],
            [
                [
                  [-4, 3, 1, 5, -8],
                  [6, 0, 9, 2, 6],
                  [-1, 4, 4, 0, 2],
                  [8, -1, 3, 4, 0],
                  [5, 9, -7, -7, 1]
                ],
                [
                  [4, 3, 1, 5, -8],
                  [6, 0, 9, 2, 6],
                  [-1, 4, 4, 0, 2],
                  [8, -1, 3, 4, 0],
                  [5, 9, -7, -7, 1]
                ],
            ],
            [
                [
                  [4, 3, 1, 5, 8],
                  [6, 0, 9, 2, 6],
                  [-1, 4, 4, 0, 2],
                  [8, -1, 3, 4, 0],
                  [5, 9, -7, -7, 1]
                ],
                [
                  [4, 3, 1, 5, 8],
                  [6, 0, 9, 2, 6],
                  [1, 4, 4, 0, 2],
                  [8, -1, 3, 4, 0],
                  [5, 9, -7, -7, 1]
                ],
            ],
            [
                [
                  [4, 3, 1, 5, 8],
                  [6, 0, 9, 2, 6],
                  [1, 4, 4, 0, 2],
                  [8, 1, 3, 4, 0],
                  [5, 9, -7, -7, 1]
                ],
                [
                  [4, 3, 1, 5, 8],
                  [6, 0, 9, 2, 6],
                  [1, 4, 4, 0, 2],
                  [8, 1, 3, 4, 0],
                  [5, 9, 7, -7, 1]
                ],
            ],
            [
                [
                  [4, 3, 1, 5, 8],
                  [6, 0, 9, 2, 6],
                  [1, 4, 4, 0, 2],
                  [8, 1, 3, 4, 0],
                  [5, 9, 7, 7, 1]
                ],
                [
                    [5, 2, 0, 0, -2],
                    [0, 1, 4, 3, 2],
                    [0, 0, 2, 6, 3],
                    [0, 0, 3, 4, 1],
                    [0, 0, 0, 0, 2],
                ],
            ],
            [
                [
                    [5, 2, 0, 0, 2],
                    [0, 1, 4, 3, 2],
                    [0, 0, 2, 6, 3],
                    [0, 0, 3, 4, 1],
                    [0, 0, 0, 0, 2],
                ],
                [
                    [5, 2, 0, 0, -2],
                    [0, -1, 4, 3, 2],
                    [0, 0, 2, 6, 3],
                    [0, 0, 3, 4, 1],
                    [0, 0, 0, 0, 2],
                ],
            ],
            [
                [
                    [2, -9, 1, 8, 4],
                    [-10, -1, 2, 7, 0],
                    [0, 4, -6, 1, -8],
                    [6, -14, 11, 0, 3],
                    [5, 1, -3, 2, -1],
                ],
                [
                    [2, 9, 1, 8, 4],
                    [-10, -1, 2, 7, 0],
                    [0, 4, -6, 1, -8],
                    [6, -14, 11, 0, 3],
                    [5, 1, -3, 2, -1],
                ],
            ],
            [
                [
                    [2, 9, 1, 8, 4],
                    [10, -1, 2, 7, 0],
                    [0, 4, -6, 1, -8],
                    [6, -14, 11, 0, 3],
                    [5, 1, -3, 2, -1],
                ],
                [
                    [2, 9, 1, 8, 4],
                    [10, 1, 2, 7, 0],
                    [0, 4, -6, 1, -8],
                    [6, -14, 11, 0, 3],
                    [5, 1, -3, 2, -1],
                ],
            ],
            [
                [
                    [50,1,44,23, 32],
                    [0, 0, 78, 0, 0],
                    [0, 0, -1, 0, 1],
                    [0, 0, 5, -1, 5],
                    [1, 0, 5, 5, -34],
                ],
                [
                    [2,1,4,1, 5],
                    [0, 0, 4, 0, 0],
                    [0, 0, 1, 0, 1],
                    [0, 0, 4, -1, 2],
                    [1, 0, 6, 4, -3],
                ],
            ],
            [
                [
                    [276,1,179,23, 23],
                    [0, 0, 78, 0, 0],
                    [0, 0, 1, 0, 1],
                    [0, 0, 77, 1, 87],
                    [1, 0, 212, 54, -74],
                ],
                [
                    [1,1,1,1, 1],
                    [0, 0, 3, 0, 0],
                    [0, 0, 1, 0, 1],
                    [0, 0, 2, 1, 2],
                    [1, 0, 4, 4, 5],
                ],
            ],
            [
                [
                    [10,1,5,23, -8],
                    [0, 0, 78, 0, 0],
                    [0, 0, 1, 0, 1],
                    [0, 0, 4, 1, 7],
                    [1, 0, 4, 6, 6],
                ],
                [
                    [1, 0, 3, 5, 1],
                    [0, 1, 2, 1, 0],
                    [0, 4, 0, 0, 2],
                    [2, 3, 1, 2, 0],
                    [1, 0, 0, 1, 1],
                ],
            ],
            [
                [
                    [2, 3, 4, 1, 3],
                    [6, 1, 3, 1, 2],
                    [6, 3, 1, 2, 5],
                    [4, 2, 4, 7, 8],
                    [2, 1, 2, 4, 2],
                ],
                [
                    [2, 3, -4, 1, 3],
                    [6, 1, 3, 1, 2],
                    [6, 3, 1, 2, 5],
                    [4, 2, 4, 7, 8],
                    [2, 1, 2, 4, 2],
                ],
            ],
            [
                [
                    [2, 3, -4, 1, 3],
                    [6, 1, -3, 1, 2],
                    [6, 3, 1, 2, 5],
                    [4, 2, 4, 7, 8],
                    [2, 1, 2, 4, 2],
                ],
                [
                    [2, 3, -4, 1, 3],
                    [6, 1, -3, 1, 2],
                    [6, 3, -1, 2, 5],
                    [4, 2, 4, 7, 8],
                    [2, 1, 2, 4, 2],
                ],
            ],
            [
                [
                    [2, 3, -4, 1, 3],
                    [6, 1, -3, 1, 2],
                    [6, 3, -1, 2, 5],
                    [4, 2, -4, 7, 8],
                    [2, 1, 2, 4, 2],
                ],
                [
                    [2, 3, -4, 1, 3],
                    [6, 1, -3, 1, 2],
                    [6, 3, -1, 2, 5],
                    [4, 2, -4, 7, 8],
                    [2, 1, -2, 4, 2],
                ],
            ],
            [
                [
                    [2, 3, -4, -1, 3],
                    [6, 1, -3, 1, 2],
                    [6, 3, -1, 2, 5],
                    [4, 2, -4, 7, 8],
                    [2, 1, -2, 4, 2],
                ],
                [
                    [2, 3, -4, -1, -3],
                    [6, 1, -3, -1, 2],
                    [6, 3, -1, 2, 5],
                    [4, 2, -4, 7, -8],
                    [2, 1, -2, 4, 2],
                ],
            ],
            [
                [
                    [1, 0, 2, 0, 0, 4],
                    [18, 1, 5, 0, 0, 9],
                    [3, 5, 3, 6, 0, 4],
                    [2, 0, 8, 0, 0, 7],
                    [7, 0, 4, 0, 6, 0],
                    [0, 0, 1, 0, 0, 0]
                ],
                [
                    [-1, 0, 2, 0, 0, 4],
                    [18, 1, 5, 0, 0, 9],
                    [3, 5, 3, 6, 0, 4],
                    [2, 0, 8, 0, 0, 7],
                    [7, 0, 4, 0, 6, 0],
                    [0, 0, 1, 0, 0, 0]
                ],
            ],
            [
                [
                    [-1, 0, -2, 0, 0, 4],
                    [18, 1, 5, 0, 0, 9],
                    [3, 5, 3, 6, 0, 4],
                    [2, 0, 8, 0, 0, 7],
                    [7, 0, 4, 0, 6, 0],
                    [0, 0, 1, 0, 0, 0]
                ],
                [
                    [1, 1, 1, 1, 1,  1],
                    [1, 3, 1, 3, 1,  3],
                    [1, 1, 4, 1, 1,  4],
                    [1, 3, 1, 7, 1,  3],
                    [1, 1, 1, 1, 6,  1],
                    [1, 3, 4, 3, 1, 12]
                ],
            ],
            [
                [
                    [-1, 0, -2, 0, 0, -4],
                    [18, 1, 5, 0, 0, 9],
                    [3, 5, 3, 6, 0, 4],
                    [2, 0, 8, 0, 0, 7],
                    [7, 0, 4, 0, 6, 0],
                    [0, 0, 1, 0, 0, 0]
                ],
                [
                    [-1, 1, 1, 1, 1, 1],
                    [1, 3, 1, 3, 1,  3],
                    [1, 1, 4, 1, 1,  4],
                    [1, 3, 1, 7, 1,  3],
                    [1, 1, 1, 1, 6,  1],
                    [1, 3, 4, 3, 1, 12]
                ],
            ],
            [
                [
                    [-1, 1, 1, 1, 1, 1],
                    [1, 3, 1, 3, 1,  3],
                    [1, 1, 4, 1, 1,  4],
                    [1, -3, 1, 7, 1, 3],
                    [1, 1, 1, 1, 6,  1],
                    [1, 3, 4, 3, 1, 12]
                ],
                [
                    [1, 0, 0, 0, 0, 0],
                    [0, 2, 0, 0, 0, 0],
                    [0, 0, 3, 0, 0, 0],
                    [0, 0, 0, 4, 0, 0],
                    [0, 0, 0, 0, 5, 0],
                    [0, 0, 0, 0, 0, 6]
                ],
            ],
            [
                [
                    [-1, 0, 0, 0, 0, 0],
                    [0, 2, 0, 0, 0, 0],
                    [0, 0, 3, 0, 0, 0],
                    [0, 0, 0, 4, 0, 0],
                    [0, 0, 0, 0, 5, 0],
                    [0, 0, 0, 0, 0, 6]
                ],
                [
                    [-1, 0, 0, 0, 0, 0],
                    [0, 2, 0, 0, 0, 0],
                    [0, 0, 0, 4, 0, 0],
                    [0, 0, 3, 0, 0, 0],
                    [0, 0, 0, 0, 5, 0],
                    [0, 0, 0, 0, 0, 6]
                ],
            ],
            [
                [
                    [0, 1, 4, 3, 2, 3, 3, 4, 4],
                    [1, 0, 3, 2, 1, 2, 2, 3, 3],
                    [4, 3, 0, 1, 2, 3, 3, 4, 4],
                    [3, 2, 1, 0, 1, 2, 2, 3, 3],
                    [2, 1, 2, 1, 0, 1, 1, 2, 2],
                    [3, 2, 3, 2, 1, 0, 2, 3, 3],
                    [3, 2, 3, 2, 1, 2, 0, 1, 2],
                    [4, 3, 4, 3, 2, 3, 1, 0, 2],
                    [4, 3, 4, 3, 2, 3, 2, 2, 0],
                ],
                [
                    [2, 1, 4, 3, 2, 3, 3, 4, 4],
                    [1, 2, 3, 2, 1, 2, 2, 3, 3],
                    [4, 3, 2, 1, 2, 3, 3, 4, 4],
                    [3, 2, 1, 2, 1, 2, 2, 3, 3],
                    [2, 1, 2, 1, 2, 1, 1, 2, 2],
                    [3, 2, 3, 2, 1, 2, 2, 3, 3],
                    [3, 2, 3, 2, 1, 2, 2, 1, 2],
                    [4, 3, 4, 3, 2, 3, 1, 2, 2],
                    [4, 3, 4, 3, 2, 3, 2, 2, 2],
                ],
            ],
            [
                [
                    [2, -1, 4, 3, 2, 3, 3, 4, 4],
                    [1, 2, 3, 2, 1, 2, 2, 3, 3],
                    [4, 3, 2, 1, 2, 3, 3, 4, 4],
                    [3, 2, 1, 2, 1, 2, 2, 3, 3],
                    [2, 1, 2, 1, 2, 1, 1, 2, 2],
                    [3, 2, 3, 2, 1, 2, 2, 3, 3],
                    [3, 2, 3, 2, 1, 2, 2, 1, 2],
                    [4, 3, 4, 3, 2, 3, 1, 2, 2],
                    [4, 3, 4, 3, 2, 3, 2, 2, 2],
                ],
                [
                    [2, 1, 4, 3, 2, 3, 3, 4, 4],
                    [-1, 2, 3, 2, 1, 2, 2, 3, 3],
                    [4, 3, 2, 1, 2, 3, 3, 4, 4],
                    [3, 2, 1, 2, 1, 2, 2, 3, 3],
                    [2, 1, 2, 1, 2, 1, 1, 2, 2],
                    [3, 2, 3, 2, 1, 2, 2, 3, 3],
                    [3, 2, 3, 2, 1, 2, 2, 1, 2],
                    [4, 3, 4, 3, 2, 3, 1, 2, 2],
                    [4, 3, 4, 3, 2, 3, 2, 2, 2],
                ],
            ],
            [
                [
                    [2, -1, 4, 3, 2, 3, 3, 4, 4],
                    [-1, 2, 3, 2, 1, 2, 2, 3, 3],
                    [4, 3, 2, 1, 2, 3, 3, 4, 4],
                    [3, 2, 1, 2, 1, 2, 2, 3, 3],
                    [2, 1, 2, 1, 2, 1, 1, 2, 2],
                    [3, 2, 3, 2, 1, 2, 2, 3, 3],
                    [3, 2, 3, 2, 1, 2, 2, 1, 2],
                    [4, 3, 4, 3, 2, 3, 1, 2, 2],
                    [4, 3, 4, 3, 2, 3, 2, 2, 2],
                ],
                [
                    [2, -1, 4, 3, 2, 3, 3, 4, 4],
                    [-1, 2, 3, 2, 1, 2, 2, 3, 3],
                    [4, 3, 2, 1, 2, 3, 3, 4, 4],
                    [2, 1, 2, 1, 2, 1, 1, 2, 2],
                    [3, 2, 1, 2, 1, 2, 2, 3, 3],
                    [3, 2, 3, 2, 1, 2, 2, 3, 3],
                    [3, 2, 3, 2, 1, 2, 2, 1, 2],
                    [4, 3, 4, 3, 2, 3, 1, 2, 2],
                    [4, 3, 4, 3, 2, 3, 2, 2, 2],
                ],
            ],
        ];
    }

    public function dataProviderForPositiveDefiniteMatrix()
    {
        return [
            [
                [
                    [2, -1],
                    [-1, 2],
                ],
            ],
            [
                [
                    [1, -1],
                    [-1, 4],
                ],
            ],
            [
                [
                    [5, 2],
                    [2, 3],
                ],
            ],
            [
                [
                    [6, 4],
                    [4, 5],
                ],
            ],
            [
                [
                    [12, -12],
                    [-12, 96],
                ],
            ],
            [
                [
                    [2, -1, 0],
                    [-1, 2, -1],
                    [0, -1, 2],
                ],
            ],
            [
                [
                    [2, -1, 1],
                    [-1, 2, -1],
                    [1, -1, 2],
                ],
            ],
            [
                [
                    [1, 0, 0],
                    [0, 3, 0],
                    [0, 0, 2],
                ],
            ],
            [
                [
                    [3, -2, 0],
                    [-2, 2, 0],
                    [0, 0, 2],
                ],
            ],
            [
                [
                    [4, 1, -1],
                    [1, 2, 1],
                    [-1, 1, 2],
                ],
            ],
            [
                [
                    [9, -3, 3, 9],
                    [-3, 17, -1, -7],
                    [3, -1, 17, 15],
                    [9, -7, 15, 44],
                ],
            ],
            [
                [
                    [14, 4, 9],
                    [4, 14, -7],
                    [9, -7, 14],
                ],
            ],
            [
                [
                    [13, 0, -3],
                    [0, 9, 9],
                    [-3, 9, 10],
                ],
            ],
            [
                [
                    [14, -7, -13],
                    [-7, 6, 5],
                    [-13, 5, 14],
                ],
            ],
        ];
    }

    public function dataProviderForNotPositiveDefiniteMatrix()
    {
        return [
            // Not square
            [
                [
                    [1, 2, 3],
                    [2, 3, 4],
                ],
            ],
            [
                [
                    [1, 2],
                    [2, 3],
                    [3, 4],
                ],
            ],
            // Not symmetric
            [
                [
                    [2, -1, 1],
                    [-1, 2, -1],
                    [2, -1, 2],
                ],
            ],
            [
                [
                    [2, -1, 1],
                    [-4, 2, -1],
                    [1, -1, 2],
                ],
            ],
            [
                [
                    [9, -13, 3, 9],
                    [-3, 17, -1, -7],
                    [3, -1, 17, 15],
                    [9, -7, 15, 44],
                ],
            ],
            // Square and symmetric but fails determinate test
            [
                [
                    [0, 0],
                    [0, 0],
                ],
            ],
            [
                [
                    [1, 4],
                    [4, 1],
                ]
            ],
            [
                [
                    [-1, 0],
                    [0, -3],
                ],
            ],
        ];
    }

    public function dataProviderForPositiveSemidefiniteMatrix()
    {
        return [
            [
                [
                    [0, 0],
                    [0, 0],
                ],
            ],
            [
                [
                    [1, 0],
                    [0, 1],
                ],
            ],
            [
                [
                    [1, 0],
                    [0, 2],
                ],
            ],
            [
                [
                    [1, 1],
                    [1, 1],
                ],
            ],
            [
                [
                    [2, -1],
                    [-1, 2],
                ],
            ],
            [
                [
                    [0, 0, 0],
                    [0, 3, 0],
                    [0, 0, 3],
                ],
            ],
            [
                [
                    [2, -1, -1],
                    [-1, 2, -1],
                    [-1, -1, 2],
                ],
            ],
            [
                [
                    [2, -1, 0],
                    [-1, 2, -1],
                    [0, -1, 2],
                ],
            ],
            [
                [
                    [2, -1, 1],
                    [-1, 2, -1],
                    [1, -1, 2],
                ],
            ],
            [
                [
                    [2, -1, 2],
                    [-1, 2, -1],
                    [2, -1, 2],
                ],
            ],
            [
                [
                    [9, -3, 3, 9],
                    [-3, 17, -1, -7],
                    [3, -1, 17, 15],
                    [9, -7, 15, 44],
                ],
            ],
        ];
    }

    public function dataProviderForNotPositiveSemidefiniteMatrix()
    {
        return [
            // Square and symmetric but fails determinate test
            [
                [
                    [0, -4],
                    [-4, 0],
                ],
            ],
            [
                [
                    [1, 4],
                    [4, 1],
                ]
            ],
            [
                [
                    [-1, 0],
                    [0, -3],
                ],
            ],
        ];
    }

    public function dataProviderForNegativeDefiniteMatrix()
    {
        return [
            [
                [
                    [-1, 1],
                    [1, -2],
                ],
            ],
            [
                [
                    [-3, 0, 0],
                    [0, -2, 0],
                    [0, 0, -1],
                ],
            ],
        ];
    }

    public function dataProviderForNotNegativeDefiniteMatrix()
    {
        return [
            // Square and symmetric but fails determinate test
            [
                [
                    [0, -4],
                    [-4, 0],
                ],
            ],
            [
                [
                    [1, 4],
                    [4, 1],
                ]
            ],
            [
                [
                    [1, 0],
                    [0, -3],
                ],
            ],
            [
                [
                    [-1, 4],
                    [4, -1],
                ]
            ],
        ];
    }

    public function dataProviderForNegativeSemidefiniteMatrix()
    {
        return [
            [
                [
                    [0, 0],
                    [0, 0],
                ],
            ],
            [
                [
                    [0, 0],
                    [0, -1],
                ],
            ],
            [
                [
                    [-1, -1],
                    [-1, -1],
                ],
            ],
        ];
    }

    public function dataProviderForNotNegativeSemidefiniteMatrix()
    {
        return [
            // Square and symmetric but fails determinate test
            [
                [
                    [0, -4],
                    [-4, 0],
                ],
            ],
            [
                [
                    [1, 4],
                    [4, 1],
                ]
            ],
            [
                [
                    [1, 0],
                    [0, -3],
                ],
            ],
        ];
    }

    public function dataProviderForUpperTriangularMatrix()
    {
        return [
            [
                [
                    [1],
                ],
            ],
            [
                [
                    [0],
                ],
            ],
            [
                [
                    [1, 1],
                    [0, 1],
                ]
            ],
            [
                [
                    [1, 2],
                    [0, 4],
                ],
            ],
            [
                [
                    [1, 1, 1],
                    [0, 1, 1],
                    [0, 0, 1],
                ],
            ],
            [
                [
                    [1, 0, 0],
                    [0, 1, 0],
                    [0, 0, 1],
                ],
            ],
            [
                [
                    [0, 0, 0],
                    [0, 0, 0],
                    [0, 0, 0],
                ],
            ],
            [
                [
                    [1, 2, 3],
                    [0, 4, 5],
                    [0, 0, 6],
                ],
            ],
            [
                [
                    [6, 5, 4],
                    [0, 8, 8],
                    [0, 0, 9],
                ],
            ],
            [
                [
                    [6, 5, 4],
                    [0, 8, 8],
                    [0, 0, 0],
                ],
            ],
            [
                [
                    [1, 2, 3, 4],
                    [0, 4, 5, 6],
                    [0, 0, 6, 7],
                    [0, 0, 0, 8],
                ],
            ],
            [
                [
                    [-1, 0, 0, 0, 0, 0],
                    [0, 2, 0, 0, 0, 0],
                    [0, 0, 3, 0, 0, 0],
                    [0, 0, 0, 4, 0, 0],
                    [0, 0, 0, 0, 5, 0],
                    [0, 0, 0, 0, 0, 6],
                ],
            ],
            [
                [
                    [1, 0, 0, 0, 0, 0],
                    [0, 2, 0, 0, 0, 0],
                    [0, 0, 3, 0, 0, 0],
                    [0, 0, 0, 4, 0, 0],
                    [0, 0, 0, 0, 5, 0],
                    [0, 0, 0, 0, 0, 6],
                ],
            ],
            [
                [
                    [1, 0, 0, 0, 0, 0],
                    [0, 2, 0, 0, 0, 0],
                    [0, 0, 0, 0, 0, 0],
                    [0, 0, 0, 0, 0, 0],
                    [0, 0, 0, 0, 5, 0],
                    [0, 0, 0, 0, 0, 6],
                ],
            ],
        ];
    }

    public function dataProviderForNotTriangularMatrix()
    {
        return [
            [
                [
                    [0, 1],
                    [1, 0],
                ]
            ],
            [
                [
                    [0, 1],
                    [1, 1],
                ]
            ],
            [
                [
                    [1, 8],
                    [1, 1],
                ]
            ],
            [
                [
                    [1, 1],
                    [1, 0],
                ]
            ],
            [
                [
                    [1, 2, 3],
                    [2, 3, 4],
                ],
            ],
            [
                [
                    [-7, -6, -12],
                    [5, 5, 7],
                    [1, 0, 4],
                ],
            ],
            [
                [
                    [3, 8],
                    [4, 6],
                ],
            ],
            [
                [
                    [4, 3],
                    [3, 2],
                ],
            ],
            [
                [
                    [6, 1, 1],
                    [4, -2, 5],
                    [2, 8, 7],
                ],
            ],
            [
                [
                    [1, 2, 0],
                    [-1, 1, 1],
                    [1, 2, 3],
                ],
            ],
            [
                [
                    [4, 6, 3, 2],
                    [3, 6, 5, 3],
                    [5, 7, 8, 6],
                    [5, 4, 3, 2],
                ],
            ],
            [
                [
                    [3, 2, 0, 1],
                    [4, 0, 1, 2],
                    [3, 0, 2, 1],
                    [9, 2, 3, 1],
                ],
            ],
            [
                [
                    [1, 2, 3, 4],
                    [5, 6, 7, 8],
                    [2, 6, 4, 8],
                    [3, 1, 1, 2],
                ],
            ],
            [
                [
                    [7, 4, 2, 0],
                    [6, 3, -1, 2],
                    [4, 6, 2, 5],
                    [8, 2, -7, 1],
                ],
            ],
            [
                [
                  [-4, 3, 1, 5, -8],
                  [6, 0, 9, 2, 6],
                  [-1, 4, 4, 0, 2],
                  [8, -1, 3, 4, 0],
                  [5, 9, -7, -7, 1]
                ],
            ],
            [
                [
                  [4, 3, 1, 5, -8],
                  [6, 0, 9, 2, 6],
                  [-1, 4, 4, 0, 2],
                  [8, -1, 3, 4, 0],
                  [5, 9, -7, -7, 1]
                ],
            ],
            [
                [
                  [4, 3, 1, 5, 8],
                  [6, 0, 9, 2, 6],
                  [-1, 4, 4, 0, 2],
                  [8, -1, 3, 4, 0],
                  [5, 9, -7, -7, 1]
                ],

            ],
            [
                [
                  [4, 3, 1, 5, 8],
                  [6, 0, 9, 2, 6],
                  [1, 4, 4, 0, 2],
                  [8, -1, 3, 4, 0],
                  [5, 9, -7, -7, 1]
                ],
            ],
            [
                [
                  [4, 3, 1, 5, 8],
                  [6, 0, 9, 2, 6],
                  [1, 4, 4, 0, 2],
                  [8, 1, 3, 4, 0],
                  [5, 9, -7, -7, 1]
                ],
            ],
            [
                [
                  [4, 3, 1, 5, 8],
                  [6, 0, 9, 2, 6],
                  [1, 4, 4, 0, 2],
                  [8, 1, 3, 4, 0],
                  [5, 9, 7, -7, 1]
                ],
            ],
            [
                [
                  [4, 3, 1, 5, 8],
                  [6, 0, 9, 2, 6],
                  [1, 4, 4, 0, 2],
                  [8, 1, 3, 4, 0],
                  [5, 9, 7, 7, 1]
                ],
            ],
            [
                [
                    [5, 2, 0, 0, -2],
                    [0, 1, 4, 3, 2],
                    [0, 0, 2, 6, 3],
                    [0, 0, 3, 4, 1],
                    [0, 0, 0, 0, 2],
                ],
            ],
            [
                [
                    [5, 2, 0, 0, 2],
                    [0, 1, 4, 3, 2],
                    [0, 0, 2, 6, 3],
                    [0, 0, 3, 4, 1],
                    [0, 0, 0, 0, 2],
                ],
            ],
            [
                [
                    [5, 2, 0, 0, -2],
                    [0, -1, 4, 3, 2],
                    [0, 0, 2, 6, 3],
                    [0, 0, 3, 4, 1],
                    [0, 0, 0, 0, 2],
                ],
            ],
            [
                [
                    [2, -9, 1, 8, 4],
                    [-10, -1, 2, 7, 0],
                    [0, 4, -6, 1, -8],
                    [6, -14, 11, 0, 3],
                    [5, 1, -3, 2, -1],
                ],
            ],
            [
                [
                    [2, 9, 1, 8, 4],
                    [-10, -1, 2, 7, 0],
                    [0, 4, -6, 1, -8],
                    [6, -14, 11, 0, 3],
                    [5, 1, -3, 2, -1],
                ],
            ],
            [
                [
                    [2, 9, 1, 8, 4],
                    [10, -1, 2, 7, 0],
                    [0, 4, -6, 1, -8],
                    [6, -14, 11, 0, 3],
                    [5, 1, -3, 2, -1],
                ],
            ],
            [
                [
                    [2, 9, 1, 8, 4],
                    [10, 1, 2, 7, 0],
                    [0, 4, -6, 1, -8],
                    [6, -14, 11, 0, 3],
                    [5, 1, -3, 2, -1],
                ],
            ],
            [
                [
                    [276,1,179,23, 9387],
                    [0, 0, 78, 0, 0],
                    [0, 0, -1, 0, 1],
                    [0, 0, 1994, -1, 1089],
                    [1, 0, 212, 726, -378],
                ],
            ],
            [
                [
                    [276,1,179,23, 9387],
                    [0, 0, 78, 0, 0],
                    [0, 0, 1, 0, 1],
                    [0, 0, 1994, -1, 1089],
                    [1, 0, 212, 726, -378],
                ],
            ],
            [
                [
                    [276,1,179,23, 9387],
                    [0, 0, 78, 0, 0],
                    [0, 0, 1, 0, 1],
                    [0, 0, 1994, 1, 1089],
                    [1, 0, 212, 726, -378],
                ],
            ],
            [
                [
                    [276,1,179,23, 9387],
                    [0, 0, 78, 0, 0],
                    [0, 0, 1, 0, 1],
                    [0, 0, 1994, 1, 1089],
                    [1, 0, 212, 726, 378],
                ],
            ],
            [
                [
                    [276,1,179,23, -9387],
                    [0, 0, 78, 0, 0],
                    [0, 0, 1, 0, 1],
                    [0, 0, 1994, 1, 1089],
                    [1, 0, 212, 726, 378],
                ],
            ],
            [
               [
                    [1, 0, 3, 5, 1],
                    [0, 1, 5, 1, 0],
                    [0, 4, 0, 0, 2],
                    [2, 3, 1, 2, 0],
                    [1, 0, 0, 1, 1],
                ],
            ],
            [
                [
                    [2, 3, 4, 1, 3],
                    [6, 1, 3, 1, 2],
                    [6, 3, 1, 2, 5],
                    [4, 2, 4, 7, 8],
                    [2, 1, 2, 4, 2],
                ],
            ],
            [
                [
                    [2, 3, -4, 1, 3],
                    [6, 1, 3, 1, 2],
                    [6, 3, 1, 2, 5],
                    [4, 2, 4, 7, 8],
                    [2, 1, 2, 4, 2],
                ],
            ],
            [
                [
                    [2, 3, -4, 1, 3],
                    [6, 1, -3, 1, 2],
                    [6, 3, 1, 2, 5],
                    [4, 2, 4, 7, 8],
                    [2, 1, 2, 4, 2],
                ],
            ],
            [
                [
                    [2, 3, -4, 1, 3],
                    [6, 1, -3, 1, 2],
                    [6, 3, -1, 2, 5],
                    [4, 2, 4, 7, 8],
                    [2, 1, 2, 4, 2],
                ],
            ],
            [
                [
                    [2, 3, -4, 1, 3],
                    [6, 1, -3, 1, 2],
                    [6, 3, -1, 2, 5],
                    [4, 2, -4, 7, 8],
                    [2, 1, 2, 4, 2],
                ],
            ],
            [
                [
                    [2, 3, -4, 1, 3],
                    [6, 1, -3, 1, 2],
                    [6, 3, -1, 2, 5],
                    [4, 2, -4, 7, 8],
                    [2, 1, -2, 4, 2],
                ],
            ],
            [
                [
                    [2, 3, -4, -1, 3],
                    [6, 1, -3, 1, 2],
                    [6, 3, -1, 2, 5],
                    [4, 2, -4, 7, 8],
                    [2, 1, -2, 4, 2],
                ],
            ],
            [
                [
                    [2, 3, -4, -1, -3],
                    [6, 1, -3, -1, 2],
                    [6, 3, -1, 2, 5],
                    [4, 2, -4, 7, -8],
                    [2, 1, -2, 4, 2],
                ],
            ],
            [
                [
                    [2, 1, 2],
                    [1, 1, 1],
                    [2, 2, 5],
                ],
            ],
            [
                [
                    [1, 0, 2, -1],
                    [3, 0, 0, 5],
                    [2, 1, 4, -3],
                    [1, 0, 5, 0],
                ],
            ],
            [
                [
                    [1, 0, 2, 0, 0, 4],
                    [18, 1, 5, 0, 0, 9],
                    [3, 5, 3, 6, 0, 4],
                    [2, 0, 8, 0, 0, 7],
                    [7, 0, 4, 0, 6, 0],
                    [0, 0, 1, 0, 0, 0]
                ],
            ],
            [
                [
                    [-1, 0, 2, 0, 0, 4],
                    [18, 1, 5, 0, 0, 9],
                    [3, 5, 3, 6, 0, 4],
                    [2, 0, 8, 0, 0, 7],
                    [7, 0, 4, 0, 6, 0],
                    [0, 0, 1, 0, 0, 0]
                ],
            ],
            [
                [
                    [-1, 0, -2, 0, 0, 4],
                    [18, 1, 5, 0, 0, 9],
                    [3, 5, 3, 6, 0, 4],
                    [2, 0, 8, 0, 0, 7],
                    [7, 0, 4, 0, 6, 0],
                    [0, 0, 1, 0, 0, 0]
                ],
            ],
            [
                [
                    [-1, 0, -2, 0, 0, -4],
                    [18, 1, 5, 0, 0, 9],
                    [3, 5, 3, 6, 0, 4],
                    [2, 0, 8, 0, 0, 7],
                    [7, 0, 4, 0, 6, 0],
                    [0, 0, 1, 0, 0, 0]
                ],
            ],
            [
                [
                    [1, 1, 1, 1, 1,  1],
                    [1, 3, 1, 3, 1,  3],
                    [1, 1, 4, 1, 1,  4],
                    [1, 3, 1, 7, 1,  3],
                    [1, 1, 1, 1, 6,  1],
                    [1, 3, 4, 3, 1, 12]
                ],
            ],
            [
                [
                    [-1, 1, 1, 1, 1, 1],
                    [1, 3, 1, 3, 1,  3],
                    [1, 1, 4, 1, 1,  4],
                    [1, 3, 1, 7, 1,  3],
                    [1, 1, 1, 1, 6,  1],
                    [1, 3, 4, 3, 1, 12]
                ],
            ],
            [
                [
                    [-1, 1, 1, 1, 1, 1],
                    [1, 3, 1, 3, 1,  3],
                    [1, 1, 4, 1, 1,  4],
                    [1, -3, 1, 7, 1, 3],
                    [1, 1, 1, 1, 6,  1],
                    [1, 3, 4, 3, 1, 12]
                ],
            ],
            [
                [
                    [-1, 0, 0, 0, 0, 0],
                    [0, 2, 0, 0, 0, 0],
                    [0, 0, 0, 4, 0, 0],
                    [0, 0, 3, 0, 0, 0],
                    [0, 0, 0, 0, 5, 0],
                    [0, 0, 0, 0, 0, 6]
                ],
            ],
            [
                [
                    [0, 1, 4, 3, 2, 3, 3, 4, 4],
                    [1, 0, 3, 2, 1, 2, 2, 3, 3],
                    [4, 3, 0, 1, 2, 3, 3, 4, 4],
                    [3, 2, 1, 0, 1, 2, 2, 3, 3],
                    [2, 1, 2, 1, 0, 1, 1, 2, 2],
                    [3, 2, 3, 2, 1, 0, 2, 3, 3],
                    [3, 2, 3, 2, 1, 2, 0, 1, 2],
                    [4, 3, 4, 3, 2, 3, 1, 0, 2],
                    [4, 3, 4, 3, 2, 3, 2, 2, 0],
                ],
            ],
            [
                [
                    [2, 1, 4, 3, 2, 3, 3, 4, 4],
                    [1, 2, 3, 2, 1, 2, 2, 3, 3],
                    [4, 3, 2, 1, 2, 3, 3, 4, 4],
                    [3, 2, 1, 2, 1, 2, 2, 3, 3],
                    [2, 1, 2, 1, 2, 1, 1, 2, 2],
                    [3, 2, 3, 2, 1, 2, 2, 3, 3],
                    [3, 2, 3, 2, 1, 2, 2, 1, 2],
                    [4, 3, 4, 3, 2, 3, 1, 2, 2],
                    [4, 3, 4, 3, 2, 3, 2, 2, 2],
                ],
            ],
            [
                [
                    [2, -1, 4, 3, 2, 3, 3, 4, 4],
                    [1, 2, 3, 2, 1, 2, 2, 3, 3],
                    [4, 3, 2, 1, 2, 3, 3, 4, 4],
                    [3, 2, 1, 2, 1, 2, 2, 3, 3],
                    [2, 1, 2, 1, 2, 1, 1, 2, 2],
                    [3, 2, 3, 2, 1, 2, 2, 3, 3],
                    [3, 2, 3, 2, 1, 2, 2, 1, 2],
                    [4, 3, 4, 3, 2, 3, 1, 2, 2],
                    [4, 3, 4, 3, 2, 3, 2, 2, 2],
                ],
            ],
            [
                [
                    [2, 1, 4, 3, 2, 3, 3, 4, 4],
                    [-1, 2, 3, 2, 1, 2, 2, 3, 3],
                    [4, 3, 2, 1, 2, 3, 3, 4, 4],
                    [3, 2, 1, 2, 1, 2, 2, 3, 3],
                    [2, 1, 2, 1, 2, 1, 1, 2, 2],
                    [3, 2, 3, 2, 1, 2, 2, 3, 3],
                    [3, 2, 3, 2, 1, 2, 2, 1, 2],
                    [4, 3, 4, 3, 2, 3, 1, 2, 2],
                    [4, 3, 4, 3, 2, 3, 2, 2, 2],
                ],
            ],
            [
                [
                    [2, -1, 4, 3, 2, 3, 3, 4, 4],
                    [-1, 2, 3, 2, 1, 2, 2, 3, 3],
                    [4, 3, 2, 1, 2, 3, 3, 4, 4],
                    [3, 2, 1, 2, 1, 2, 2, 3, 3],
                    [2, 1, 2, 1, 2, 1, 1, 2, 2],
                    [3, 2, 3, 2, 1, 2, 2, 3, 3],
                    [3, 2, 3, 2, 1, 2, 2, 1, 2],
                    [4, 3, 4, 3, 2, 3, 1, 2, 2],
                    [4, 3, 4, 3, 2, 3, 2, 2, 2],
                ],
            ],
            [
                [
                    [2, -1, 4, 3, 2, 3, 3, 4, 4],
                    [-1, 2, 3, 2, 1, 2, 2, 3, 3],
                    [4, 3, 2, 1, 2, 3, 3, 4, 4],
                    [2, 1, 2, 1, 2, 1, 1, 2, 2],
                    [3, 2, 1, 2, 1, 2, 2, 3, 3],
                    [3, 2, 3, 2, 1, 2, 2, 3, 3],
                    [3, 2, 3, 2, 1, 2, 2, 1, 2],
                    [4, 3, 4, 3, 2, 3, 1, 2, 2],
                    [4, 3, 4, 3, 2, 3, 2, 2, 2],
                ],
            ],
        ];
    }

    public function dataProviderForLowerTriangularMatrix()
    {
        return [
            [
                [
                    [1],
                ],
            ],
            [
                [
                    [0],
                ],
            ],
            [
                [
                    [1, 0],
                    [1, 1],
                ],
            ],
            [
                [
                    [0, 0],
                    [1, 0],
                ],
            ],
            [
                [
                    [0, 0],
                    [0, 0],
                ],
            ],
            [
                [
                    [1, 0, 0],
                    [1, 1, 0],
                    [1, 1, 1],
                ],
            ],
            [
                [
                    [0, 0, 0],
                    [0, 0, 0],
                    [0, 0, 0],
                ],
            ],
            [
                [
                    [1, 0, 0],
                    [0, 1, 0],
                    [0, 0, 1],
                ],
            ],
            [
                [
                    [1, 0, 0],
                    [0, 1, 0],
                    [0, 1, 0],
                ],
            ],
            [
                [
                    [1, 0, 0],
                    [2, 3, 0],
                    [4, 5, 6],
                ],
            ],
            [
                [
                    [1, 0, 0],
                    [2, 0, 0],
                    [4, 5, 6],
                ],
            ],
            [
                [
                    [1, 0, 0, 0],
                    [1, 1, 0, 0],
                    [1, 1, 1, 0],
                    [1, 1, 1, 1],
                ],
            ],
            [
                [
                    [5, 0, 0, 0],
                    [-6, 1, 0, 0],
                    [4, 6, 8, 0],
                    [6, 7, 7, -1],
                ],
            ],
            [
                [
                    [5, 0, 0, 0],
                    [-6, 1, 0, 0],
                    [4, 6, 0, 0],
                    [6, 7, 7, -1],
                ],
            ],
            [
                [
                    [1, 0, 0, 0, 0, 0],
                    [1, 2, 0, 0, 0, 0],
                    [1, 0, 3, 0, 0, 0],
                    [1, 2, 0, 4, 0, 0],
                    [1, 0, 0, 0, 5, 0],
                    [1, 2, 3, 0, 0, 6],
                ],
            ],
        ];
    }

    public function dataProviderForDiagonalMatrix()
    {
        return [
            [
                [
                    [0],
                ],
            ],
            [
                [
                    [1],
                ],
            ],
            [
                [
                    [1, 0],
                    [0, 1],
                ],
            ],
            [
                [
                    [-5, 0],
                    [0, 3],
                ],
            ],
            [
                [
                    [1, 0, 0],
                    [0, 1, 0],
                    [0, 0, 1],
                ],
            ],
            [
                [
                    [1, 0, 0, 0],
                    [0, 1, 0, 0],
                    [0, 0, 1, 0],
                    [0, 0, 0, 1],
                ],
            ],
            [
                [
                    [0, 0, 0, 0],
                    [0, 1, 0, 0],
                    [0, 0, 1, 0],
                    [0, 0, 0, 1],
                ],
            ],
            [
                [
                    [0, 0, 0, 0],
                    [0, 0, 0, 0],
                    [0, 0, 0, 0],
                    [0, 0, 0, 0],
                ],
            ],
            [
                [
                    [1, 0, 0, 0, 0],
                    [0, 1, 0, 0, 0],
                    [0, 0, 1, 0, 0],
                    [0, 0, 0, 1, 0],
                    [0, 0, 0, 0, 1],
                ],
            ],
            [
                [
                    [1, 0, 0, 0, 0],
                    [0, 2, 0, 0, 0],
                    [0, 0, 3, 0, 0],
                    [0, 0, 0, 4, 0],
                    [0, 0, 0, 0, -6],
                ],
            ],
            [
                [
                    [-1, 0, 0, 0, 0, 0],
                    [0, 2, 0, 0, 0, 0],
                    [0, 0, 3, 0, 0, 0],
                    [0, 0, 0, 4, 0, 0],
                    [0, 0, 0, 0, 5, 0],
                    [0, 0, 0, 0, 0, 6],
                ],
            ],
            [
                [
                    [1, 0, 0, 0, 0, 0],
                    [0, 2, 0, 0, 0, 0],
                    [0, 0, 3, 0, 0, 0],
                    [0, 0, 0, 4, 0, 0],
                    [0, 0, 0, 0, 5, 0],
                    [0, 0, 0, 0, 0, 6],
                ],
            ],
            [
                [
                    [1, 0, 0, 0, 0, 0],
                    [0, 2, 0, 0, 0, 0],
                    [0, 0, 0, 0, 0, 0],
                    [0, 0, 0, 4, 0, 0],
                    [0, 0, 0, 0, 5, 0],
                    [0, 0, 0, 0, 0, 0],
                ],
            ],
        ];
    }

    public function dataProviderForNotDiagonalMatrix()
    {
        return [
            [
                [
                    [1, 1],
                    [0, 1],
                ]
            ],
            [
                [
                    [1, 2],
                    [0, 4],
                ],
            ],
            [
                [
                    [1, 2, 3],
                    [0, 4, 5],
                    [0, 0, 6],
                ],
            ],
            [
                [
                    [6, 5, 4],
                    [0, 8, 8],
                    [0, 0, 9],
                ],
            ],
            [
                [
                    [1, 2, 3, 4],
                    [0, 4, 5, 6],
                    [0, 0, 6, 7],
                    [0, 0, 0, 8],
                ],
            ],
            [
                [
                    [-1, 0, 0, 0, 0, 1],
                    [0, 2, 0, 0, 0, 0],
                    [0, 0, 3, 0, 0, 0],
                    [0, 0, 0, 4, 0, 0],
                    [0, 0, 0, 0, 5, 0],
                    [0, 0, 0, 0, 0, 6],
                ],
            ],
            [
                [
                    [1, 0, 0, 0, 0, 0],
                    [0, 2, 0, 0, 0, 0],
                    [0, 0, 3, 0, 0, 0],
                    [0, 0, 0, 4, 0, 0],
                    [0, 0, 0, 0, 5, 0],
                    [1, 0, 0, 0, 0, 6],
                ],
            ],
            [
                [
                    [1, 0],
                    [1, 1],
                ],
            ],
            [
                [
                    [1, 0, 0],
                    [1, 1, 0],
                    [1, 1, 1],
                ],
            ],
            [
                [
                    [1, 0, 0],
                    [2, 3, 0],
                    [4, 5, 6],
                ],
            ],
            [
                [
                    [1, 0, 0, 0],
                    [1, 1, 0, 0],
                    [1, 1, 1, 0],
                    [1, 1, 1, 1],
                ],
            ],
            [
                [
                    [5, 0, 0, 0],
                    [-6, 1, 0, 0],
                    [4, 6, 8, 0],
                    [6, 7, 7, -1],
                ],
            ],
            [
                [
                    [1, 0, 0, 0, 0, 0],
                    [1, 2, 0, 0, 0, 0],
                    [1, 0, 3, 0, 0, 0],
                    [1, 2, 0, 4, 0, 0],
                    [1, 0, 0, 0, 5, 0],
                    [1, 2, 3, 0, 0, 6],
                ],
            ],
            [
                [
                    [0, 1],
                    [1, 0],
                ]
            ],
            [
                [
                    [0, 1],
                    [1, 1],
                ]
            ],
            [
                [
                    [1, 8],
                    [1, 1],
                ]
            ],
            [
                [
                    [1, 1],
                    [1, 0],
                ]
            ],
            [
                [
                    [1, 2, 3],
                    [2, 3, 4],
                ],
            ],
            [
                [
                    [-7, -6, -12],
                    [5, 5, 7],
                    [1, 0, 4],
                ],
            ],
            [
                [
                    [3, 8],
                    [4, 6],
                ],
            ],
            [
                [
                    [4, 3],
                    [3, 2],
                ],
            ],
            [
                [
                    [6, 1, 1],
                    [4, -2, 5],
                    [2, 8, 7],
                ],
            ],
            [
                [
                    [1, 2, 0],
                    [-1, 1, 1],
                    [1, 2, 3],
                ],
            ],
            [
                [
                    [4, 6, 3, 2],
                    [3, 6, 5, 3],
                    [5, 7, 8, 6],
                    [5, 4, 3, 2],
                ],
            ],
            [
                [
                    [3, 2, 0, 1],
                    [4, 0, 1, 2],
                    [3, 0, 2, 1],
                    [9, 2, 3, 1],
                ],
            ],
            [
                [
                    [1, 2, 3, 4],
                    [5, 6, 7, 8],
                    [2, 6, 4, 8],
                    [3, 1, 1, 2],
                ],
            ],
            [
                [
                    [7, 4, 2, 0],
                    [6, 3, -1, 2],
                    [4, 6, 2, 5],
                    [8, 2, -7, 1],
                ],
            ],
            [
                [
                  [-4, 3, 1, 5, -8],
                  [6, 0, 9, 2, 6],
                  [-1, 4, 4, 0, 2],
                  [8, -1, 3, 4, 0],
                  [5, 9, -7, -7, 1]
                ],
            ],
            [
                [
                  [4, 3, 1, 5, -8],
                  [6, 0, 9, 2, 6],
                  [-1, 4, 4, 0, 2],
                  [8, -1, 3, 4, 0],
                  [5, 9, -7, -7, 1]
                ],
            ],
            [
                [
                  [4, 3, 1, 5, 8],
                  [6, 0, 9, 2, 6],
                  [-1, 4, 4, 0, 2],
                  [8, -1, 3, 4, 0],
                  [5, 9, -7, -7, 1]
                ],

            ],
            [
                [
                  [4, 3, 1, 5, 8],
                  [6, 0, 9, 2, 6],
                  [1, 4, 4, 0, 2],
                  [8, -1, 3, 4, 0],
                  [5, 9, -7, -7, 1]
                ],
            ],
            [
                [
                  [4, 3, 1, 5, 8],
                  [6, 0, 9, 2, 6],
                  [1, 4, 4, 0, 2],
                  [8, 1, 3, 4, 0],
                  [5, 9, -7, -7, 1]
                ],
            ],
            [
                [
                  [4, 3, 1, 5, 8],
                  [6, 0, 9, 2, 6],
                  [1, 4, 4, 0, 2],
                  [8, 1, 3, 4, 0],
                  [5, 9, 7, -7, 1]
                ],
            ],
            [
                [
                  [4, 3, 1, 5, 8],
                  [6, 0, 9, 2, 6],
                  [1, 4, 4, 0, 2],
                  [8, 1, 3, 4, 0],
                  [5, 9, 7, 7, 1]
                ],
            ],
            [
                [
                    [5, 2, 0, 0, -2],
                    [0, 1, 4, 3, 2],
                    [0, 0, 2, 6, 3],
                    [0, 0, 3, 4, 1],
                    [0, 0, 0, 0, 2],
                ],
            ],
            [
                [
                    [5, 2, 0, 0, 2],
                    [0, 1, 4, 3, 2],
                    [0, 0, 2, 6, 3],
                    [0, 0, 3, 4, 1],
                    [0, 0, 0, 0, 2],
                ],
            ],
            [
                [
                    [5, 2, 0, 0, -2],
                    [0, -1, 4, 3, 2],
                    [0, 0, 2, 6, 3],
                    [0, 0, 3, 4, 1],
                    [0, 0, 0, 0, 2],
                ],
            ],
            [
                [
                    [2, -9, 1, 8, 4],
                    [-10, -1, 2, 7, 0],
                    [0, 4, -6, 1, -8],
                    [6, -14, 11, 0, 3],
                    [5, 1, -3, 2, -1],
                ],
            ],
            [
                [
                    [2, 9, 1, 8, 4],
                    [-10, -1, 2, 7, 0],
                    [0, 4, -6, 1, -8],
                    [6, -14, 11, 0, 3],
                    [5, 1, -3, 2, -1],
                ],
            ],
            [
                [
                    [2, 9, 1, 8, 4],
                    [10, -1, 2, 7, 0],
                    [0, 4, -6, 1, -8],
                    [6, -14, 11, 0, 3],
                    [5, 1, -3, 2, -1],
                ],
            ],
            [
                [
                    [2, 9, 1, 8, 4],
                    [10, 1, 2, 7, 0],
                    [0, 4, -6, 1, -8],
                    [6, -14, 11, 0, 3],
                    [5, 1, -3, 2, -1],
                ],
            ],
            [
                [
                    [276,1,179,23, 9387],
                    [0, 0, 78, 0, 0],
                    [0, 0, -1, 0, 1],
                    [0, 0, 1994, -1, 1089],
                    [1, 0, 212, 726, -378],
                ],
            ],
            [
                [
                    [276,1,179,23, 9387],
                    [0, 0, 78, 0, 0],
                    [0, 0, 1, 0, 1],
                    [0, 0, 1994, -1, 1089],
                    [1, 0, 212, 726, -378],
                ],
            ],
            [
                [
                    [276,1,179,23, 9387],
                    [0, 0, 78, 0, 0],
                    [0, 0, 1, 0, 1],
                    [0, 0, 1994, 1, 1089],
                    [1, 0, 212, 726, -378],
                ],
            ],
            [
                [
                    [276,1,179,23, 9387],
                    [0, 0, 78, 0, 0],
                    [0, 0, 1, 0, 1],
                    [0, 0, 1994, 1, 1089],
                    [1, 0, 212, 726, 378],
                ],
            ],
            [
                [
                    [276,1,179,23, -9387],
                    [0, 0, 78, 0, 0],
                    [0, 0, 1, 0, 1],
                    [0, 0, 1994, 1, 1089],
                    [1, 0, 212, 726, 378],
                ],
            ],
            [
               [
                    [1, 0, 3, 5, 1],
                    [0, 1, 5, 1, 0],
                    [0, 4, 0, 0, 2],
                    [2, 3, 1, 2, 0],
                    [1, 0, 0, 1, 1],
                ],
            ],
            [
                [
                    [2, 3, 4, 1, 3],
                    [6, 1, 3, 1, 2],
                    [6, 3, 1, 2, 5],
                    [4, 2, 4, 7, 8],
                    [2, 1, 2, 4, 2],
                ],
            ],
            [
                [
                    [2, 3, -4, 1, 3],
                    [6, 1, 3, 1, 2],
                    [6, 3, 1, 2, 5],
                    [4, 2, 4, 7, 8],
                    [2, 1, 2, 4, 2],
                ],
            ],
            [
                [
                    [2, 3, -4, 1, 3],
                    [6, 1, -3, 1, 2],
                    [6, 3, 1, 2, 5],
                    [4, 2, 4, 7, 8],
                    [2, 1, 2, 4, 2],
                ],
            ],
            [
                [
                    [2, 3, -4, 1, 3],
                    [6, 1, -3, 1, 2],
                    [6, 3, -1, 2, 5],
                    [4, 2, 4, 7, 8],
                    [2, 1, 2, 4, 2],
                ],
            ],
            [
                [
                    [2, 3, -4, 1, 3],
                    [6, 1, -3, 1, 2],
                    [6, 3, -1, 2, 5],
                    [4, 2, -4, 7, 8],
                    [2, 1, 2, 4, 2],
                ],
            ],
            [
                [
                    [2, 3, -4, 1, 3],
                    [6, 1, -3, 1, 2],
                    [6, 3, -1, 2, 5],
                    [4, 2, -4, 7, 8],
                    [2, 1, -2, 4, 2],
                ],
            ],
            [
                [
                    [2, 3, -4, -1, 3],
                    [6, 1, -3, 1, 2],
                    [6, 3, -1, 2, 5],
                    [4, 2, -4, 7, 8],
                    [2, 1, -2, 4, 2],
                ],
            ],
            [
                [
                    [2, 3, -4, -1, -3],
                    [6, 1, -3, -1, 2],
                    [6, 3, -1, 2, 5],
                    [4, 2, -4, 7, -8],
                    [2, 1, -2, 4, 2],
                ],
            ],
            [
                [
                    [2, 1, 2],
                    [1, 1, 1],
                    [2, 2, 5],
                ],
            ],
            [
                [
                    [1, 0, 2, -1],
                    [3, 0, 0, 5],
                    [2, 1, 4, -3],
                    [1, 0, 5, 0],
                ],
            ],
            [
                [
                    [1, 0, 2, 0, 0, 4],
                    [18, 1, 5, 0, 0, 9],
                    [3, 5, 3, 6, 0, 4],
                    [2, 0, 8, 0, 0, 7],
                    [7, 0, 4, 0, 6, 0],
                    [0, 0, 1, 0, 0, 0]
                ],
            ],
            [
                [
                    [-1, 0, 2, 0, 0, 4],
                    [18, 1, 5, 0, 0, 9],
                    [3, 5, 3, 6, 0, 4],
                    [2, 0, 8, 0, 0, 7],
                    [7, 0, 4, 0, 6, 0],
                    [0, 0, 1, 0, 0, 0]
                ],
            ],
            [
                [
                    [-1, 0, -2, 0, 0, 4],
                    [18, 1, 5, 0, 0, 9],
                    [3, 5, 3, 6, 0, 4],
                    [2, 0, 8, 0, 0, 7],
                    [7, 0, 4, 0, 6, 0],
                    [0, 0, 1, 0, 0, 0]
                ],
            ],
            [
                [
                    [-1, 0, -2, 0, 0, -4],
                    [18, 1, 5, 0, 0, 9],
                    [3, 5, 3, 6, 0, 4],
                    [2, 0, 8, 0, 0, 7],
                    [7, 0, 4, 0, 6, 0],
                    [0, 0, 1, 0, 0, 0]
                ],
            ],
            [
                [
                    [1, 1, 1, 1, 1,  1],
                    [1, 3, 1, 3, 1,  3],
                    [1, 1, 4, 1, 1,  4],
                    [1, 3, 1, 7, 1,  3],
                    [1, 1, 1, 1, 6,  1],
                    [1, 3, 4, 3, 1, 12]
                ],
            ],
            [
                [
                    [-1, 1, 1, 1, 1, 1],
                    [1, 3, 1, 3, 1,  3],
                    [1, 1, 4, 1, 1,  4],
                    [1, 3, 1, 7, 1,  3],
                    [1, 1, 1, 1, 6,  1],
                    [1, 3, 4, 3, 1, 12]
                ],
            ],
            [
                [
                    [-1, 1, 1, 1, 1, 1],
                    [1, 3, 1, 3, 1,  3],
                    [1, 1, 4, 1, 1,  4],
                    [1, -3, 1, 7, 1, 3],
                    [1, 1, 1, 1, 6,  1],
                    [1, 3, 4, 3, 1, 12]
                ],
            ],
            [
                [
                    [-1, 0, 0, 0, 0, 0],
                    [0, 2, 0, 0, 0, 0],
                    [0, 0, 0, 4, 0, 0],
                    [0, 0, 3, 0, 0, 0],
                    [0, 0, 0, 0, 5, 0],
                    [0, 0, 0, 0, 0, 6]
                ],
            ],
            [
                [
                    [0, 1, 4, 3, 2, 3, 3, 4, 4],
                    [1, 0, 3, 2, 1, 2, 2, 3, 3],
                    [4, 3, 0, 1, 2, 3, 3, 4, 4],
                    [3, 2, 1, 0, 1, 2, 2, 3, 3],
                    [2, 1, 2, 1, 0, 1, 1, 2, 2],
                    [3, 2, 3, 2, 1, 0, 2, 3, 3],
                    [3, 2, 3, 2, 1, 2, 0, 1, 2],
                    [4, 3, 4, 3, 2, 3, 1, 0, 2],
                    [4, 3, 4, 3, 2, 3, 2, 2, 0],
                ],
            ],
            [
                [
                    [2, 1, 4, 3, 2, 3, 3, 4, 4],
                    [1, 2, 3, 2, 1, 2, 2, 3, 3],
                    [4, 3, 2, 1, 2, 3, 3, 4, 4],
                    [3, 2, 1, 2, 1, 2, 2, 3, 3],
                    [2, 1, 2, 1, 2, 1, 1, 2, 2],
                    [3, 2, 3, 2, 1, 2, 2, 3, 3],
                    [3, 2, 3, 2, 1, 2, 2, 1, 2],
                    [4, 3, 4, 3, 2, 3, 1, 2, 2],
                    [4, 3, 4, 3, 2, 3, 2, 2, 2],
                ],
            ],
            [
                [
                    [2, -1, 4, 3, 2, 3, 3, 4, 4],
                    [1, 2, 3, 2, 1, 2, 2, 3, 3],
                    [4, 3, 2, 1, 2, 3, 3, 4, 4],
                    [3, 2, 1, 2, 1, 2, 2, 3, 3],
                    [2, 1, 2, 1, 2, 1, 1, 2, 2],
                    [3, 2, 3, 2, 1, 2, 2, 3, 3],
                    [3, 2, 3, 2, 1, 2, 2, 1, 2],
                    [4, 3, 4, 3, 2, 3, 1, 2, 2],
                    [4, 3, 4, 3, 2, 3, 2, 2, 2],
                ],
            ],
            [
                [
                    [2, 1, 4, 3, 2, 3, 3, 4, 4],
                    [-1, 2, 3, 2, 1, 2, 2, 3, 3],
                    [4, 3, 2, 1, 2, 3, 3, 4, 4],
                    [3, 2, 1, 2, 1, 2, 2, 3, 3],
                    [2, 1, 2, 1, 2, 1, 1, 2, 2],
                    [3, 2, 3, 2, 1, 2, 2, 3, 3],
                    [3, 2, 3, 2, 1, 2, 2, 1, 2],
                    [4, 3, 4, 3, 2, 3, 1, 2, 2],
                    [4, 3, 4, 3, 2, 3, 2, 2, 2],
                ],
            ],
            [
                [
                    [2, -1, 4, 3, 2, 3, 3, 4, 4],
                    [-1, 2, 3, 2, 1, 2, 2, 3, 3],
                    [4, 3, 2, 1, 2, 3, 3, 4, 4],
                    [3, 2, 1, 2, 1, 2, 2, 3, 3],
                    [2, 1, 2, 1, 2, 1, 1, 2, 2],
                    [3, 2, 3, 2, 1, 2, 2, 3, 3],
                    [3, 2, 3, 2, 1, 2, 2, 1, 2],
                    [4, 3, 4, 3, 2, 3, 1, 2, 2],
                    [4, 3, 4, 3, 2, 3, 2, 2, 2],
                ],
            ],
            [
                [
                    [2, -1, 4, 3, 2, 3, 3, 4, 4],
                    [-1, 2, 3, 2, 1, 2, 2, 3, 3],
                    [4, 3, 2, 1, 2, 3, 3, 4, 4],
                    [2, 1, 2, 1, 2, 1, 1, 2, 2],
                    [3, 2, 1, 2, 1, 2, 2, 3, 3],
                    [3, 2, 3, 2, 1, 2, 2, 3, 3],
                    [3, 2, 3, 2, 1, 2, 2, 1, 2],
                    [4, 3, 4, 3, 2, 3, 1, 2, 2],
                    [4, 3, 4, 3, 2, 3, 2, 2, 2],
                ],
            ],
        ];
    }

    public function dataProviderForRectangularDiagonalMatrix()
    {
        return [
            [
                [[3, 0]],
            ],
            [
                [
                    [6, 0, 0],
                    [0, 2, 0],
                ],
            ],
            [
                [
                    [5, 0],
                    [0, 9],
                    [0, 0],
                ],
            ],
        ];
    }

    public function dataProviderForNotRectangularDiagonalMatrix()
    {
        return [
            [
                [[1, 1]],
            ],
            [
                [[0, 1]],
            ],
            [
                [
                    [1, 0, 0],
                    [0, 1, 1],
                ],
            ],
            [
                [
                    [1, 0],
                    [0, 1],
                    [0, 2],
                ],
            ],
        ];
    }

    /**
     * All ref matrices in this data provider are not in rref.
     */
    public function dataProviderForRefMatrix()
    {
        return [
            [
                [
                    [2],
                ],
            ],
            [
                [
                    [4, 2],
                ],
            ],
            [
                [
                    [1, 2],
                    [0, 1],
                ],
            ],
            [
                [
                    [1, 2],
                    [0, 1],
                    [0, 0],
                ],
            ],
            [
                [
                    [2, 3],
                    [0, 2],
                    [0, 0],
                    [0, 0],
                ],
            ],
            [
                [
                    [1, 0, -1],
                    [0, 5, 2],
                    [0, 0, 0]
                ],
            ],
            [
                [
                    [1, 2, 3, 4],
                    [0, 0, 1, 3],
                    [0, 0, 0, 1],
                ],
            ],
            [
                [
                    [1, 2, 3, 4],
                    [0, 0, 1, 3],
                    [0, 0, 0, 1],
                    [0, 0, 0, 0],
                ],
            ],
            [
                [
                    [1, 0, 3, 3],
                    [0, 1, 0, 4],
                    [0, 0, 0, 1],
                ],
            ],
            [
                [
                    [1, -3, 4, -3, 2, 5],
                    [0, 1, -2, 2, 1, -3],
                    [0, 0, 0, 0, 1, 4],
                ],
            ],
            [
                [
                    [1, 4, 5, -9, -7],
                    [0, 2, 4, -6, -6],
                    [0, 0, 0, -5, 0],
                    [0, 0, 0, 0, 0],
                ],
            ],
            [
                [
                    [3, -9, 12, -9, 6, 15],
                    [0, 1, -2, 2, 1, -3],
                    [0, 0, 0, 0, 1, 4],
                ],
            ],
        ];
    }

    public function dataProviderForNotRefMatrix()
    {
        return [
            [
                [
                    [0],
                    [4],
                ],
            ],
            [
                [
                    [0, 0],
                    [4, 1],
                ],
            ],
            [
                [
                    [0, 1],
                    [1, 1],
                ],
            ],
            [
                [
                    [1, 2],
                    [4, 1],
                ],
            ],
            [
                [
                    [1, 2],
                    [0, 1],
                    [1, 0],
                ],
            ],
            [
                [
                    [2, 3],
                    [0, 2],
                    [0, 0],
                    [0, 1],
                ],
            ],
            [
                [
                    [2, 3],
                    [0, 2],
                    [5, 0],
                    [0, 0],
                ],
            ],
            [
                [
                    [1, 0, -1],
                    [0, 1, 2],
                    [0, 1, 0]
                ],
            ],
            [
                [
                    [1, 0, -1],
                    [3, 1, 2],
                    [0, 0, 0]
                ],
            ],
            [
                [
                    [1, 0, -1],
                    [0, 1, 2],
                    [1, 0, 0]
                ],
            ],
            [
                [
                    [1, 0, -1],
                    [0, 0, 0],
                    [0, 1, 0]
                ],
            ],
            [
                [
                    [1, 0, 3, 3],
                    [0, 1, 0, 4],
                    [3, 0, 0, 1],
                ],
            ],
            [
                [
                    [1, -3, 4, -3, 2, 5],
                    [0, 1, -2, 2, 1, -3],
                    [0, 3, 0, 0, 1, 4],
                ],
            ],
            [
                [
                    [1, 4, 5, -9, -7],
                    [0, 2, 4, -6, -6],
                    [0, 3, 0, -5, 0],
                    [0, 0, 0, 0, 0],
                ],
            ],
            [
                [
                    [1, 4, 5, -9, -7],
                    [0, 2, 4, -6, -6],
                    [0, 0, 0, 0, 0],
                    [0, 0, 0, -5, 0],
                ],
            ],
            [
                [
                    [1, 4, 5, -9, -7],
                    [0, 2, 4, -6, -6],
                    [0, 0, 0, -5, 0],
                    [0, 0, 5, 0, 0],
                ],
            ],
            [
                [
                    [1, 4, 5, -9, -7],
                    [0, 2, 4, -6, -6],
                    [0, 3, 0, -5, 0],
                    [0, 0, 0, 1, 0],
                ],
            ],
            [
                [
                    [3, -9, 12, -9, 6, 15],
                    [0, 1, -2, 2, 1, -3],
                    [2, 0, 0, 0, 1, 4],
                ],
            ],
            [
                [
                    [3, -9, 12, -9, 6, 15],
                    [0, 1, -2, 2, 1, -3],
                    [0, 2, 0, 0, 1, 4],
                ],
            ],
            [
                [
                    [0, 1, -2, 2, 1, -3],
                    [3, -9, 12, -9, 6, 15],
                    [0, 0, 0, 0, 1, 4],
                ],
            ],
            [
                [
                    [3, -9, 12, -9, 6, 15],
                    [0, 0, 0, 0, 0, 0],
                    [0, 1, -2, 2, 1, -3],
                    [0, 0, 0, 0, 1, 4],
                ],
            ],
        ];
    }

    public function dataProviderForRrefMatrix()
    {
        return [
            [
                [
                    [1],
                ],
            ],
            [
                [
                    [1, 2],
                ],
            ],
            [
                [
                    [1, 0],
                    [0, 1],
                ],
            ],
            [
                [
                    [1, 0],
                    [0, 1],
                    [0, 0],
                ],
            ],
            [
                [
                    [1, 0],
                    [0, 1],
                    [0, 0],
                    [0, 0],
                ],
            ],
            [
                [
                    [1, 0, -1],
                    [0, 1, 2],
                    [0, 0, 0]
                ],
            ],
            [
                [
                    [1, 2, 0, 0],
                    [0, 0, 1, 0],
                    [0, 0, 0, 1],
                ],
            ],
            [
                [
                    [1, 2, 0, 0],
                    [0, 0, 1, 0],
                    [0, 0, 0, 1],
                    [0, 0, 0, 0],
                ],
            ],
            [
                [
                    [1, 0, 3, 0],
                    [0, 1, 0, 0],
                    [0, 0, 0, 1],
                ],
            ],
            [
                [
                    [1, 0, 4, -3, 0, 5],
                    [0, 1, -2, 2, 0, -3],
                    [0, 0, 0, 0, 1, 4],
                ],
            ],
            [
                [
                    [1, 0, 5, 0, -7],
                    [0, 1, 4, 0, -6],
                    [0, 0, 0, 1, 0],
                    [0, 0, 0, 0, 0],
                ],
            ],
            [
                [
                    [1, 0, 12, -9, 0, 15],
                    [0, 1, -2, 2, 0, -3],
                    [0, 0, 0, 0, 1, 4],
                ],
            ],
        ];
    }

    public function dataProviderForNotRrefMatrix()
    {
        foreach ($this->dataProviderForRefMatrix() as $matrix) {
            yield $matrix;
        }

        foreach (
            [
                [
                    [
                        [2],
                    ],
                ],
                [
                    [
                        [2, 2],
                    ],
                ],
                [
                    [
                        [1, 0],
                        [0, 2],
                    ],
                ],
                [
                    [
                        [2, 0],
                        [0, 1],
                        [0, 0],
                    ],
                ],
                [
                    [
                        [1, 0],
                        [0, 1],
                        [2, 0],
                        [0, 0],
                    ],
                ],
                [
                    [
                        [1, 2, -1],
                        [0, 1, 2],
                        [0, 0, 0]
                    ],
                ],
                [
                    [
                        [1, 2, 0, 0],
                        [0, 0, 3, 0],
                        [0, 0, 0, 1],
                    ],
                ],
                [
                    [
                        [1, 2, 0, 0],
                        [0, 0, 1, 0],
                        [0, 0, 3, 1],
                        [0, 0, 0, 0],
                    ],
                ],
                [
                    [
                        [1, 0, 3, 0],
                        [0, 1, 0, 0],
                        [1, 0, 0, 1],
                    ],
                ],
                [
                    [
                        [1, 0, 4, -3, 4, 5],
                        [0, 1, -2, 2, 0, -3],
                        [0, 0, 0, 0, 1, 4],
                    ],
                ],
                [
                    [
                        [1, 0, 5, 0, -7],
                        [0, 4, 4, 0, -6],
                        [0, 0, 0, 1, 0],
                        [0, 0, 0, 0, 0],
                    ],
                ],
                [
                    [
                        [1, 1, 12, -9, 0, 15],
                        [0, 1, -2, 2, 0, -3],
                        [0, 0, 0, 0, 1, 4],
                    ],
                ],
            ] as $matrix
        ) {
            yield $matrix;
        }
    }

    public function dataProviderForTwoSquareMatrices()
    {
        return [
            [
                [
                    [1, 5],
                    [4, 3],
                ],
                [
                    [5, 6],
                    [2, 1],
                ],
            ],
            [
                [
                    [3, 8, 5],
                    [3, 6, 1],
                    [9, 5, 8],
                ],
                [
                    [5, 3, 8],
                    [6, 4, 5],
                    [1, 8, 9],
                ],
            ],
            [
                [
                    [-4, -2, 9],
                    [3, 14, -6],
                    [3, 9, 9],
                ],
                [
                    [8, 7, 8],
                    [-5, 4, 1],
                    [3, 5, 1],
                ],
            ],
            [
                [
                    [4, 7, 7, 8],
                    [3, 6, 4, 1],
                    [-3, 6, 8, -3],
                    [3, 2, 1, -54],
                ],
                [
                    [3, 2, 6, 7],
                    [4, 3, -6, 2],
                    [12, 14, 14, -6],
                    [4, 6, 4, -42],
                ],
            ],
            [
                [
                    [4, 17,6, 3],
                    [3, -6, 4, 21],
                    [3, 6, 8, -2],
                    [5, 2, 3, 15],
                ],
                [
                    [3, 12, 16, 7],
                    [4, 13, 6, 2],
                    [2, 4, 14, -6],
                    [14, 3, 4, 52],
                ],
            ],
        ];
    }

    public function dataProviderForThreeMatrices()
    {
        return [
            [
                [
                    [1],
                ],
                [
                    [2],
                ],
                [
                    [3],
                ],
            ],
            [
                [
                    [1, 5, 3],
                    [3, 6, 3],
                    [6, 7, 8],
                ],
                [
                    [6, 9, 9],
                    [3, 5, 1],
                    [3, 5, 12],
                ],
                [
                    [7, 9, 6],
                    [1, 9, 1],
                    [10, 12, 4],
                ],
            ],
            [
                [
                    [12, 21, 6],
                    [-3, 11, -6],
                    [3, 6, -3],
                ],
                [
                    [3, 7, 8],
                    [4, 4, 2],
                    [6, -4, 1],
                ],
                [
                    [-1, -1, -5],
                    [8, 15, 15],
                    [8, 6, -12],
                ],
            ],
            [
                [
                    [1, 2],
                    [0, -1],
                ],
                [
                    [0, -1],
                    [1, 1],
                ],
                [
                    [2, 8],
                    [2, 1],
                ],
            ],
            [
                [
                    [1, 5, 3],
                    [3, 6, 3],
                    [6, 7, 8],
                ],
                [
                    [6, 9, 9],
                    [3, 5, 1],
                    [3, 5, 12],
                ],
                [
                    [6, 4, 9],
                    [12, 3, -1],
                    [10, 2, 15],
                ],
            ],
            [
                [
                    [12, 21, 6],
                    [-3, 11, -6],
                    [3, 6, -3],
                ],
                [
                    [3, 7, 8],
                    [4, 4, 2],
                    [6, -4, 1],
                ],
                [
                    [1, 1, 5],
                    [3, 4, 9],
                    [3, 16, -2],
                ],
            ],
            [
                [
                    [1, 2, 3, 4, 5],
                    [2, 3, 4, 5, 6],
                    [4, 5, 6, 7, 8],
                    [6, 5, 4, 5, 7],
                ],
                [
                    [1, 2, 5, 5, 6],
                    [2, 3, 5, 5, 6],
                    [5, 4, 5, 5, 6],
                    [3, 2, 5, 5, 6],
                ],
                [
                    [5, 5, 7, 8, 9],
                    [4, 4, 7, 8, 9],
                    [7, 6, 7, 6, 7],
                    [9, 9, 9, 0, 0],
                ]
            ],
        ];
    }

    /**
     * @return array [A, B, C, D]
     */
    public function dataProviderForFourMatrices()
    {
        return [
            [
                [
                    [1],
                ],
                [
                    [2],
                ],
                [
                    [3],
                ],
                [
                    [4],
                ],
            ],
            [
                [
                    [1, 5, 3],
                    [3, 6, 3],
                    [6, 7, 8],
                ],
                [
                    [6, 9, 9],
                    [3, 5, 1],
                    [3, 5, 12],
                ],
                [
                    [7, 9, 6],
                    [1, 9, 1],
                    [10, 12, 4],
                ],
                [
                    [3, 5, 3],
                    [4, 6, 1],
                    [5, 7, 8],
                ],
            ],
            [
                [
                    [12, 21, 6],
                    [-3, 11, -6],
                    [3, 6, -3],
                ],
                [
                    [3, 7, 8],
                    [4, 4, 2],
                    [6, -4, 1],
                ],
                [
                    [-1, -1, -5],
                    [8, 15, 15],
                    [8, 6, -12],
                ],
                [
                    [1, 2, 3],
                    [2, 2, 2],
                    [4, 3, 2],
                ]
            ],
            [
                [
                    [1, 2],
                    [0, -1],
                ],
                [
                    [0, -1],
                    [1, 1],
                ],
                [
                    [2, 8],
                    [2, 1],
                ],
                [
                    [1, 4],
                    [3, 5],
                ],
            ],
            [
                [
                    [1, 5, 3],
                    [3, 6, 3],
                    [6, 7, 8],
                ],
                [
                    [6, 9, 9],
                    [3, 5, 1],
                    [3, 5, 12],
                ],
                [
                    [6, 4, 9],
                    [12, 3, -1],
                    [10, 2, 15],
                ],
                [
                    [1, 3, 3],
                    [6, 6, 3],
                    [2, 3, 9],
                ],
            ],
            [
                [
                    [12, 21, 6],
                    [-3, 11, -6],
                    [3, 6, -3],
                ],
                [
                    [3, 7, 8],
                    [4, 4, 2],
                    [6, -4, 1],
                ],
                [
                    [1, 1, 5],
                    [3, 4, 9],
                    [3, 16, -2],
                ],
                [
                    [3, 4, 8],
                    [-4, -4, 2],
                    [6, 4, 2],
                ],
            ],
            [
                [
                    [1, 2, 3, 4],
                    [2, 3, 4, 5],
                    [4, 5, 6, 7],
                    [6, 5, 4, 5],
                ],
                [
                    [1, 2, 5, 5],
                    [2, 3, 5, 5],
                    [5, 4, 5, 5],
                    [3, 2, 5, 5],
                ],
                [
                    [5, 5, 7, 8],
                    [4, 4, 7, 8],
                    [7, 6, 7, 6],
                    [9, 9, 9, 0],
                ],
                [
                    [1, -2, 3, 4],
                    [2, -3, 4, 9],
                    [4, -5, 6, 8],
                    [6, -5, 4, 5],
                ],
            ],
        ];
    }

    /**
     * Solving a system of lineary equations
     * Test cases generated using various online sources and various applications.
     * For example, SciPy scipy.linalg.solve(a,b)
     * @return array (A, b, x) for Ax = b
     */
    public function dataProviderForSolve()
    {
        return [
            [
                [
                    [3, 4],
                    [2, -1],
                ],
                [5, 7],
                [3, -1],
            ],
            [
                [
                    [3, 1],
                    [2, -1],
                ],
                [5, 0],
                [1, 2],
            ],
            [
                [
                    [3, 4],
                    [5, 3],
                ],
                [-2, 4],
                [2, -2],
            ],
            [
                [
                    [1, 0, 0],
                    [0, 1, 0],
                    [0, 0, 1],
                ],
                [2, 3, -4],
                [2, 3, -4],
            ],
            [
                [
                    [1, 1, -1],
                    [3, 1, 1],
                    [1, -1, 4],
                ],
                [1, 9, 8],
                [3, -1, 1],
            ],
            [
                [
                    [2, 4, 1],
                    [4, -10, 2],
                    [1, 2, 4],
                ],
                [5, -8, 13],
                [-1, 1, 3],
            ],
            [
                [
                    [1, 1, 1],
                    [0, 2, 5],
                    [2, 5, -1],
                ],
                [6, -4, 27],
                [5, 3, -2],
            ],
            [
                [
                    [1, 2, 3],
                    [2, -1, 1],
                    [3, 0, -1],
                ],
                [9, 8, 3],
                [2, -1, 3],
            ],
            [
                [
                    [2, 1, -3],
                    [4, -2, 1],
                    [3, 5, -2],
                ],
                [-4, 9, 5],
                [2, 1, 3],
            ],
            [
                [
                    [4, 9, 0],
                    [8, 0, 6],
                    [0, 6, 6],
                ],
                [8, -1, -1],
                [1 / 2, 2 / 3, -5 / 6],
            ],
            [
                [
                    [1, 1, 1],
                    [1, -2, 2],
                    [1, 2, -1],
                ],
                [0, 4, 2],
                [4, -2, -2],
            ],
            [
                [
                    [3, 3, 4],
                    [3, 5, 9],
                    [5, 9, 17],
                ],
                [1, 2, 4],
                [1, -2, 1],
            ],
            [
                [
                    [2, 1, 1],
                    [-1, 1, -1],
                    [1, 2, 3],
                ],
                [2, 3, -10],
                [3, 1, -5],
            ],
            [
                [
                    [3, 2, 0],
                    [1, -1, 0],
                    [0, 5, 1],
                ],
                [2, 4, -1],
                [2, -2, 9],
            ],
            [
                [
                    [4, 1, 0],
                    [1, 4, 1],
                    [0, 1, 4],
                ],
                [1, 4, 1],
                [0, 1, 0],
            ],
            [
                [
                    [6, 4, 24],
                    [1, -1, 0],
                    [0, 5, 1]
                ],
                [2, 4, -1],
                [3.98181818, -0.01818182, -0.90909091],
            ],
            [
                [
                    [1, 2, 3],
                    [3, 4, 7],
                    [6, 5, 9],
                ],
                [0, 2, 11],
                [4, 1, -2],
            ],
            [
                [
                    [4, 2, -1, 3],
                    [3, -4, 2, 5],
                    [-2, 6, -5, -2],
                    [5, 1, 6, -3],
                ],
                [16.9, -14, 25, 9.4],
                [4.5, 1.6, -3.8, -2.7],
            ],
            [
                [
                    [4, 2, -1, 3],
                    [3, -4, 2, 5],
                    [-2, 6, -5, -2],
                    [5, 1, 6, -3],
                ],
                [-12, 34, 27, -19],
                [-101.48484848,  101.24242424,  115.72727273,  102.39393939],
            ],
            [
                [
                    [ 4,  1,  2,  -3],
                    [-3,  3, -1,   4],
                    [-1,  2,  5,   1],
                    [ 5,  4,  3,  -1],
                ],
                [-16, 20, -4, -10],
                [-1, 1, -2, 3],
            ],
            [
                [
                    [ 4,  1,  2,  -3,  5],
                    [-3,  3, -1,   4, -2],
                    [-1,  2,  5,   1,  3],
                    [ 5,  4,  3,  -1,  2],
                    [ 1, -2,  3,  -4,  5],
                ],
                [-16, 20, -4, -10,  3],
                [-15.35406699, 15.81339713, -1.77033493, -22.14832536, -6.66028708],
            ],
            [
                [
                    [1, 1, -2, 1, 3, -1],
                    [2, -1, 1, 2, 1, -3],
                    [1, 3, -3, -1, 2, 1],
                    [5, 2, -1, -1, 2, 1],
                    [-3, -1, 2, 3, 1, 3],
                    [4, 3, 1, -6, -3, -2],
                ],
                [4, 20, -15, -3, 16, -27],
                [1, -2, 3, 4, 2, -1],
            ],
            // SciPy test cases - scipy.linalg.solve(a, b)
            [
                [
                    [1, 20],
                    [-30, 4],
                ],
                [1, 0],
                [0.00662252, 0.04966887],
            ],
            [
                [
                    [1, 20],
                    [-30, 4],
                ],
                [0, 1],
                [-0.03311258,  0.00165563],
            ],
            [
                [
                    [1, 20],
                    [-30, 4],
                ],
                [2, 1],
                [-0.01986755,  0.10099338],
            ],
            [
                [
                    [1, 20],
                    [-30, 4],
                ],
                [-30, 4],
                [-0.33112583, -1.48344371],
            ],
            [
                [
                    [2, 3],
                    [3, 5],
                ],
                [1, 0],
                [5, -3],
            ],
            [
                [
                    [2, 3],
                    [3, 5],
                ],
                [0, 1],
                [-3, 2],
            ],
            [
                [
                    [1.80, 2.88, 2.05, -0.89],
                    [525.00, -295.00, -95.00, -380.00],
                    [1.58, -2.69, -2.90, -1.04],
                    [-1.11, -0.66, -0.59, 0.80],
                ],
                [9.52, 2435, .77, -6.22],
                [1, -1, 3, -5],
            ],
            [
                [
                    [1.80, 2.88, 2.05, -0.89],
                    [525.00, -295.00, -95.00, -380.00],
                    [1.58, -2.69, -2.90, -1.04],
                    [-1.11, -0.66, -0.59, 0.80],
                ],
                [18.47, 225, -13.28, -6.21],
                [3., 2., 4., 1.],
            ],
            [
                [
                    [1, 0],
                    [1, 2],
                ],
                [1, 1],
                [1, 0],
            ],
        ];
    }

    public function dataProviderForTwoPositiveDefiniteMatrices()
    {
        return [
            [
                [
                    [2, -1],
                    [-1, 2],
                ],
                [
                    [1, -1],
                    [-1, 4],
                ],
            ],
            [
                [
                    [5, 2],
                    [2, 3],
                ],
                [
                    [6, 4],
                    [4, 5],
                ],
            ],
            [
                [
                    [12, -12],
                    [-12, 96],
                ],
                [
                    [6, 4],
                    [4, 5],
                ],
            ],
            [
                [
                    [2, -1, 0],
                    [-1, 2, -1],
                    [0, -1, 2],
                ],
                [
                    [2, -1, 1],
                    [-1, 2, -1],
                    [1, -1, 2],
                ],
            ],
            [
                [
                    [1, 0, 0],
                    [0, 3, 0],
                    [0, 0, 2],
                ],
                [
                    [3, -2, 0],
                    [-2, 2, 0],
                    [0, 0, 2],
                ],
            ],
            [
                [
                    [4, 1, -1],
                    [1, 2, 1],
                    [-1, 1, 2],
                ],
                [
                    [3, -2, 0],
                    [-2, 2, 0],
                    [0, 0, 2],
                ],
            ],
            [
                [
                    [14, 4, 9],
                    [4, 14, -7],
                    [9, -7, 14],
                ],
                [
                    [13, 0, -3],
                    [0, 9, 9],
                    [-3, 9, 10],
                ],
            ],
            [
                [
                    [14, -7, -13],
                    [-7, 6, 5],
                    [-13, 5, 14],
                ],
                [
                    [13, 0, -3],
                    [0, 9, 9],
                    [-3, 9, 10],
                ],
            ],
        ];
    }

    public function dataProviderForIdempotentMatrix()
    {
        return [
            [
                [
                    [1, 0],
                    [0, 1],
                ],
            ],
            [
                [
                    [3, -6],
                    [1, -2],
                ],
            ],
            [
                [
                    [1, 0, 0],
                    [0, 0, 0],
                    [0, 0, 1],
                ],
            ],
            [
                [
                    [2, -2, -4],
                    [-1, 3, 4],
                    [1, -2, -3],
                ],
            ],
        ];
    }

    public function dataProviderForNotIdempotentMatrix()
    {
        return [
            [
                [
                    [0, 1],
                ],
            ],
            [
                [
                    [3, 6],
                    [1, 2],
                ],
            ],
            [
                [
                    [2, 2, 4],
                    [1, 3, 4],
                    [1, 2, 3],
                ],
            ],
        ];
    }

    public function dataProviderForNilpotentMatrix()
    {
        return [
            [
                [
                    [0],
                ],
            ],
            [
                [
                    [0, 0],
                    [1, 0],
                ],
            ],
            [
                [
                    [0, 1],
                    [0, 0],
                ],
            ],
            [
                [
                    [2, -1],
                    [4, -2],
                ],
            ],
            [
                [
                    [0, 5, 2],
                    [0, 0, 3],
                    [0, 0, 0],
                ],
            ],
            [
                [
                    [5, -3, 2],
                    [15, -9, 6],
                    [10, -6, 4],
                ],
            ],
            [
                [
                    [5, 5, 5],
                    [6, 6, 6],
                    [-11, -11, -11],
                ],
            ],
            [
                [
                    [2, 2, -2],
                    [5, 1, -3],
                    [1, 5, -3],
                ],
            ],
            [
                [
                    [0, 2, 1, 6],
                    [0, 0, 1, 2],
                    [0, 0, 0, 3],
                    [0, 0, 0, 0],
                ],
            ],
            [
                [
                    [1, 1, 1, 1],
                    [2, 2, 2, 2],
                    [4, 4, 4, 4],
                    [-7, -7, -7, -7],
                ],
            ],
            [
                [
                    [2, 2, 2, -3],
                    [6, 1, 1, -4],
                    [1, 6, 1, -4],
                    [1, 1, 6, -4],
                ],
            ],
            [
                [
                    [2, 2, 2, 2, -4],
                    [7, 1, 1, 1, -5],
                    [1, 7, 1, 1, -5],
                    [1, 1, 7, 1, -5],
                    [1, 1, 1, 7, -5],
                ],
            ],
        ];
    }

    public function dataProviderForNotNilpotentMatrix()
    {
        return [
            [
                [
                    [0, 1],
                ],
            ],
            [
                [
                    [0, 1],
                    [1, 0],
                ],
            ],
            [
                [
                    [1, 2],
                    [0, -1],
                ],
            ],
            [
                [
                    [1, 2],
                    [1, -1],
                ],
            ],
            [
                [
                    [1, 2, 3],
                    [4, 5, 6],
                    [7, 8, 9],
                ],
            ],
            [
                [
                    [1, 1, -1],
                    [-1, 1, -1],
                    [1, 1, -2],
                ],
            ],
            [
                [
                    [2, 2, 2, 2, -4],
                    [7, 1, 1, 1, -5],
                    [1, 7, 1, 1, -5],
                    [1, 1, 7, 1, -5],
                    [0, 1, 1, 7, -5],
                ],
            ],
        ];
    }

    public function dataProviderForInvolutoryMatrix()
    {
        return [
            [
                [
                    [1],
                ],
            ],
            [
                [
                    [1, 0],
                    [0, 1],
                ],
            ],
            [
                [
                    [1, 0, 0],
                    [0, 1, 0],
                    [0, 0, 1],
                ],
            ],
            [
                [
                    [1, 0, 0],
                    [0, 0, 1],
                    [0, 1, 0],
                ],
            ],
            [
                [
                    [1, 0, 0],
                    [0, -1, 0],
                    [0, 0, -1],
                ],
            ],
        ];
    }

    public function dataProviderForNotInvolutoryMatrix()
    {
        return [
            [
                [
                    [1, 0],
                    [4, 1],
                ],
            ],
            [
                [
                    [1, 0, 0],
                    [0, 1, 0],
                    [0, 0, 3],
                ],
            ],
            [
                [
                    [1, 1, 0],
                    [0, 0, 1],
                    [0, 1, 0],
                ],
            ],
            [
                [
                    [1, 0, -6],
                    [0, -2, 0],
                    [0, 0, -1],
                ],
            ],
        ];
    }

    public function dataProviderForSignatureMatrix()
    {
        return [
            [
                [
                    [1],
                ],
            ],
            [
                [
                    [-1],
                ],
            ],
            [
                [
                    [1, 0],
                    [0, 1],
                ],
            ],
            [
                [
                    [-1, 0],
                    [0, 1],
                ],
            ],
            [
                [
                    [1, 0],
                    [0, -1],
                ],
            ],
            [
                [
                    [-1, 0],
                    [0, -1],
                ],
            ],
            [
                [
                    [1, 0, 0],
                    [0, 1, 0],
                    [0, 0, 1],
                ],
            ],
            [
                [
                    [-1, 0, 0],
                    [0, 1, 0],
                    [0, 0, 1],
                ],
            ],
            [
                [
                    [1, 0, 0],
                    [0, -1, 0],
                    [0, 0, 1],
                ],
            ],
            [
                [
                    [1, 0, 0],
                    [0, 1, 0],
                    [0, 0, -1],
                ],
            ],
            [
                [
                    [-1, 0, 0],
                    [0, -1, 0],
                    [0, 0, 1],
                ],
            ],
            [
                [
                    [1, 0, 0],
                    [0, -1, 0],
                    [0, 0, -1],
                ],
            ],
            [
                [
                    [-1, 0, 0],
                    [0, 1, 0],
                    [0, 0, -1],
                ],
            ],
            [
                [
                    [-1, 0, 0],
                    [0, -1, 0],
                    [0, 0, -1],
                ],
            ],
        ];
    }

    public function dataProviderForNotSignatureMatrix()
    {
        return [
            [
                [
                    [2],
                ],
            ],
            [
                [
                    [-3],
                ],
            ],
            [
                [
                    [2, 0],
                    [0, 1],
                ],
            ],
            [
                [
                    [-2, 0],
                    [0, 1],
                ],
            ],
            [
                [
                    [1, 1],
                    [0, -1],
                ],
            ],
            [
                [
                    [-1, 0],
                    [-1, -1],
                ],
            ],
            [
                [
                    [1, 0, 0],
                    [0, 1, 0],
                    [0, 0, 5],
                ],
            ],
            [
                [
                    [-1, 0, 0],
                    [0, 4, 0],
                    [0, 0, 1],
                ],
            ],
            [
                [
                    [1, 3, 0],
                    [0, -1, 0],
                    [0, 0, 1],
                ],
            ],
            [
                [
                    [1, 0, 0],
                    [0, 1, 0],
                    [10, 0, -1],
                ],
            ],
            [
                [
                    [-1, 0, 0],
                    [0, -1, 0],
                    [0, -4, 1],
                ],
            ],
            [
                [
                    [1, 0, 0],
                    [0, 0, 0],
                    [0, 0, -1],
                ],
            ],
            [
                [
                    [1, 2, 3],
                    [0, 1, 0],
                    [0, 0, -1],
                ],
            ],
            [
                [
                    [-1, 0, 5],
                    [0, -1, 6],
                    [0, 0, -7],
                ],
            ],
        ];
    }

    /**
     * @return array [n, matrix]
     */
    public function dataProviderForHilbertMatrix()
    {
        return [
            [   1,
                [
                    [1],
                ],
            ],
            [   2,
                [
                    [1, 1 / 2],
                    [1 / 2, 1 / 3],
                ],
            ],
            [   3,
                [
                    [1, 1 / 2, 1 / 3],
                    [1 / 2, 1 / 3, 1 / 4],
                    [1 / 3, 1 / 4, 1 / 5],
                ],
            ],
            [   4,
                [
                    [1, 1 / 2, 1 / 3, 1 / 4],
                    [1 / 2, 1 / 3, 1 / 4, 1 / 5],
                    [1 / 3, 1 / 4, 1 / 5, 1 / 6],
                    [1 / 4, 1 / 5, 1 / 6, 1 / 7]
                ],
            ],
            [   5,
                [
                    [1, 1 / 2, 1 / 3, 1 / 4, 1 / 5],
                    [1 / 2, 1 / 3, 1 / 4, 1 / 5, 1 / 6],
                    [1 / 3, 1 / 4, 1 / 5, 1 / 6, 1 / 7],
                    [1 / 4, 1 / 5, 1 / 6, 1 / 7, 1 / 8],
                    [1 / 5, 1 / 6, 1 / 7, 1 / 8, 1 / 9],
                ],
            ],
        ];
    }

    public function dataProviderForUpperBidiagonalMatrix()
    {
        return [
            [
                [
                    [1],
                ],
            ],
            [
                [
                    [0],
                ],
            ],
            [
                [
                    [1, 1],
                    [0, 1],
                ],
            ],
            [
                [
                    [-5, 4],
                    [0, 3],
                ],
            ],
            [
                [
                    [1, 1, 0],
                    [0, 1, 1],
                    [0, 0, 1],
                ],
            ],
            [
                [
                    [1, 0, 0],
                    [0, 1, 0],
                    [0, 0, 1],
                ],
            ],
            [
                [
                    [0, 0, 0],
                    [0, 1, 0],
                    [0, 0, 1],
                ],
            ],
            [
                [
                    [0, 0, 0],
                    [0, 0, 0],
                    [0, 0, 0],
                ],
            ],
            [
                [
                    [1, 1, 0, 0],
                    [0, 1, 1, 0],
                    [0, 0, 1, 1],
                    [0, 0, 0, 1],
                ],
            ],
            [
                [
                    [1, 1, 0, 0, 0],
                    [0, 1, 1, 0, 0],
                    [0, 0, 1, 1, 0],
                    [0, 0, 0, 1, 1],
                    [0, 0, 0, 0, 1],
                ],
            ],
            [
                [
                    [1, 3, 0, 0, 0],
                    [0, 2, 4, 0, 0],
                    [0, 0, 3, 5, 0],
                    [0, 0, 0, 4, 6],
                    [0, 0, 0, 0, -6],
                ],
            ],
            [
                [
                    [-1, 4, 0, 0, 0, 0],
                    [0, 2, -5, 0, 0, 0],
                    [0, 0, 3, -4, 0, 0],
                    [0, 0, 0, 4, 3, 0],
                    [0, 0, 0, 0, 5, -1],
                    [0, 0, 0, 0, 0, 6],
                ],
            ],
            [
                [
                    [1, 6, 0, 0, 0, 0],
                    [0, 2, 5, 0, 0, 0],
                    [0, 0, 3, 4, 0, 0],
                    [0, 0, 0, 4, 3, 0],
                    [0, 0, 0, 0, 5, 2],
                    [0, 0, 0, 0, 0, 6],
                ],
            ],
            [
                [
                    [1, 5, 0, 0, 0, 0],
                    [0, 2, 4, 0, 0, 0],
                    [0, 0, 4, 3, 0, 0],
                    [0, 0, 0, 4, 3, 0],
                    [0, 0, 0, 0, 5, 4],
                    [0, 0, 0, 0, 0, 5],
                ],
            ],
        ];
    }

    public function dataProviderForNotUpperBidiagonalMatrix()
    {
        return [
            [
                [
                    [1, 0],
                    [1, 1],
                ],
            ],
            [
                [
                    [-5, 0],
                    [5, 3],
                ],
            ],
            [
                [
                    [1, 1, 1],
                    [0, 1, 1],
                    [0, 0, 1],
                ],
            ],
            [
                [
                    [1, 0, 0],
                    [1, 1, 0],
                    [0, 1, 1],
                ],
            ],
            [
                [
                    [1, 0, 0, 0],
                    [1, 1, 0, 0],
                    [0, 1, 1, 0],
                    [0, 0, 1, 1],
                ],
            ],
            [
                [
                    [1, 0, 0, 0],
                    [1, 1, 0, 0],
                    [1, 1, 1, 0],
                    [0, 0, 1, 1],
                ],
            ],
            [
                [
                    [1, 0, 0, 0],
                    [1, 1, 0, 0],
                    [0, 1, 1, 0],
                    [0, 1, 1, 1],
                ],
            ],
            [
                [
                    [1, 0, 0, 0],
                    [1, 1, 0, 0],
                    [0, 1, 1, 0],
                    [1, 0, 1, 1],
                ],
            ],
            [
                [
                    [1, 0, 0, 0],
                    [1, 1, 0, 0],
                    [1, 1, 1, 0],
                    [1, 1, 1, 1],
                ],
            ],
            [
                [
                    [1, 1, 0, 0],
                    [1, 1, 0, 0],
                    [0, 1, 1, 0],
                    [0, 0, 1, 1],
                ],
            ],
            [
                [
                    [1, 0, 0, 0],
                    [1, 1, 1, 0],
                    [0, 1, 1, 0],
                    [0, 0, 1, 1],
                ],
            ],
            [
                [
                    [1, 0, 1, 0],
                    [1, 1, 0, 0],
                    [0, 1, 1, 0],
                    [0, 0, 1, 1],
                ],
            ],
            [
                [
                    [1, 0, 0, 0],
                    [1, 1, 0, 1],
                    [0, 1, 1, 0],
                    [0, 0, 1, 1],
                ],
            ],
            [
                [
                    [1, 0, 1, 1],
                    [1, 1, 0, 1],
                    [0, 1, 1, 1],
                    [0, 0, 1, 1],
                ],
            ],
            [
                [
                    [1, 1, 1, 0],
                    [0, 1, 1, 0],
                    [0, 0, 1, 1],
                    [0, 0, 0, 1],
                ],
            ],
            [
                [
                    [1, 1, 0, 0],
                    [0, 1, 1, 1],
                    [0, 0, 1, 1],
                    [0, 0, 0, 1],
                ],
            ],
            [
                [
                    [1, 1, 0, 1],
                    [0, 1, 1, 0],
                    [0, 0, 1, 1],
                    [0, 0, 0, 1],
                ],
            ],
            [
                [
                    [1, 1, 1, 1],
                    [0, 1, 1, 1],
                    [0, 0, 1, 1],
                    [0, 0, 0, 1],
                ],
            ],
            [
                [
                    [1, 0, 0, 0, 0],
                    [1, 1, 0, 0, 0],
                    [0, 1, 1, 0, 0],
                    [0, 0, 1, 1, 0],
                    [0, 0, 0, 1, 1],
                ],
            ],
            [
                [
                    [1, 0, 0, 0, 0],
                    [3, 2, 0, 0, 0],
                    [0, 4, 3, 0, 0],
                    [0, 0, 5, 4, 0],
                    [0, 0, 0, 6, -6],
                ],
            ],
            [
                [
                    [-1, 0, 0, 0, 0, 0],
                    [6, 2, 0, 0, 0, 0],
                    [0, -5, 3, 0, 0, 0],
                    [0, 0, 4, 4, 0, 0],
                    [0, 0, 0, -2, 5, 0],
                    [0, 0, 0, 0, 1, 6],
                ],
            ],
            [
                [
                    [1, 0, 0, 0, 0, 0],
                    [7, 2, 0, 0, 0, 0],
                    [0, 6, 3, 0, 0, 0],
                    [0, 0, 5, 4, 0, 0],
                    [0, 0, 0, 4, 5, 0],
                    [0, 0, 0, 0, 3, 6],
                ],
            ],
            [
                [
                    [1, 0, 0, 0, 0, 0],
                    [5, 2, 0, 0, 0, 0],
                    [0, -5, 1, 0, 0, 0],
                    [0, 0, 10, 4, 0, 0],
                    [0, 0, 0, 10, 5, 0],
                    [0, 0, 0, 0, 4, 1],
                ],
            ],
            [
                [
                    [1, 0, 0, 4, 0, 6],
                    [5, 2, 0, 0, 4, 1],
                    [0, -5, 1, 0, 0, 0],
                    [0, 0, 10, 4, 0, 0],
                    [7, 0, 0, 10, 5, 0],
                    [7, 0, 0, 0, 4, 1],
                ],
            ],
            [
                [
                    [1, 1, 0, 3],
                    [0, 1, 1, 3],
                    [0, 1, 1, 3],
                ],
            ],
        ];
    }

    public function dataProviderForLowerBidiagonalMatrix()
    {
        return [
            [
                [
                    [1],
                ],
            ],
            [
                [
                    [1, 0],
                    [1, 1],
                ],
            ],
            [
                [
                    [-5, 0],
                    [5, 3],
                ],
            ],
            [
                [
                    [1, 0, 0],
                    [1, 1, 0],
                    [0, 1, 1],
                ],
            ],
            [
                [
                    [1, 0, 0, 0],
                    [1, 1, 0, 0],
                    [0, 1, 1, 0],
                    [0, 0, 1, 1],
                ],
            ],
            [
                [
                    [1, 0, 0, 0, 0],
                    [1, 1, 0, 0, 0],
                    [0, 1, 1, 0, 0],
                    [0, 0, 1, 1, 0],
                    [0, 0, 0, 1, 1],
                ],
            ],
            [
                [
                    [1, 0, 0, 0, 0],
                    [3, 2, 0, 0, 0],
                    [0, 4, 3, 0, 0],
                    [0, 0, 5, 4, 0],
                    [0, 0, 0, 6, -6],
                ],
            ],
            [
                [
                    [-1, 0, 0, 0, 0, 0],
                    [6, 2, 0, 0, 0, 0],
                    [0, -5, 3, 0, 0, 0],
                    [0, 0, 4, 4, 0, 0],
                    [0, 0, 0, -2, 5, 0],
                    [0, 0, 0, 0, 1, 6],
                ],
            ],
            [
                [
                    [1, 0, 0, 0, 0, 0],
                    [7, 2, 0, 0, 0, 0],
                    [0, 6, 3, 0, 0, 0],
                    [0, 0, 5, 4, 0, 0],
                    [0, 0, 0, 4, 5, 0],
                    [0, 0, 0, 0, 3, 6],
                ],
            ],
            [
                [
                    [1, 0, 0, 0, 0, 0],
                    [5, 2, 0, 0, 0, 0],
                    [0, -5, 1, 0, 0, 0],
                    [0, 0, 10, 4, 0, 0],
                    [0, 0, 0, 10, 5, 0],
                    [0, 0, 0, 0, 4, 1],
                ],
            ],
        ];
    }

    public function dataProviderForNotLowerBidiagonalMatrix()
    {
        return [
            [
                [
                    [1, 1],
                    [0, 1],
                ],
            ],
            [
                [
                    [-5, 4],
                    [0, 3],
                ],
            ],
            [
                [
                    [1, 0, 0],
                    [1, 1, 0],
                    [1, 1, 1],
                ],
            ],
            [
                [
                    [1, 1, 0],
                    [1, 1, 1],
                    [0, 1, 1],
                ],
            ],
            [
                [
                    [1, 1, 0],
                    [0, 1, 1],
                    [0, 0, 1],
                ],
            ],
            [
                [
                    [1, 1, 0, 0],
                    [0, 1, 1, 0],
                    [0, 0, 1, 1],
                    [0, 0, 0, 1],
                ],
            ],
            [
                [
                    [1, 1, 0, 0],
                    [1, 1, 1, 0],
                    [0, 1, 1, 1],
                    [0, 0, 1, 1],
                ],
            ],
            [
                [
                    [1, 0, 0, 0],
                    [1, 1, 0, 0],
                    [1, 1, 1, 0],
                    [0, 0, 1, 1],
                ],
            ],
            [
                [
                    [1, 0, 0, 0],
                    [1, 1, 0, 0],
                    [0, 1, 1, 0],
                    [0, 1, 1, 1],
                ],
            ],
            [
                [
                    [1, 0, 0, 0],
                    [1, 1, 0, 0],
                    [0, 1, 1, 0],
                    [1, 0, 1, 1],
                ],
            ],
            [
                [
                    [1, 0, 0, 0],
                    [1, 1, 0, 0],
                    [1, 1, 1, 0],
                    [1, 1, 1, 1],
                ],
            ],
            [
                [
                    [1, 0, 0, 0],
                    [1, 1, 1, 0],
                    [0, 1, 1, 0],
                    [0, 0, 1, 1],
                ],
            ],
            [
                [
                    [1, 0, 0, 1],
                    [1, 1, 0, 0],
                    [0, 1, 1, 0],
                    [0, 0, 1, 1],
                ],
            ],
            [
                [
                    [1, 1, 0, 0, 0],
                    [0, 1, 1, 0, 0],
                    [0, 0, 1, 1, 0],
                    [0, 0, 0, 1, 1],
                    [0, 0, 0, 0, 1],
                ],
            ],
            [
                [
                    [1, 3, 0, 0, 0],
                    [0, 2, 4, 0, 0],
                    [0, 0, 3, 5, 0],
                    [0, 0, 0, 4, 6],
                    [1, 0, 0, 0, -6],
                ],
            ],
            [
                [
                    [-1, 4, 0, 0, 0, 0],
                    [0, 2, -5, 0, 0, 0],
                    [0, 0, 3, -4, 0, 0],
                    [0, 0, 0, 4, 3, 0],
                    [0, 1, 0, 0, 5, -1],
                    [0, 0, 0, 0, 0, 6],
                ],
            ],
            [
                [
                    [1, 6, 0, 0, 0, 0],
                    [5, 2, 5, 0, 0, 0],
                    [0, 5, 3, 4, 0, 0],
                    [0, 0, 5, 4, 3, 0],
                    [0, 0, 0, 5, 5, 2],
                    [0, 0, 0, 0, 5, 6],
                ],
            ],
            [
                [
                    [1, 5, 0, 0, 0, 4],
                    [5, 2, 4, 0, 0, 4],
                    [5, 0, 4, 3, 0, 0],
                    [5, 0, 0, 4, 3, 0],
                    [5, 0, 0, 0, 5, 4],
                    [5, 0, 0, 0, 0, 5],
                ],
            ],
            [
                [
                    [1, 1, 0, 3],
                    [0, 1, 1, 3],
                    [0, 1, 1, 3],
                ],
            ],
        ];
    }

    public function dataProviderForNotBidiagonalMatrix()
    {
        return [
            [
                [
                    [1, 1],
                    [1, 1],
                ],
            ],
            [
                [
                    [-5, 4],
                    [5, 3],
                ],
            ],
            [
                [
                    [1, 1, 0],
                    [0, 1, 1],
                    [0, 1, 1],
                ],
            ],
            [
                [
                    [1, 1, 0, 0],
                    [0, 1, 1, 0],
                    [0, 0, 1, 1],
                    [0, 1, 0, 1],
                ],
            ],
            [
                [
                    [1, 1, 0, 0],
                    [1, 1, 1, 0],
                    [0, 1, 1, 1],
                    [0, 0, 1, 1],
                ],
            ],
            [
                [
                    [1, 1, 0, 0, 0],
                    [0, 1, 1, 0, 0],
                    [0, 0, 1, 1, 0],
                    [0, 0, 1, 1, 1],
                    [0, 0, 0, 0, 1],
                ],
            ],
            [
                [
                    [1, 3, 0, 0, 0],
                    [0, 2, 4, 0, 0],
                    [0, 0, 3, 5, 0],
                    [0, 0, 0, 4, 6],
                    [1, 0, 0, 03, -6],
                ],
            ],
            [
                [
                    [-1, 4, 0, 0, 0, 0],
                    [0, 2, -5, 0, 0, 0],
                    [0, 0, 3, -4, 0, 0],
                    [0, 0, 0, 4, 3, 0],
                    [0, 1, 0, 0, 5, -1],
                    [0, 0, 0, 0, 0, 6],
                ],
            ],
            [
                [
                    [1, 6, 0, 0, 0, 4],
                    [5, 2, 5, 0, 0, 0],
                    [0, 5, 3, 4, 0, 0],
                    [0, 0, 5, 4, 3, 0],
                    [0, 0, 0, 5, 5, 2],
                    [0, 0, 0, 0, 5, 6],
                ],
            ],
            [
                [
                    [1, 5, 0, 0, 0, 4],
                    [5, 2, 4, 0, 0, 4],
                    [5, 0, 4, 3, 0, 0],
                    [5, 0, 0, 4, 3, 0],
                    [5, 0, 0, 0, 5, 4],
                    [5, 0, 0, 0, 0, 5],
                ],
            ],
            [
                [
                    [1, 1, 0, 3],
                    [0, 1, 1, 3],
                    [0, 1, 1, 3],
                ],
            ],
        ];
    }

    public function dataProviderForTridiagonalMatrix()
    {
        return [
            [
                [
                    [1],
                ],
            ],
            [
                [
                    [1, 1],
                    [1, 1],
                ],
            ],
            [
                [
                    [-5, 4],
                    [6, 3],
                ],
            ],
            [
                [
                    [1, 1, 0],
                    [1, 1, 1],
                    [0, 1, 1],
                ],
            ],
            [
                [
                    [1, 1, 0, 0],
                    [1, 1, 1, 0],
                    [0, 1, 1, 1],
                    [0, 0, 1, 1],
                ],
            ],
            [
                [
                    [0, 0, 0, 0],
                    [0, 0, 0, 0],
                    [0, 0, 0, 0],
                    [0, 0, 0, 0],
                ],
            ],
            [
                [
                    [1, 0, 0, 0],
                    [0, 1, 0, 0],
                    [0, 0, 1, 0],
                    [0, 0, 0, 1],
                ],
            ],
            [
                [
                    [0, 1, 0, 0],
                    [1, 0, 1, 0],
                    [0, 1, 0, 1],
                    [0, 0, 1, 0],
                ],
            ],
            [
                [
                    [0, 1, 0, 0],
                    [0, 0, 1, 0],
                    [0, 1, 0, 1],
                    [0, 0, 0, 0],
                ],
            ],
            [
                [
                    [0, 0, 0, 0],
                    [1, 0, 0, 0],
                    [0, 1, 0, 0],
                    [0, 0, 1, 0],
                ],
            ],
            [
                [
                    [1, 1, 0, 0],
                    [1, 0, 1, 0],
                    [0, 1, 1, 1],
                    [0, 0, 1, 1],
                ],
            ],
            [
                [
                    [1, 1, 0, 0, 0],
                    [1, 1, 1, 0, 0],
                    [0, 1, 1, 1, 0],
                    [0, 0, 1, 1, 1],
                    [0, 0, 0, 1, 1],
                ],
            ],
            [
                [
                    [1, 3, 0, 0, 0],
                    [3, 2, 4, 0, 0],
                    [0, 5, 3, 5, 0],
                    [0, 0, 5, 4, 6],
                    [0, 0, 0, 3, -6],
                ],
            ],
            [
                [
                    [-1, 4, 0, 0, 0, 0],
                    [5, 2, -5, 0, 0, 0],
                    [0, -6, 3, -4, 0, 0],
                    [0, 0, 4, 4, 3, 0],
                    [0, 0, 0, 3, 5, -1],
                    [0, 0, 0, 0, 1, 6],
                ],
            ],
            [
                [
                    [1, 6, 0, 0, 0, 0],
                    [6, 2, 5, 0, 0, 0],
                    [0, 5, 3, 4, 0, 0],
                    [0, 0, 5, 4, 3, 0],
                    [0, 0, 0, 6, 5, 2],
                    [0, 0, 0, 0, 2, 6],
                ],
            ],
            [
                [
                    [1, 5, 0, 0, 0, 0],
                    [5, 2, 4, 0, 0, 0],
                    [0, 4, 4, 3, 0, 0],
                    [0, 0, 3, 4, 3, 0],
                    [0, 0, 0, 2, 5, 4],
                    [0, 0, 0, 0, 3, 5],
                ],
            ],
        ];
    }

    public function dataProviderForNotTridiagonalMatrix()
    {
        return [
            [
                [
                    [1, 1, 1],
                    [0, 1, 1],
                    [0, 0, 1],
                ],
            ],
            [
                [
                    [1, 1, 1, 0],
                    [0, 1, 1, 0],
                    [0, 0, 1, 0],
                ],
            ],
            [
                [
                    [1, 1, 1],
                    [0, 1, 1],
                    [0, 0, 1],
                    [0, 0, 0],
                ],
            ],
            [
                [
                    [1, 0, 0, 0],
                    [1, 1, 0, 0],
                    [1, 1, 1, 0],
                    [1, 1, 1, 1],
                ],
            ],
            [
                [
                    [1, 1, 1, 1],
                    [1, 1, 1, 1],
                    [0, 1, 1, 1],
                    [0, 0, 1, 1],
                ],
            ],
            [
                [
                    [1, 0, 1, 0],
                    [1, 1, 1, 0],
                    [0, 1, 1, 1],
                    [0, 0, 1, 1],
                ],
            ],
            [
                [
                    [1, 1, 0, 0],
                    [1, 1, 1, 0],
                    [0, 1, 1, 1],
                    [1, 0, 1, 0],
                ],
            ],
            [
                [
                    [1, 1, 0, 0],
                    [1, 1, 1, 0],
                    [1, 1, 1, 1],
                    [0, 0, 0, 1],
                ],
            ],
            [
                [
                    [1, 1, 0, 0],
                    [1, 1, 1, 1],
                    [0, 1, 0, 1],
                    [0, 0, 1, 1],
                ],
            ],
            [
                [
                    [1, 1, 1, 1],
                    [1, 1, 1, 0],
                    [0, 0, 1, 1],
                    [0, 0, 1, 1],
                ],
            ],
            [
                [
                    [1, 1, 1, 0],
                    [1, 1, 1, 0],
                    [0, 1, 1, 1],
                    [0, 0, 1, 1],
                ],
            ],
            [
                [
                    [1, 1, 0, 0],
                    [1, 1, 1, 1],
                    [0, 1, 1, 1],
                    [0, 1, 1, 1],
                ],
            ],
            [
                [
                    [1, 1, 0, 1],
                    [1, 1, 1, 0],
                    [0, 1, 1, 1],
                    [1, 0, 1, 1],
                ],
            ],
            [
                [
                    [1, 1, 0, 0],
                    [1, 1, 1, 0],
                    [1, 1, 1, 1],
                    [0, 0, 1, 1],
                ],
            ],
            [
                [
                    [1, 1, 1, 1],
                    [1, 1, 1, 0],
                    [1, 1, 1, 1],
                    [1, 1, 1, 1],
                ],
            ],
            [
                [
                    [1, 1, 0, 0],
                    [1, 1, 1, 0],
                    [0, 1, 1, 1],
                    [1, 0, 1, 1],
                ],
            ],
            [
                [
                    [1, 2, 3, 0, 0],
                    [0, 1, 2, 3, 0],
                    [0, 0, 1, 2, 3],
                    [0, 0, 0, 1, 2],
                    [0, 0, 0, 0, 1],
                ],
            ],
            [
                [
                    [1, 0, 5, 0, 0, 0],
                    [0, 1, 0, 0, 0, 0],
                    [0, 0, 1, 0, 0, 0],
                    [0, 0, 0, 1, 0, 0],
                    [0, 0, 0, 0, 1, 0],
                    [0, 0, 0, 0, 0, 1],
                ],
            ],
            [
                [
                    [1, 1, 0, 0, 0, 0, 0],
                    [1, 1, 1, 0, 0, 0, 5],
                    [0, 1, 1, 1, 0, 0, 0],
                    [0, 0, 1, 1, 1, 0, 0],
                    [0, 0, 0, 1, 1, 1, 0],
                    [0, 0, 0, 0, 1, 1, 1],
                    [0, 0, 0, 0, 0, 1, 1],
                ],
            ],
            [
                [
                    [0, 1, 0, 0, 0, 0, 0, 0],
                    [1, 0, 1, 0, 0, 0, 0, 0],
                    [0, 1, 0, 1, 0, 0, 0, 0],
                    [0, 0, 1, 0, 1, 0, 0, 0],
                    [0, 0, 0, 1, 0, 1, 0, 0],
                    [0, 0, 0, 0, 1, 0, 1, 0],
                    [0, 0, 3, 0, 0, 1, 0, 1],
                    [0, 0, 0, 0, 0, 0, 1, 0],
                ],
            ],
        ];
    }

    public function dataProviderForUpperHessenbergMatrix()
    {
        return [
            [
                [
                    [1],
                ],
            ],
            [
                [
                    [1, 0],
                    [0, 1],
                ],
            ],
            [
                [
                    [1, 1],
                    [1, 1],
                ],
            ],
            [
                [
                    [-5, 1],
                    [0, 3],
                ],
            ],
            [
                [
                    [1, 0, 0],
                    [1, 1, 0],
                    [0, 1, 1],
                ],
            ],
            [
                [
                    [1, 0, 0, 0],
                    [1, 1, 0, 0],
                    [0, 1, 1, 0],
                    [0, 0, 1, 1],
                ],
            ],
            [
                [
                    [1, 1, 0, 0],
                    [1, 1, 1, 0],
                    [0, 1, 1, 1],
                    [0, 0, 1, 1],
                ],
            ],
            [
                [
                    [1, 1, 1, 0],
                    [1, 1, 1, 1],
                    [0, 1, 1, 1],
                    [0, 0, 1, 1],
                ],
            ],
            [
                [
                    [1, 1, 1, 1],
                    [1, 1, 1, 1],
                    [0, 1, 1, 1],
                    [0, 0, 1, 1],
                ],
            ],
            [
                [
                    [1, 0, 0, 0, 0],
                    [1, 1, 0, 0, 0],
                    [0, 1, 1, 0, 0],
                    [0, 0, 1, 1, 0],
                    [0, 0, 0, 1, 1],
                ],
            ],
            [
                [
                    [1, 0, 0, 0, 0],
                    [3, 2, 0, 0, 0],
                    [0, 4, 3, 0, 0],
                    [0, 0, 5, 4, 0],
                    [0, 0, 0, 6, -6],
                ],
            ],
            [
                [
                    [-1, 0, 0, 0, 0, 0],
                    [6, 2, 0, 0, 0, 0],
                    [0, -5, 3, 0, 0, 0],
                    [0, 0, 4, 4, 0, 0],
                    [0, 0, 0, -2, 5, 0],
                    [0, 0, 0, 0, 1, 6],
                ],
            ],
            [
                [
                    [1, 0, 0, 0, 0, 0],
                    [7, 2, 0, 0, 0, 0],
                    [0, 6, 3, 0, 0, 0],
                    [0, 0, 5, 4, 0, 0],
                    [0, 0, 0, 4, 5, 0],
                    [0, 0, 0, 0, 3, 6],
                ],
            ],
            [
                [
                    [1, 0, 0, 0, 0, 0],
                    [5, 2, 0, 0, 0, 0],
                    [0, -5, 1, 0, 0, 0],
                    [0, 0, 10, 4, 0, 0],
                    [0, 0, 0, 10, 5, 0],
                    [0, 0, 0, 0, 4, 1],
                ],
            ],
        ];
    }

    public function dataProviderForNotUpperHessenbergMatrix()
    {
        return [
            [
                [
                    [1, 0, 0, 0],
                    [1, 1, 0, 0],
                    [1, 1, 1, 0],
                ],
            ],
            [
                [
                    [1, 0, 0],
                    [1, 1, 0],
                    [1, 1, 1],
                    [0, 0, 0],
                ],
            ],
            [
                [
                    [1, 0, 0],
                    [1, 1, 0],
                    [1, 1, 1],
                ],
            ],
            [
                [
                    [1, 0, 0, 0],
                    [1, 1, 0, 0],
                    [0, 1, 1, 0],
                    [1, 0, 1, 1],
                ],
            ],
            [
                [
                    [1, 1, 0, 0],
                    [1, 1, 1, 0],
                    [1, 1, 1, 1],
                    [0, 0, 1, 1],
                ],
            ],
            [
                [
                    [1, 1, 1, 0],
                    [1, 1, 1, 1],
                    [0, 1, 1, 1],
                    [0, 1, 1, 1],
                ],
            ],
            [
                [
                    [1, 1, 1, 1],
                    [1, 1, 1, 1],
                    [1, 1, 1, 1],
                    [1, 1, 1, 1],
                ],
            ],
            [
                [
                    [1, 0, 0, 0, 0],
                    [1, 1, 0, 0, 0],
                    [0, 1, 1, 0, 0],
                    [0, 0, 1, 1, 0],
                    [0, 1, 0, 1, 1],
                ],
            ],
            [
                [
                    [1, 0, 0, 0, 0],
                    [3, 2, 0, 0, 0],
                    [0, 4, 3, 0, 0],
                    [1, 0, 5, 4, 0],
                    [0, 0, 0, 6, -6],
                ],
            ],
            [
                [
                    [-1, 0, 0, 0, 0, 0],
                    [6, 2, 0, 0, 0, 0],
                    [0, -5, 3, 0, 0, 0],
                    [0, 0, 4, 4, 0, 0],
                    [0, 0, 0, -2, 5, 0],
                    [1, 0, 0, 0, 1, 6],
                ],
            ],
            [
                [
                    [1, 0, 0, 0, 0, 0],
                    [7, 2, 0, 0, 0, 0],
                    [0, 6, 3, 0, 0, 0],
                    [0, 0, 5, 4, 0, 0],
                    [0, 0, 0, 4, 5, 0],
                    [0, 0, 0, 1, 3, 6],
                ],
            ],
            [
                [
                    [1, 0, 0, 0, 0, 0],
                    [5, 2, 0, 0, 0, 0],
                    [0, -5, 1, 0, 0, 0],
                    [0, 1, 10, 4, 0, 0],
                    [0, 0, 0, 10, 5, 0],
                    [0, 0, 0, 0, 4, 1],
                ],
            ],
        ];
    }

    public function dataProviderForIdentityMatrix()
    {
        return [
            [
                [
                    [1],
                ],
            ],
            [
                [
                    [1, 0],
                    [0, 1],
                ],
            ],
            [
                [
                    [1, 0, 0],
                    [0, 1, 0],
                    [0, 0, 1],
                ],
            ],
            [
                [
                    [1, 0, 0, 0],
                    [0, 1, 0, 0],
                    [0, 0, 1, 0],
                    [0, 0, 0, 1],
                ],
            ],
            [
                [
                    [1, 0, 0, 0, 0],
                    [0, 1, 0, 0, 0],
                    [0, 0, 1, 0, 0],
                    [0, 0, 0, 1, 0],
                    [0, 0, 0, 0, 1],
                ],
            ],
            [
                [
                    [1, 0, 0, 0, 0, 0],
                    [0, 1, 0, 0, 0, 0],
                    [0, 0, 1, 0, 0, 0],
                    [0, 0, 0, 1, 0, 0],
                    [0, 0, 0, 0, 1, 0],
                    [0, 0, 0, 0, 0, 1],
                ],
            ],
            [
                [
                    [1, 0, 0, 0, 0, 0, 0],
                    [0, 1, 0, 0, 0, 0, 0],
                    [0, 0, 1, 0, 0, 0, 0],
                    [0, 0, 0, 1, 0, 0, 0],
                    [0, 0, 0, 0, 1, 0, 0],
                    [0, 0, 0, 0, 0, 1, 0],
                    [0, 0, 0, 0, 0, 0, 1],
                ],
            ],
            [
                [
                    [1, 0, 0, 0, 0, 0, 0, 0],
                    [0, 1, 0, 0, 0, 0, 0, 0],
                    [0, 0, 1, 0, 0, 0, 0, 0],
                    [0, 0, 0, 1, 0, 0, 0, 0],
                    [0, 0, 0, 0, 1, 0, 0, 0],
                    [0, 0, 0, 0, 0, 1, 0, 0],
                    [0, 0, 0, 0, 0, 0, 1, 0],
                    [0, 0, 0, 0, 0, 0, 0, 1],
                ],
            ],
        ];
    }

    public function dataProviderForLowerHessenbergMatrix()
    {
        return [
            [
                [
                    [1],
                ],
            ],
            [
                [
                    [0],
                ],
            ],
            [
                [
                    [1, 1],
                    [1, 1],
                ],
            ],
            [
                [
                    [-5, 4],
                    [5, 3],
                ],
            ],
            [
                [
                    [1, 1, 0],
                    [0, 1, 1],
                    [0, 0, 1],
                ],
            ],
            [
                [
                    [1, 1, 0],
                    [1, 1, 1],
                    [1, 1, 1],
                ],
            ],
            [
                [
                    [1, 0, 0],
                    [0, 1, 0],
                    [0, 0, 1],
                ],
            ],
            [
                [
                    [0, 0, 0],
                    [0, 1, 0],
                    [0, 0, 1],
                ],
            ],
            [
                [
                    [0, 0, 0],
                    [0, 0, 0],
                    [0, 0, 0],
                ],
            ],
            [
                [
                    [1, 1, 0, 0],
                    [0, 1, 1, 0],
                    [0, 0, 1, 1],
                    [0, 0, 0, 1],
                ],
            ],
            [
                [
                    [1, 1, 0, 0, 0],
                    [0, 1, 1, 0, 0],
                    [0, 0, 1, 1, 0],
                    [0, 0, 0, 1, 1],
                    [0, 0, 0, 0, 1],
                ],
            ],
            [
                [
                    [1, 1, 0, 0, 0],
                    [1, 1, 1, 0, 0],
                    [0, 1, 1, 1, 0],
                    [0, 0, 1, 1, 1],
                    [0, 0, 0, 1, 1],
                ],
            ],
            [
                [
                    [1, 1, 0, 0, 0],
                    [1, 1, 1, 0, 0],
                    [1, 1, 1, 1, 0],
                    [0, 1, 1, 1, 1],
                    [0, 0, 1, 1, 1],
                ],
            ],
            [
                [
                    [1, 1, 0, 0, 0],
                    [1, 1, 1, 0, 0],
                    [1, 1, 1, 1, 0],
                    [1, 1, 1, 1, 1],
                    [1, 1, 1, 1, 1],
                ],
            ],
            [
                [
                    [1, 3, 0, 0, 0],
                    [0, 2, 4, 0, 0],
                    [0, 0, 3, 5, 0],
                    [0, 0, 0, 4, 6],
                    [0, 0, 0, 0, -6],
                ],
            ],
            [
                [
                    [-1, 4, 0, 0, 0, 0],
                    [0, 2, -5, 0, 0, 0],
                    [0, 0, 3, -4, 0, 0],
                    [0, 0, 0, 4, 3, 0],
                    [0, 0, 0, 0, 5, -1],
                    [0, 0, 0, 0, 0, 6],
                ],
            ],
            [
                [
                    [1, 6, 0, 0, 0, 0],
                    [0, 2, 5, 0, 0, 0],
                    [0, 0, 3, 4, 0, 0],
                    [0, 0, 0, 4, 3, 0],
                    [0, 0, 0, 0, 5, 2],
                    [0, 0, 0, 0, 0, 6],
                ],
            ],
            [
                [
                    [1, 5, 0, 0, 0, 0],
                    [0, 2, 4, 0, 0, 0],
                    [0, 0, 4, 3, 0, 0],
                    [0, 0, 0, 4, 3, 0],
                    [0, 0, 0, 0, 5, 4],
                    [0, 0, 0, 0, 0, 5],
                ],
            ],
        ];
    }

    public function dataProviderForNotLowerHessenbergMatrix()
    {
        return [
            [
                [
                    [1, 1, 1, 0],
                    [0, 1, 1, 0],
                    [0, 0, 1, 0],
                ],
            ],
            [
                [
                    [1, 1, 1],
                    [0, 1, 1],
                    [0, 0, 1],
                    [0, 0, 0],
                ],
            ],
            [
                [
                    [1, 1, 1],
                    [0, 1, 1],
                    [0, 0, 1],
                ],
            ],
            [
                [
                    [1, 1, 1],
                    [1, 1, 1],
                    [1, 1, 1],
                ],
            ],
            [
                [
                    [1, 0, 1],
                    [0, 1, 1],
                    [0, 0, 1],
                ],
            ],
            [
                [
                    [0, 1, 1],
                    [0, 1, 0],
                    [0, 0, 1],
                ],
            ],
            [
                [
                    [0, 0, 1],
                    [0, 0, 0],
                    [0, 0, 0],
                ],
            ],
            [
                [
                    [1, 1, 1, 0],
                    [0, 1, 1, 0],
                    [0, 0, 1, 1],
                    [0, 0, 0, 1],
                ],
            ],
            [
                [
                    [1, 1, 0, 1, 0],
                    [0, 1, 1, 0, 0],
                    [0, 0, 1, 1, 0],
                    [0, 0, 0, 1, 1],
                    [0, 0, 0, 0, 1],
                ],
            ],
            [
                [
                    [1, 1, 1, 0, 0],
                    [1, 1, 1, 0, 0],
                    [0, 1, 1, 1, 0],
                    [0, 0, 1, 1, 1],
                    [0, 0, 0, 1, 1],
                ],
            ],
            [
                [
                    [1, 1, 0, 0, 1],
                    [1, 1, 1, 0, 0],
                    [1, 1, 1, 1, 0],
                    [0, 1, 1, 1, 1],
                    [0, 0, 1, 1, 1],
                ],
            ],
            [
                [
                    [1, 1, 0, 1, 0],
                    [1, 1, 1, 1, 0],
                    [1, 1, 1, 1, 0],
                    [1, 1, 1, 1, 1],
                    [1, 1, 1, 1, 1],
                ],
            ],
            [
                [
                    [1, 3, 0, 0, 0],
                    [0, 2, 4, 0, 1],
                    [0, 0, 3, 5, 0],
                    [0, 0, 0, 4, 6],
                    [0, 0, 0, 0, -6],
                ],
            ],
            [
                [
                    [-1, 4, 0, 0, 0, 0],
                    [0, 2, -5, 0, 0, 0],
                    [0, 0, 3, -4, 0, 1],
                    [0, 0, 0, 4, 3, 0],
                    [0, 0, 0, 0, 5, -1],
                    [0, 0, 0, 0, 0, 6],
                ],
            ],
            [
                [
                    [1, 6, 0, 0, 0, 0],
                    [0, 2, 5, 0, 0, 0],
                    [0, 0, 3, 4, 1, 0],
                    [0, 0, 0, 4, 3, 0],
                    [0, 0, 0, 0, 5, 2],
                    [0, 0, 0, 0, 0, 6],
                ],
            ],
            [
                [
                    [1, 5, 0, 0, 0, 1],
                    [0, 2, 4, 0, 0, 0],
                    [0, 0, 4, 3, 0, 0],
                    [0, 0, 0, 4, 3, 0],
                    [0, 0, 0, 0, 5, 4],
                    [0, 0, 0, 0, 0, 5],
                ],
            ],
        ];
    }

    public function dataProviderForOrthogonalMatrix()
    {
        return [
            [
                [
                    [1]
                ]
            ],
            [
                [
                    [-1]
                ]
            ],
            [
                [
                    [1, 0],
                    [0, 1],
                ]
            ],
            [
                [
                    [1, 0],
                    [0, -1],
                ]
            ],
            [
                [
                    [-1, 0],
                    [0, 1],
                ]
            ],
            [
                [
                    [0, 1],
                    [1, 0],
                ]
            ],
            [
                [
                    [0.96, -0.28],
                    [0.28, 0.96],
                ]
            ],
            [
                [
                    [0, -0.80, -0.60],
                    [0.80, -0.36, 0.48],
                    [0.60, 0.48, -0.64],
                ]
            ],
            [
                [
                    [0, 0, 0, 1],
                    [0, 0, 1, 0],
                    [1, 0, 0, 0],
                    [0, 1, 0, 0],
                ]
            ],
            [
                [
                    [0, -1, 0],
                    [1, 0, 0],
                    [0, 0, -1],
                ]
            ],
            [
                [
                    [-1, 0, 0],
                    [0, -1, 0],
                    [0, 0, -1],
                ]
            ],
            [
                [
                    [1 / \sqrt(2), 1 / \sqrt(2)],
                    [1 / \sqrt(2), -1 / \sqrt(2)],
                ]
            ],
            [
                [
                    [2 / 3, -2 / 3, 1 / 3],
                    [1 / 3, 2 / 3, 2 / 3],
                    [2 / 3, 1 / 3, -2 / 3],
                ]
            ],
        ];
    }

    public function dataProviderForNonOrthogonalMatrix()
    {
        return [
            // Not square
            [
                [
                    [1],
                    [0],
                ]
            ],
            [
                [
                    [0.96, -0.28, 2],
                    [0.28, 0.96, 5],
                ]
            ],
            // Square but not orthogonal
            [
                [
                    [3, 1],
                    [7, 5],
                ]
            ],
        ];
    }

    public function dataProviderForNonNormalMatrix()
    {
        return [
            // Not square
            [
                [
                    [1],
                    [0],
                ]
            ],
            [
                [
                    [0.96, -0.28, 2],
                    [0.28, 0.96, 5],
                ]
            ],
            // Square but not normal
            [
                [
                    [1, 2, 0],
                    [3, 4, 0],
                    [0, 0, 0],
                ]
            ],
        ];
    }

    public function dataProviderForMatrixWithWeirdNumbers()
    {
        return [
            [
                [
                    [0.0000000000001],
                ]
            ],
            [
                [
                    [0.000000000001, 0.0000000000002],
                    [0.0000000000034, 0.000000000009994387],
                ]
            ],
            [
                [
                    [1 / 2, 1 / 3, 1 / 4],
                    [1 / 5, 1 / 6, 1 / 7],
                    [2 / 3, 3 / 5, 8 / 9],
                ]
            ],
            [
                [
                    [\cos(1), \cos(0), \cos(1.4)],
                    [ \sin(1),  \sin(0),  \sin(1.4)],
                    [\tan(1), \tan(0), \tan(1.4)],
                    [ \sin(\M_PI), \cos(\M_PI), \tan(\M_PI)],
                ]
            ],
            [
                [
                    [\M_PI, \M_2_PI, \M_2_SQRTPI],
                    [\M_E, \M_EULER, \M_LOG2E],
                    [\M_LOG10E, \M_LN2, \M_LNPI],
                ]
            ],
            [
                [
                    [\PHP_INT_MAX, \PHP_INT_MIN],
                    [\INF, -\INF],
                ]
            ]
        ];
    }

    public function dataProviderForBidiagonalMatrix()
    {
        foreach ($this->dataProviderForUpperBidiagonalMatrix() as $matrix) {
            yield $matrix;
        }
        foreach ($this->dataProviderForLowerBidiagonalMatrix() as $matrix) {
            yield $matrix;
        }
    }

    public function dataProviderForSingleMatrix()
    {
        foreach ($this->dataProviderForSquareMatrix() as $matrix) {
            yield $matrix;
        }
        foreach ($this->dataProviderForNotSquareMatrix() as $matrix) {
            yield $matrix;
        }
        foreach ($this->dataProviderForSymmetricMatrix() as $matrix) {
            yield $matrix;
        }
        foreach ($this->dataProviderForNonsingularMatrix() as $matrix) {
            yield $matrix;
        }
        foreach ($this->dataProviderForPositiveDefiniteMatrix() as $matrix) {
            yield $matrix;
        }
        foreach ($this->dataProviderForPositiveSemidefiniteMatrix() as $matrix) {
            yield $matrix;
        }
        foreach ($this->dataProviderForNegativeDefiniteMatrix() as $matrix) {
            yield $matrix;
        }
        foreach ($this->dataProviderForNegativeSemidefiniteMatrix() as $matrix) {
            yield $matrix;
        }
        foreach ($this->dataProviderForUpperTriangularMatrix() as $matrix) {
            yield $matrix;
        }
        foreach ($this->dataProviderForLowerTriangularMatrix() as $matrix) {
            yield $matrix;
        }
        foreach ($this->dataProviderForDiagonalMatrix() as $matrix) {
            yield $matrix;
        }
        foreach ($this->dataProviderForRefMatrix() as $matrix) {
            yield $matrix;
        }
        foreach ($this->dataProviderForRrefMatrix() as $matrix) {
            yield $matrix;
        }
        foreach ($this->dataProviderForInvolutoryMatrix() as $matrix) {
            yield $matrix;
        }
        foreach ($this->dataProviderForUpperBidiagonalMatrix() as $matrix) {
            yield $matrix;
        }
        foreach ($this->dataProviderForLowerBidiagonalMatrix() as $matrix) {
            yield $matrix;
        }
        foreach ($this->dataProviderForBidiagonalMatrix() as $matrix) {
            yield $matrix;
        }
        foreach ($this->dataProviderForIdentityMatrix() as $matrix) {
            yield $matrix;
        }
        foreach ($this->dataProviderForMatrixWithWeirdNumbers() as $matrix) {
            yield $matrix;
        }
    }

    public function dataProviderForObjectMatrix()
    {
        return [
            [
                [
                    [new Polynomial([1, 0])]
                ],
            ],
            [
                [
                    [new Polynomial([1, 0]), new Polynomial([1, 0])]
                ]
            ],
            [
                [
                    [new Polynomial([1, 0]), new Polynomial([0, 0])],
                    [new Polynomial([0, 0]), new Polynomial([1, 0])],
                ]
            ],
        ];
    }

    public function dataProviderForObjectSquareMatrix()
    {
        return [
            [
                [
                    [new Polynomial([1, 0])]
                ],
            ],
            [
                [
                    [new Polynomial([1, 0]), new Polynomial([0, 0])],
                    [new Polynomial([0, 0]), new Polynomial([1, 0])],
                ]
            ],
            [
                [
                    [new Polynomial([1, 0]), new Polynomial([0, 0]), new Polynomial([1, 1])],
                    [new Polynomial([0, 0]), new Polynomial([1, 0]), new Polynomial([1, 1])],
                    [new Polynomial([0, 0]), new Polynomial([1, 0]), new Polynomial([1, 1])],
                ]
            ],
        ];
    }

    public function dataProviderForComplexObjectMatrix()
    {
        return [
            [
                [
                    [new Complex(1, 1)]
                ],
            ],
            [
                [
                    [new Complex(1, 0), new Complex(0, 0)],
                    [new Complex(1, 1), new Complex(2, -3)],
                ]
            ],
            [
                [
                    [new Complex(1, 0), new Complex(0, 0), new Complex(1, 1)],
                    [new Complex(0, 0), new Complex(1, 0), new Complex(1, 1)],
                    [new Complex(0, 0), new Complex(1, 0), new Complex(1, 1)],
                ]
            ],
        ];
    }

    public function dataProviderForComplexSquareObjectMatrix()
    {
        return [
            [
                [
                    [new Complex(1, 1)]
                ],
            ],
            [
                [
                    [new Complex(1, 0), new Complex(0, 0)],
                    [new Complex(1, 1), new Complex(2, -3)],
                ]
            ],
            [
                [
                    [new Complex(1, 0), new Complex(0, 0), new Complex(1, 1)],
                    [new Complex(0, 0), new Complex(1, 0), new Complex(1, 1)],
                    [new Complex(0, 0), new Complex(1, 0), new Complex(1, 1)],
                ]
            ],
            [
                [
                    [new Complex(1, 0), new Complex(0, 0), new Complex(1, 1), new Complex(-3, 2)],
                    [new Complex(0, 3), new Complex(1, 0), new Complex(4, 5), new Complex(7, -2)],
                    [new Complex(3, 0), new Complex(1, 0), new Complex(1, -6), new Complex(4, -8)],
                    [new Complex(5, -1), new Complex(4, 4), new Complex(2, 1), new Complex(-3, 2)],
                ]
            ],
        ];
    }
}
