<?php
require_once LIB_ROOT . '/dataframe/statistics/poisson.php';
require_once LIB_ROOT . '/dataframe/checkdata.php';
require_once LIB_ROOT . '/zendasmath/basic/describe.php';

/* Poisson检验 */
class poissonMethod
{
    /* Method name 分析方法内部名称 */
    public static $name = 'poisson';

    /* Method settings 方法设置参数定义 */
    public static $settings = array();

    /* Diagram config 图表配置项 */
    public static $config = array();

    /* Callback for basic statistic method 基本量统计计算回调函数 */
    public static function func($dataframe, $settings)
    {
        global $dasLang;
        global $lang;

        $var      = $settings['var'];
        $chose    = $settings['chose'];
        $freqLine = $settings['frequency'];

        $check = self::checkData($dataframe, $var, $chose, $freqLine);
        if(isset($check['result']) and $check['result'] == 'fail') return $check;

        $poisson = new poisson($var, $chose, $freqLine, $dasLang->poisson);

        if($chose == 'false')
        {
            $sliceDF = $dataframe->sliceDataframe($dataframe, $var, 'number');
            $poisson->setDataframe($sliceDF);
        }
        else
        {
            $sliceDF = $dataframe->sliceDataframe($dataframe, array($var, $freqLine), 'number');
            $poisson->setDataframe($sliceDF);
        }

        $poisson->setDescriptive();
        $poisson->setObserveGroups();
        $poisson->setTest();


        $allResult = array();
        if($chose == 'true') $allResult[] = $poisson->getMethod();
        $allResult[] = $poisson->getDescriptiveStatistics();
        $allResult[] = $poisson->getTest();

        return $allResult;
    }

    /**
     * Check whether the data meets the requirements.
     *
     * @param  object $dataframe
     * @param  string $dataDesc
     * @param  int    $col1
     * @param  int    $col2
     * @param  int    $col3
     * @param  int    $col4
     * @access public
     * @return object
     */
    public static function checkData($dataframe, $var, $chose, $freqLine)
    {
        global $dasLang;
        $lang = $dasLang->poisson;

        $column = $dataframe->col($var);
        if(!$column->isInt) return array('result' => 'fail', 'message' => sprintf($lang->errorInt, $dataframe->columns[$var]));
        if($column->haveNegative) return array('result' => 'fail', 'message' => sprintf($lang->errorNegative, $dataframe->columns[$var]));
        if(count(array_count_values(Describe::notNull($column->data))) <= 3) return array('result' => 'fail', 'message' => sprintf($lang->errorValue, $dataframe->columns[$var]));

        if($chose == 'true')
        {
            $freqColumn = $dataframe->col($freqLine);
            if($freqColumn->haveString) return array('result' => 'fail', 'message' => sprintf($lang->errorString, $dataframe->columns[$freqLine]));
            if($freqColumn->haveNegative) return array('result' => 'fail', 'message' => sprintf($lang->errorNegative, $dataframe->columns[$freqLine]));
        }
    }

    /**
     * Get settings.
     *
     * @access public
     * @return object
     */
    public static function getSettings()
    {
        global $dasLang;
        $lang = $dasLang->poisson;

        /* Basic settings */
        /* Type settings */
        /* Limit settings */
        /* Col grid settings */
        /* More settings */

        self::$settings['var']       = array('name' => 'var', 'label' => $lang->var, 'type' => 'column', 'listType' => 'column', 'required' => true, 'columnType' => 'number');
        self::$settings['chose']     = array('name' => 'chose', 'label' => $lang->useFrequency, 'type' => 'enum', 'enumOptions' => $lang->choseFrequency, 'defaultValue' => 'false');
        self::$settings['frequency'] = array('name' => 'frequency', 'label' => $lang->frequency, 'type' => 'column', 'listType' => 'column', 'required' => true, 'conditions' => array('chose' => 'true'), 'columnType' => 'number');
        return self::$settings;
    }

    /**
     * Get config.
     *
     * @access public
     * @return object
     */
    public static function getConfig()
    {
        global $dasLang;
        $lang = $dasLang->config;

        //return self::$config;
    }
}
