<?php
require_once LIB_ROOT . '/dataframe/hypothesis/eqvariance.php';
require_once LIB_ROOT . '/dataframe/checkdata.php';
require_once LIB_ROOT . '/dataframe/validatedata.php';

/* 等方差 */
class eqvarianceMethod
{
    /* Method name 分析方法内部名称 */
    public static $name = 'Twosample';

    /* Method settings 方法设置参数定义 */
    public static $settings = array();

    /* Diagram config 图表配置项 */
    public static $config = array();

    /* Callback for basic statistic method 基本量统计计算回调函数 */
    public static function func($dataframe, $settings)
    {
        global $dasLang;

        $stack           = $settings['stack'];
        $response        = $settings['response'];
        $factors         = $settings['factors'];
        $groupedResponse = $settings['groupedResponse'];
        $confidence      = $settings['confidence'];
        //$determine       = $settings['determine'];

        $eqvariance = new eqvariance($stack, $confidence, $dasLang->eqvariance);

        if($stack == 'true')
        {
            $check = new checkData();
            $check->setData($dataframe->colData($response), $dataframe->columns[$response], self::$settings['response']['validate']);
            $check->setDataList($dataframe->colsData($factors), $dataframe->colsName($factors), self::$settings['factors']['validate']);

            $checkRes = $check->check();
            if(is_string($checkRes)) return ValidateData::result($checkRes);

            $columns   = $factors;
            $columns[] = $response;
            $sliceDF = $dataframe->sliceDataframe($dataframe, $columns, 'number');
            $eqvariance->setDF($sliceDF);

            $check = $eqvariance->setStack($response, $factors);
            if(isset($check['result']) and $check['result'] == 'fail') return $check;
        }
        elseif($stack == 'false')
        {
            $check = new checkData();
            $check->setDataList($dataframe->colsData($groupedResponse), $dataframe->colsName($groupedResponse), self::$settings['groupedResponse']['validate']);

            $checkRes = $check->check();
            if(is_string($checkRes)) return ValidateData::result($checkRes);

            $sliceDF = $dataframe->sliceDataframe($dataframe, $groupedResponse, 'number');
            $eqvariance->setDF($sliceDF);
            $eqvariance->setNotStack($groupedResponse);
        }

        if($eqvariance->hasError) return ValidateData::result($dasLang->eqvariance->errorSD);

        $result = array();
        $result[] = $eqvariance->getMethodResult();
        $result[] = $eqvariance->getBonferroniResult();
        $result[] = $eqvariance->getTest();

        return $result;

    }

    /**
     * Get settings.
     *
     * @access public
     * @return object
     */
    public static function getSettings()
    {
        global $dasLang;
        $lang = $dasLang->eqvariance;

        /* Basic settings */
        self::$settings['stack']           = array('name' => 'stack',           'label' => $lang->stack);
        self::$settings['response']        = array('name' => 'response',        'label' => $lang->response,   'required' => true);
        self::$settings['factors']         = array('name' => 'factors',         'label' => $lang->factor,     'required' => true);
        self::$settings['groupedResponse'] = array('name' => 'groupedResponse', 'label' => $lang->response,   'required' => true);
        self::$settings['confidence']      = array('name' => 'confidence',      'label' => $lang->confidence, 'required' => true);

        /* Type settings */
        self::$settings['stack']           += array('type' => 'enum', 'enumOptions' => $lang->stackEnum, 'defaultValue' => 'true');
        self::$settings['response']        += array('type' => 'column', 'listType' => 'column', 'columnType' => 'number');
        self::$settings['factors']         += array('type' => 'list', 'listType' => 'column', 'columnType' => 'number');
        self::$settings['groupedResponse'] += array('type' => 'list', 'listType' => 'column', 'columnType' => 'number');
        self::$settings['confidence']      += array('type' => 'number', 'defaultValue' => 95);

        /* Limit settings */
        self::$settings['response']        += array('conditions' => array('stack' => 'true'), 'distinct' => 'factors');
        self::$settings['factors']         += array('conditions' => array('stack' => 'true'), 'distinct' => 'response');
        self::$settings['groupedResponse'] += array('conditions' => array('stack' => 'false'), 'listLength' => 2);
        self::$settings['confidence']      += array('pattern' => "/^[\+\-]?[\d]+(\.[\d]+)?$/", 'min' => 0.000101, 'max' => 99.999899);

        /* Col grid settings */
        self::$settings['stack']           += array('col' => 6);

        /* More settings */
        self::$settings['confidence']      += array('paramType' => 'more');

        /* Data validate */
        self::$settings['response']        += array('validate' => array('continuous', 'number', 'notCommon', 'N >= 2', 'rowEqual'));
        self::$settings['factors']         += array('validate' => array('continuous', 'columnUnique >= 2', 'rowEqual'));
        self::$settings['groupedResponse'] += array('validate' => array('continuous', 'number', 'notCommon', 'N >= 2'));

        return self::$settings;
    }

    /**
     * Get config.
     *
     * @access public
     * @return object
     */
    public static function getConfig()
    {
        global $dasLang;
        $lang = $dasLang->config;

        //return self::$config;
    }
}
