<?php
require_once LIB_ROOT . '/dataframe/group/scatter.php';
require_once LIB_ROOT . '/zendasmath/basic/combination.php';
require_once LIB_ROOT . '/zendasmath/basic/describe.php';
require_once LIB_ROOT . '/dataframe/checkdata.php';
require_once LIB_ROOT . '/dataframe/validatedata.php';

/* Scatter plot method 基本量统计 */
class scatterPlotMethod
{
    /* Method name 分析方法内部名称 */
    public static $name = 'scatterPlot';

    /* Method settings 方法设置参数定义 */
    public static $settings = array();

    /* Diagram config 图表配置项 */
    public static $config = array();

    /* Callback for basic statistic method 基本量统计计算回调函数 */
    public static function func($dataframe, $settings)
    {
        global $lang;
        global $dasLang;
        $data = array();

        $result = new stdclass();
        $result->type  = 'chart';
        $result->title = '';

        $result->data = array();
        $result->data['type'] = 'scatter';

        $data    = array();
        $type    = $settings['type'];
        $xaxis   = $settings['xaxis'];
        $yaxises = $settings['yaxis'];
        $typeVar = $settings['typeVar'];
        $fit     = $settings['fit'];
        $xName   = $settings['xname'];
        $yName   = $settings['yname'];

        $check = new checkData();
        $check->setData($dataframe->colData($xaxis), $dataframe->columns[$xaxis], self::$settings['xaxis']['validate']);
        $check->setDataList($dataframe->colsData($yaxises), $dataframe->colsName($yaxises), self::$settings['yaxis']['validate']);
        if($type !== 'single') $check->setDataList($dataframe->colsData($typeVar), $dataframe->colsName($typeVar), self::$settings['typeVar']['validate']);

        $checkRes = $check->check();
        if(is_string($checkRes)) return ValidateData::result($checkRes);

        $sliceDF = $dataframe->sliceDataframe($dataframe, array_merge($yaxises, array($xaxis)), $type);
        $scatter = new Scatter($sliceDF, $xaxis, $yaxises, $dasLang->scatter);
        if($type == 'single')
        {
            $scatter->initGroups();
            /*
            $x = $dataframe->col($xaxis, self::columnType('xaxis'));
            $result->yaxisName = array();

            foreach($yaxises as $yaxis)
            {
                $y      = $dataframe->col($yaxis, self::columnType('yaxis'));
                $name   = $dataframe->columns[$yaxis];
                $data[] = array('x' => $x->data, 'y' => $y->data, 'name' => $name, 'mode' => 'markers', 'type' => 'scatter', 'marker' => array('size' => $dataframe->pointSize));
                $result->yaxisName[] = $name;
            }

            $result->xaxisName      = $dataframe->columns[$xaxis];
            $result->yaxisName      = implode('-', $result->yaxisName);
            $result->data['data']   = json_encode($data);
            $result->data['layout'] = array('title' => $settings['title']);
             */

        }
        else
        {
            $scatter->setGroups($typeVar);
        }

        $allResult = array();
        $textResult = $dataframe->getTextResult($dataframe->getChartTitle(array('x' => $xaxis, 'y' => $yaxises), $lang->perfanalysis->methods->graphic['scatterPlot'], 'versus'));
        $textResult->children = 1;
        if($scatter->checkErrorLiner()) $textResult->children ++;

        $allResult[] = $textResult;

        $allResult[] = $scatter->getGroupResult($fit, $xName, $yName);
        if($scatter->checkErrorLiner()) $allResult[] = $scatter->buildErrorLinerResult();

        return $allResult;
    }

    /**
     * Check data.
     *
     * @param object $dataframe
     * @param string $type
     * @param string $xaxis
     * @param array  $yaxises
     * @param array  $typeVar
     * @param string $fit
     * @access public
     * @return object
     */
    public static function checkData($dataframe, $type, $xaxis, $yaxises, $typeVar, $fit)
    {
        global $dasLang;
        $lang = $dasLang->scatter;

        $allColumns   = $yaxises;
        $allColumns[] = $xaxis;
        if($type == 'single')
        {
            $check = checkNullColumns($dataframe, $allColumns, $dasLang->common->errorLine);
            if($check['result'] == 'fail') return $check;

            $check = checkColumnsLengthSame($dataframe, $allColumns, $dasLang->common->notSameLine);
            if($check['result'] == 'fail') return $check;

            if(in_array($xaxis, $yaxises)) return array('result' => 'fail', 'message' => sprintf($lang->errorRepeat, $dataframe->columns[$xaxis]));
        }
        else
        {
            $check = checkNullColumns($dataframe, array_merge($allColumns, $typeVar), $dasLang->common->errorLine);
            if($check['result'] == 'fail') return $check;

            if(in_array($xaxis, $yaxises)) return array('result' => 'fail', 'message' => sprintf($lang->errorRepeat, $dataframe->columns[$xaxis]));

            foreach($typeVar as $var)
            {
                if(in_array($var, $allColumns)) return array('result' => 'fail', 'message' => sprintf($lang->errorLine, $dataframe->columns[$var]));
            }

            if(count($typeVar) > 3) return array('result' => 'fail', 'message' => $lang->beyondLine);
        }

        if($type == 'group') $check = checkColumnsLengthSame($dataframe, array_merge($allColumns, $typeVar), $dasLang->common->notSameLine);
        if($check['result'] == 'fail') return $check;

        $check = checkColumnsHasEmpty($dataframe, $allColumns, $dasLang->common->haveEmptyLine);
        if($check['result'] == 'fail') return $check;

        $check = checkColumnsHasString($dataframe, $allColumns, $dasLang->common->haveStringLine);
        if($check['result'] == 'fail') return $check;

        return array('result' => 'success');
    }

    /**
     * Get settings.
     *
     * @param object $lang
     * @access public
     * @return object
     */
    public static function getSettings()
    {
        global $dasLang;
        $lang = $dasLang->scatter;

        /* Basic settings */
        /* Type settings */
        /* Limit settings */
        /* Col grid settings */
        /* More settings */

        self::$settings['type']    = array('name' => 'type', 'label' => $lang->type, 'type' => 'enum', 'col' => 6, 'enumOptions' => $lang->typeEnum, 'columnType' => 'any', 'defaultValue' => 'single');
        self::$settings['xaxis']   = array('name' => 'xaxis', 'label' => $lang->xaxis, 'type' => 'column', 'required' => true, 'columnType' => 'any');
        self::$settings['yaxis']   = array('name' => 'yaxis', 'label' => $lang->yaxis, 'type' => 'list', 'listType' => 'column', 'required' => true, 'columnType' => 'number', 'distinct' => 'xaxis');
        self::$settings['typeVar'] = array('name' => 'typeVar', 'label' => $lang->typeVar, 'type' => 'list', 'conditions' => array('type' => 'group'), 'listType' => 'column', 'required' => true, 'columnType' => 'any');
        self::$settings['fit']     = array('name' => 'fit', 'label' => $lang->fit, 'type' => 'enum', 'col' => 6, 'enumOptions' => $lang->fitEnum, 'columnType' => 'any', 'defaultValue' => 'hide');
        self::$settings['xname']   = array('name' => 'xname', 'type' => 'any', 'label' => $dasLang->xAxisName, 'paramType' => 'more');
        self::$settings['yname']   = array('name' => 'yname', 'type' => 'any', 'label' => $dasLang->yAxisName, 'paramType' => 'more');

        /* Data validate */
        self::$settings['xaxis']   += array('validate' => array('continuous', 'number', 'rowEqual'));
        self::$settings['yaxis']   += array('validate' => array('continuous', 'number', 'rowEqual'));
        self::$settings['typeVar'] += array('validate' => array('continuous', 'columnUnique >= 2', 'rowEqual'));

        return self::$settings;
    }

    /**
     * Get config.
     *
     * @access public
     * @return object
     */
    public static function getConfig()
    {
        global $dasLang;
        $lang = $dasLang->config;
        self::$config['grid']   = $lang->gridConfig;
        self::$config['label']  = $lang->labelConfig;
        self::$config['legend'] = $lang->legendConfig;
        self::$config['title']  = array('name' => 'title', 'label' => $lang->title, 'type' => 'checkbox', 'enumOptions' => $lang->titleEnum, 'defaultValue' => '');

        return self::$config;
    }

    /**
     * Get Setting column type.
     *
     * @param string $index
     * @access public
     * @return string
     */
    public static function columnType($index)
    {
        return self::$settings[$index]['columnType'];
    }
}
scatterPlotMethod::$config['grid']  = true;
scatterPlotMethod::$config['label'] = true;
scatterPlotMethod::$config['title'] = array('xaxis', 'yaxis');
