<?php
require_once LIB_ROOT . '/dataframe/checkdata.php';
require_once LIB_ROOT . '/dataframe/validatedata.php';

/* Bar plot method 基本量统计 */
class barPlotMethod
{
    /* Method name 分析方法内部名称 */
    public static $name = 'barPlot';

    /* Method settings 方法设置参数定义 */
    public static $settings = array();

    /* Diagram config 图表配置项 */
    public static $config = array();

    /* Callback for basic statistic method 基本量统计计算回调函数 */
    public static function func($dataframe, $settings)
    {
        global $lang;
        global $dasLang;
        $data = array();

        $result = new stdclass();
        $result->type  = 'chart';
        $result->title = '';

        $result->data = array();
        $result->data['type'] = 'bar';

        $data        = array();
        $xaxis       = $settings['xaxis'];
        $yaxis       = $settings['yaxis'];
        $xName       = $settings['xname'];
        $yName       = $settings['yname'];
        $x           = $dataframe->col($xaxis, 'any');

        $check = new checkData();
        $check->setData($dataframe->colData($xaxis), $dataframe->columns[$xaxis], self::$settings['xaxis']['validate']);
        $check->setDataList($dataframe->colsData($yaxis), $dataframe->colsName($yaxis), self::$settings['yaxis']['validate']);

        $checkRes = $check->check();
        if(is_string($checkRes)) return ValidateData::result($checkRes);

        $xData = array_values(array_unique($x->trimdata));

        foreach($settings['yaxis'] as $yaxis)
        {
            if($yaxis == $xaxis) continue;

            $yData = array();
            $y     = $dataframe->col($yaxis, 'number');
            $name  = $dataframe->columns[$yaxis];

            foreach($y->trimdata as $index => $value)
            {
                $key = $x->trimdata[$index];
                if(!isset($yData[$key])) $yData[$key] = 0;
                $yData[$key] += $value;
            }

            $data[] = array('hoverinfo' => 'y', 'x' => $xData, 'y' => array_values($yData), 'name' => $name, 'type' => 'bar', 'text' => $yData, 'textposition' => 'auto' );
        }

        $result->data['data']   = json_encode($data);
        $result->data['layout'] = array('title' => $settings['title'], 'xaxis' => array('title' => !empty($xName) ? $xName : $dataframe->columns[$xaxis]), 'yaxis' => array('title' => $yName));

        $grid   = $dasLang->config->gridConfig;
        $title  = $dasLang->config->titleConfig;
        $legend = $dasLang->config->legendConfig;
        $legend['defaultValue'] = 'true';
        $result->data['config'] = array('grid' => $grid, 'title' => $title, 'legend' => $legend);

        $textResult = $dataframe->getTextResult($dataframe->getChartTitle(array('x' => $settings['xaxis'], 'y' => $settings['yaxis']), $lang->perfanalysis->methods->graphic['barPlot'], 'versus'));
        $textResult->children = 1;

        return array($textResult, $result);
    }

    /**
     * Get settings.
     *
     * @param object $lang
     * @access public
     * @return object
     */
    public static function getSettings()
    {
        global $dasLang;
        $lang = $dasLang->bar;

        /* Basic settings */
        self::$settings['xaxis'] = array('name' => 'xaxis', 'label' => $lang->xaxis, 'required' => true);
        self::$settings['yaxis'] = array('name' => 'yaxis', 'label' => $lang->yaxis, 'required' => true);
        self::$settings['xname'] = array('name' => 'xname', 'label' => $dasLang->xAxisName);
        self::$settings['yname'] = array('name' => 'yname', 'label' => $dasLang->yAxisName);

        /* Type settings */
        self::$settings['xaxis'] += array('type' => 'column', 'columnType' => 'any');
        self::$settings['yaxis'] += array('type' => 'list',   'listType' => 'column', 'columnType' => 'number');
        self::$settings['xname'] += array('type' => 'any');
        self::$settings['yname'] += array('type' => 'any');

        /* Limit settings */
        self::$settings['yaxis'] += array('distinct' => 'xaxis');

        /* Col grid settings */

        /* More settings */
        self::$settings['xname'] += array('paramType' => 'more');
        self::$settings['yname'] += array('paramType' => 'more');

        /* Data validate */
        self::$settings['xaxis'] += array('validate' => array('continuous', 'rowEqual'));
        self::$settings['yaxis'] += array('validate' => array('continuous', 'number', 'rowEqual'));

        return self::$settings;
    }

    /**
     * Get config.
     *
     * @access public
     * @return object
     */
    public static function getConfig()
    {
        global $dasLang;
        $lang = $dasLang->config;
        self::$config['grid']        = $lang->gridConfig;
        self::$config['label']       = $lang->labelConfig;
        self::$config['legend']      = $lang->legendConfig;
        self::$config['orientation'] = array('name' => 'orientation', 'label' => $lang->orientation, 'type' => 'radio', 'enumOptions' => $lang->orientationEnum, 'defaultValue' => 'v');

        return self::$config;
    }
}
